/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.xml;

import java.io.File;
import java.io.InputStream;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;
import pl.baczkowicz.spy.exceptions.XMLException;
import pl.baczkowicz.spy.xml.XMLParser;

public class XMLSchemaUtils {
    public static Schema createSchema(String schemaLocation) throws XMLException {
        Schema schema = null;
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            File file = new File(schemaLocation);
            if (file.exists()) {
                schema = schemaFactory.newSchema(file);
            } else {
                InputStream resourceAsStream = XMLParser.class.getResourceAsStream(schemaLocation);
                if (resourceAsStream == null) {
                    throw new XMLException("Cannot load the schema from file or classpath - fix the schema or amend the location: " + schemaLocation);
                }
                schema = schemaFactory.newSchema(new StreamSource(resourceAsStream));
            }
            return schema;
        }
        catch (SAXException e) {
            throw new XMLException("Cannot set the schema - please fix the schema or the location", e);
        }
    }

    public static Schema createSchema(String[] resourceLocations) throws XMLException {
        if (resourceLocations == null) {
            throw new XMLException("Schema file locations not specified");
        }
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = null;
        Source[] schemaSources = new Source[resourceLocations.length];
        try {
            for (int i = 0; i < resourceLocations.length; ++i) {
                String resourceLocation = resourceLocations[i];
                if (resourceLocation == null) {
                    throw new XMLException("Schema file location not specified");
                }
                File file = new File(resourceLocation);
                if (file.exists()) {
                    schemaSources[i] = new StreamSource(file);
                    continue;
                }
                InputStream resourceAsStream = XMLSchemaUtils.class.getResourceAsStream(resourceLocation);
                if (resourceAsStream == null) {
                    throw new XMLException("Cannot load the schema from file or classpath - fix the schema or amend the location: " + resourceLocation);
                }
                schemaSources[i] = new StreamSource(resourceAsStream);
            }
            schema = schemaFactory.newSchema(schemaSources);
            return schema;
        }
        catch (SAXException e) {
            throw new XMLException("Cannot set the schema - fix the schema or the location", e);
        }
    }
}

