/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadingUtils {
    private static final Logger logger = LoggerFactory.getLogger(ThreadingUtils.class);
    private static final String STARTING_THREAD = "Starting thread ID=%s \"%s\" ...";
    private static final String ENDING_THREAD = "Ending thread ID=%s \"%s\" ...";
    private static String APP_NAME = "mqtt-spy";

    private static void logThreadStarting() {
        if (logger.isTraceEnabled()) {
            logger.trace(String.format(STARTING_THREAD, Thread.currentThread().getId(), Thread.currentThread().getName()));
        }
    }

    public static void logThreadStarting(String threadName) {
        Thread.currentThread().setName(APP_NAME + " [" + threadName + "]");
        ThreadingUtils.logThreadStarting();
    }

    public static void logThreadEnding() {
        if (logger.isTraceEnabled()) {
            logger.trace(String.format(ENDING_THREAD, Thread.currentThread().getId(), Thread.currentThread().getName()));
        }
    }

    public static boolean sleep(long milliseconds) {
        try {
            Thread.sleep(milliseconds);
            return false;
        }
        catch (InterruptedException e) {
            logger.warn("Thread {} has been interrupted", (Object)Thread.currentThread().getName(), (Object)e);
            return true;
        }
    }

    public static void setAppName(String name) {
        APP_NAME = name;
    }
}

