/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.ui.versions;

import java.io.IOException;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import pl.baczkowicz.spy.configuration.PropertyFileLoader;
import pl.baczkowicz.spy.exceptions.XMLException;
import pl.baczkowicz.spy.ui.controlpanel.ItemStatus;
import pl.baczkowicz.spy.ui.generated.versions.ReleaseStatus;
import pl.baczkowicz.spy.ui.generated.versions.SpyVersions;
import pl.baczkowicz.spy.ui.properties.VersionInfoProperties;
import pl.baczkowicz.spy.xml.XMLParser;

public class VersionManager
extends XMLParser {
    private static final String PACKAGE = "pl.baczkowicz.spy.ui.generated.versions";
    private static final String SCHEMA = "/spy-versions.xsd";
    private PropertyFileLoader propertyLoader;
    private SpyVersions versions;
    private boolean loading = false;
    private String currentRelease;

    public VersionManager(PropertyFileLoader propertyLoader) throws XMLException {
        super(PACKAGE, SCHEMA);
        this.propertyLoader = propertyLoader;
        this.versions = new SpyVersions();
        this.currentRelease = propertyLoader.getFullVersionNumber();
    }

    public SpyVersions loadVersions() throws XMLException {
        this.setLoading(true);
        String urlString = this.propertyLoader.getProperty("application.update.url") + "?current=" + this.currentRelease;
        try {
            URL url = new URL(urlString);
            String xml = IOUtils.toString(url.openStream());
            this.versions = (SpyVersions)this.loadFromString(xml);
        }
        catch (IOException | NullPointerException e) {
            throw new XMLException("Cannot read version info from " + urlString, e);
        }
        this.setLoading(false);
        return this.versions;
    }

    public SpyVersions getVersions() {
        return this.versions;
    }

    public static boolean isInRange(String currentRelease, ReleaseStatus release) {
        return new DefaultArtifactVersion(currentRelease).compareTo(new DefaultArtifactVersion(release.getFromVersion())) >= 0 && new DefaultArtifactVersion(currentRelease).compareTo(new DefaultArtifactVersion(release.getToVersion())) <= 0;
    }

    public static ItemStatus convertVersionStatus(ReleaseStatus release) {
        switch (release.getUpdateStatus()) {
            case CRITICAL: {
                return ItemStatus.ERROR;
            }
            case UPDATE_RECOMMENDED: {
                return ItemStatus.WARN;
            }
            case NEW_AVAILABLE: {
                return ItemStatus.INFO;
            }
            case ON_LATEST: {
                return ItemStatus.OK;
            }
        }
        return ItemStatus.ERROR;
    }

    public VersionInfoProperties getVersionInfoProperties(PropertyFileLoader propertyFileLoader) {
        VersionInfoProperties properties = new VersionInfoProperties();
        if (this.getVersions() != null) {
            boolean versionFound = false;
            for (ReleaseStatus release : this.getVersions().getReleaseStatuses().getReleaseStatus()) {
                if (!VersionManager.isInRange(this.currentRelease, release)) continue;
                properties.setStatus(VersionManager.convertVersionStatus(release));
                properties.setTitle(VersionManager.replaceTokens(release.getUpdateTitle(), propertyFileLoader));
                properties.setDetails(VersionManager.replaceTokens(release.getUpdateDetails(), propertyFileLoader));
                versionFound = true;
                break;
            }
            if (!versionFound) {
                properties.setStatus(ItemStatus.INFO);
                properties.setTitle("Couldn't find any information about your version - please check manually.");
                properties.setDetails("Your version is " + propertyFileLoader.getFullVersionName() + ".");
            }
        } else {
            properties.setStatus(ItemStatus.WARN);
            properties.setTitle("Cannot check for updates - is your internet connection up?");
            properties.setDetails("Click here to go to the download page for mqtt-spy.");
        }
        return properties;
    }

    public static String replaceTokens(String value, PropertyFileLoader propertyFileLoader) {
        return value.replace("[newline]", System.lineSeparator()).replace("[version]", propertyFileLoader.getFullVersionName());
    }

    public boolean isLoading() {
        return this.loading;
    }

    public void setLoading(boolean loading) {
        this.loading = loading;
    }
}

