/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.ui.utils;

import java.util.Map;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.layout.HBox;
import pl.baczkowicz.spy.ui.utils.ImageUtils;

public class UiUtils {
    public static final String MODIFIED_ITEM = "* ";

    public static void copyToClipboard(String value) {
        ClipboardContent content = new ClipboardContent();
        content.putString(value);
        Clipboard.getSystemClipboard().setContent((Map)content);
    }

    public static HBox createSecurityIcons(boolean tlsEnabled, boolean userAuthEnabled, boolean showBothStates) {
        HBox icons = new HBox();
        UiUtils.createTlsIcon(icons, tlsEnabled, showBothStates);
        UiUtils.createAuthIcon(icons, userAuthEnabled, showBothStates);
        return icons;
    }

    public static void createTlsIcon(HBox icons, boolean tlsEnabled, boolean showBothStates) {
        if (tlsEnabled) {
            icons.getChildren().add((Object)ImageUtils.createIcon("lock-yes", 16));
        } else if (!tlsEnabled && showBothStates) {
            icons.getChildren().add((Object)ImageUtils.createIcon("lock-no", 16));
        }
    }

    public static void createAuthIcon(HBox icons, boolean userAuthEnabled, boolean showBothStates) {
        if (userAuthEnabled) {
            icons.getChildren().add((Object)ImageUtils.createIcon("auth-yes", 19));
        } else if (!userAuthEnabled && showBothStates) {
            icons.getChildren().add((Object)ImageUtils.createIcon("auth-none", 19));
        }
    }
}

