/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.ui.testcases;

import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import pl.baczkowicz.spy.scripts.BaseScriptManagerInterface;
import pl.baczkowicz.spy.scripts.ScriptRunningState;
import pl.baczkowicz.spy.testcases.TestCase;
import pl.baczkowicz.spy.testcases.TestCaseManager;
import pl.baczkowicz.spy.testcases.TestCaseStatus;
import pl.baczkowicz.spy.testcases.TestCaseStep;
import pl.baczkowicz.spy.ui.controllers.TestCaseExecutionController;
import pl.baczkowicz.spy.ui.controllers.TestCasesExecutionController;
import pl.baczkowicz.spy.ui.properties.TestCaseProperties;
import pl.baczkowicz.spy.utils.ThreadingUtils;

public class InteractiveTestCaseManager
extends TestCaseManager {
    private TestCaseExecutionController testCaseExecutionController;
    private List<TestCaseProperties> testCasesProperties = new ArrayList<TestCaseProperties>();
    private List<TestCaseProperties> enqueuedtestCases = new ArrayList<TestCaseProperties>();
    private TestCasesExecutionController testCasesExecutionController;

    public InteractiveTestCaseManager(BaseScriptManagerInterface scriptManager, TestCasesExecutionController testCasesExecutionController, TestCaseExecutionController testCaseExecutionController) {
        super(scriptManager);
        this.testCaseExecutionController = testCaseExecutionController;
        this.testCasesExecutionController = testCasesExecutionController;
    }

    @Override
    public void loadTestCases(String testCaseLocation) {
        this.testCasesProperties.clear();
        super.loadTestCases(testCaseLocation);
        for (TestCase testCase : this.getTestCases()) {
            TestCaseProperties testCaseProperties = new TestCaseProperties(testCase);
            this.testCasesProperties.add(testCaseProperties);
            testCase.setObserver(testCaseProperties);
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                ThreadingUtils.logThreadStarting("runEnqueuedTestCases");
                while (true) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    if (InteractiveTestCaseManager.this.enqueuedtestCases.size() <= 0 || InteractiveTestCaseManager.this.running != 0) continue;
                    InteractiveTestCaseManager.this.runTestCase((TestCaseProperties)InteractiveTestCaseManager.this.enqueuedtestCases.remove(0));
                }
                ThreadingUtils.logThreadEnding();
            }
        }).start();
    }

    public void runTestCase(TestCaseProperties selectedTestCase) {
        super.getOptions().setAutoExport(this.testCaseExecutionController.isAutoExportEnabled());
        final TestCase testCase = selectedTestCase.getScript();
        testCase.setStatusAndNotify(ScriptRunningState.RUNNING);
        testCase.setTestCaseStatus(TestCaseStatus.IN_PROGRESS);
        for (TestCaseStep step : testCase.getSteps()) {
            step.setStatus(TestCaseStatus.NOT_RUN);
            step.setExecutionInfo("");
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                InteractiveTestCaseManager.this.runAllTestCaseMethods(testCase);
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        InteractiveTestCaseManager.this.testCaseExecutionController.refreshState();
                        InteractiveTestCaseManager.this.testCasesExecutionController.refreshInfo();
                    }
                });
            }
        }).start();
    }

    public void stopTestCase(TestCaseProperties testCaseProperties) {
        this.stopTestCase(testCaseProperties.getScript());
    }

    public void enqueueAllTestCases() {
        this.enqueuedtestCases.addAll(this.testCasesProperties);
    }

    public void enqueueTestCase(TestCaseProperties testCaseProperties) {
        this.enqueuedtestCases.add(testCaseProperties);
    }

    public void enqueueAllNotRun() {
        for (TestCaseProperties testCase : this.getTestCasesProperties()) {
            if (!((TestCaseStatus)((Object)testCase.statusProperty().getValue())).equals((Object)TestCaseStatus.NOT_RUN)) continue;
            this.enqueuedtestCases.add(testCase);
        }
    }

    public void enqueueAllFailed() {
        for (TestCaseProperties testCase : this.getTestCasesProperties()) {
            if (!((TestCaseStatus)((Object)testCase.statusProperty().getValue())).equals((Object)TestCaseStatus.FAILED)) continue;
            this.enqueuedtestCases.add(testCase);
        }
    }

    public void clearEnqueued() {
        this.enqueuedtestCases.clear();
    }

    public int getEnqueuedCount() {
        return this.enqueuedtestCases.size();
    }

    public List<TestCaseProperties> getTestCasesProperties() {
        return this.testCasesProperties;
    }
}

