/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.ui.storage.summary;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.spy.common.generated.FormatterDetails;
import pl.baczkowicz.spy.messages.BaseMessage;
import pl.baczkowicz.spy.messages.FormattedMessage;
import pl.baczkowicz.spy.messages.IBaseMessage;
import pl.baczkowicz.spy.ui.properties.SubscriptionTopicSummaryProperties;
import pl.baczkowicz.spy.ui.storage.summary.TopicMessageCount;

public class TopicSummary<T extends FormattedMessage>
extends TopicMessageCount {
    private static final Logger logger = LoggerFactory.getLogger(TopicSummary.class);
    protected Map<String, SubscriptionTopicSummaryProperties<T>> topicToSummaryMapping = new HashMap<String, SubscriptionTopicSummaryProperties<T>>();
    protected FormatterDetails messageFormat;
    private int maxPayloadLength;

    public TopicSummary(String name, int maxPayloadLength) {
        super(name);
        this.maxPayloadLength = maxPayloadLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Map<String, SubscriptionTopicSummaryProperties<T>> map = this.topicToSummaryMapping;
        synchronized (map) {
            super.clear();
            this.topicToSummaryMapping.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessage(IBaseMessage message) {
        Map<String, SubscriptionTopicSummaryProperties<T>> map = this.topicToSummaryMapping;
        synchronized (map) {
            SubscriptionTopicSummaryProperties<T> item = this.topicToSummaryMapping.get(message.getTopic());
            if (item != null) {
                item.setCount(item.countProperty().intValue() - 1);
            } else {
                logger.error("[{}] Found empty value for topic {}", (Object)this.name, (Object)message.getTopic());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubscriptionTopicSummaryProperties<T> addMessage(T message, AtomicBoolean newAdded) {
        Map<String, SubscriptionTopicSummaryProperties<T>> map = this.topicToSummaryMapping;
        synchronized (map) {
            SubscriptionTopicSummaryProperties<T> item = this.topicToSummaryMapping.get(((BaseMessage)message).getTopic());
            if (item == null) {
                item = new SubscriptionTopicSummaryProperties<T>(false, 1, message, this.maxPayloadLength);
                this.topicToSummaryMapping.put(((BaseMessage)message).getTopic(), item);
                newAdded.set(true);
            } else {
                item.setCount(item.countProperty().intValue() + 1);
                item.setMessage(message);
            }
            logger.trace("[{}] has {} messages", (Object)this.name, (Object)item.countProperty().intValue());
            return item;
        }
    }

    public void setFormatter(FormatterDetails messageFormat) {
        this.messageFormat = messageFormat;
    }
}

