/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.ui.storage.summary;

import java.util.HashMap;
import java.util.Map;
import pl.baczkowicz.spy.messages.IBaseMessage;

public class TopicMessageCount {
    private Map<String, Integer> messageCountPerTopic = new HashMap<String, Integer>();
    protected final String name;

    public TopicMessageCount(String name) {
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<String, Integer> map = this.messageCountPerTopic;
        synchronized (map) {
            this.messageCountPerTopic.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCountForTopic(String topic) {
        Map<String, Integer> map = this.messageCountPerTopic;
        synchronized (map) {
            if (this.messageCountPerTopic.get(topic) != null) {
                return this.messageCountPerTopic.get(topic);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increaseCount(IBaseMessage message) {
        Map<String, Integer> map = this.messageCountPerTopic;
        synchronized (map) {
            Integer value = this.messageCountPerTopic.get(message.getTopic());
            if (value == null) {
                this.messageCountPerTopic.put(message.getTopic(), 1);
            } else {
                this.messageCountPerTopic.put(message.getTopic(), value + 1);
            }
        }
    }

    public void decreaseCount(IBaseMessage message) {
        Integer value = this.messageCountPerTopic.get(message.getTopic());
        if (value == null) {
            this.messageCountPerTopic.put(message.getTopic(), 0);
        } else {
            this.messageCountPerTopic.put(message.getTopic(), value - 1);
        }
    }
}

