/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.ui.storage;

import java.util.List;
import pl.baczkowicz.spy.messages.FormattedMessage;
import pl.baczkowicz.spy.ui.events.queuable.EventQueueManager;
import pl.baczkowicz.spy.ui.events.queuable.ui.BrowseRemovedMessageEvent;
import pl.baczkowicz.spy.ui.events.queuable.ui.TopicSummaryRemovedMessageEvent;
import pl.baczkowicz.spy.ui.storage.ManagedMessageStoreWithFiltering;
import pl.baczkowicz.spy.ui.storage.MessageListWithObservableTopicSummary;
import pl.baczkowicz.spy.utils.ThreadingUtils;

public class MessageStoreGarbageCollector<T extends FormattedMessage>
implements Runnable {
    protected final EventQueueManager<T> uiEventQueue;
    private MessageListWithObservableTopicSummary<T> messages;
    private int minMessagesPerTopic;
    private boolean createTopicSummaryEvents;
    private boolean createBrowseEvents;
    private ManagedMessageStoreWithFiltering<T> store;
    private boolean running;

    public MessageStoreGarbageCollector(ManagedMessageStoreWithFiltering<T> store, MessageListWithObservableTopicSummary<T> messages, EventQueueManager<T> uiEventQueue, int minMessages, boolean createTopicSummaryEvents, boolean createBrowseEvents) {
        this.messages = messages;
        this.uiEventQueue = uiEventQueue;
        this.minMessagesPerTopic = minMessages;
        this.createTopicSummaryEvents = createTopicSummaryEvents;
        this.createBrowseEvents = createBrowseEvents;
        this.store = store;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    private void checkAndRemove(boolean shouldRemove) {
        for (int i = this.messages.getMessages().size() - 1; i >= 0; --i) {
            FormattedMessage element = (FormattedMessage)this.messages.getMessages().get(i);
            int count = this.messages.getTopicSummary().getCountForTopic(element.getTopic());
            if (count <= this.minMessagesPerTopic) continue;
            this.messages.remove(i);
            shouldRemove = this.messages.exceedingPreferredSize();
            if (this.createTopicSummaryEvents) {
                this.uiEventQueue.add(this.store, new TopicSummaryRemovedMessageEvent<FormattedMessage>(this.messages, element));
            }
            if (this.createBrowseEvents) {
                this.uiEventQueue.add(this.store, new BrowseRemovedMessageEvent<FormattedMessage>(this.messages, element, i + 1));
            }
            if (!shouldRemove) break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.running = true;
        ThreadingUtils.logThreadStarting("Message Store Garbage Collector for " + this.messages.getName());
        while (this.running && !ThreadingUtils.sleep(1000L)) {
            List list = this.messages.getMessages();
            synchronized (list) {
                boolean shouldRemove = this.messages.exceedingPreferredSize();
                if (!shouldRemove) {
                    continue;
                }
                this.checkAndRemove(shouldRemove);
            }
        }
        ThreadingUtils.logThreadEnding();
    }
}

