/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.ui.storage;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.spy.formatting.FormattingManager;
import pl.baczkowicz.spy.messages.BaseMessage;
import pl.baczkowicz.spy.messages.FormattedMessage;
import pl.baczkowicz.spy.ui.events.queuable.EventQueueManager;
import pl.baczkowicz.spy.ui.events.queuable.ui.BrowseReceivedMessageEvent;
import pl.baczkowicz.spy.ui.events.queuable.ui.TopicSummaryNewMessageEvent;
import pl.baczkowicz.spy.ui.events.queuable.ui.TopicSummaryRemovedMessageEvent;
import pl.baczkowicz.spy.ui.storage.BasicMessageStoreWithSummary;
import pl.baczkowicz.spy.ui.storage.FilteredMessageStore;
import pl.baczkowicz.spy.ui.storage.MessageListWithObservableTopicSummary;
import pl.baczkowicz.spy.ui.storage.MessageStoreGarbageCollector;

public class ManagedMessageStoreWithFiltering<T extends FormattedMessage>
extends BasicMessageStoreWithSummary<T> {
    static final Logger logger = LoggerFactory.getLogger(ManagedMessageStoreWithFiltering.class);
    private final Set<String> allTopics = new HashSet<String>();
    private FilteredMessageStore<T> filteredStore;
    protected final EventQueueManager<T> uiEventQueue;

    public ManagedMessageStoreWithFiltering(String name, int minMessagesPerTopic, int preferredSize, int maxSize, EventQueueManager<T> uiEventQueue, FormattingManager formattingManager, int maxPayloadLength) {
        super(name, preferredSize, maxSize, maxPayloadLength, formattingManager);
        this.uiEventQueue = uiEventQueue;
        this.filteredStore = new FilteredMessageStore(super.getMessageList(), preferredSize, maxSize, name, this.messageFormat, formattingManager, maxPayloadLength);
        this.filteredStore.setMessageStoreGarbageCollector(new MessageStoreGarbageCollector<T>(this, this.filteredStore.getFilteredMessages(), uiEventQueue, minMessagesPerTopic, false, true));
        this.setMessageStoreGarbageCollector(new MessageStoreGarbageCollector<T>(this, super.getMessageList(), uiEventQueue, minMessagesPerTopic, true, false));
        new Thread(this.filteredStore.getMessageStoreGarbageCollector()).start();
        new Thread(this.getMessageStoreGarbageCollector()).start();
    }

    @Override
    public void messageReceived(T message) {
        this.formattingManager.formatMessage((FormattedMessage)message, this.getFormatter());
        boolean allTopicsShown = !this.browsingFiltersEnabled();
        boolean topicAlreadyExists = this.allTopics.contains(((BaseMessage)message).getTopic());
        this.allTopics.add(((BaseMessage)message).getTopic());
        FormattedMessage removed = (FormattedMessage)this.storeMessage(message);
        if (!this.filteredStore.filterMessage(message, true) && (allTopicsShown || this.filteredStore.getBrowsedTopics().contains(((BaseMessage)message).getTopic()))) {
            this.filteredStore.getFilteredMessages().add(message);
            this.uiEventQueue.add(this, new BrowseReceivedMessageEvent<T>(this.filteredStore.getFilteredMessages(), message));
        }
        if (allTopicsShown && !topicAlreadyExists) {
            this.filteredStore.applyTopicFilter(((BaseMessage)message).getTopic(), false);
        }
        if (removed != null) {
            this.uiEventQueue.add(this, new TopicSummaryRemovedMessageEvent<FormattedMessage>((MessageListWithObservableTopicSummary<FormattedMessage>)super.getMessageList(), removed));
        }
        this.uiEventQueue.add(this, new TopicSummaryNewMessageEvent<T>(super.getMessageList(), message, allTopicsShown && !topicAlreadyExists));
    }

    @Override
    public List<T> getMessages() {
        return this.filteredStore.getFilteredMessages().getMessages();
    }

    @Override
    public MessageListWithObservableTopicSummary<T> getMessageList() {
        return this.filteredStore.getFilteredMessages();
    }

    public MessageListWithObservableTopicSummary<T> getNonFilteredMessageList() {
        return super.getMessageList();
    }

    public FilteredMessageStore<T> getFilteredMessageStore() {
        return this.filteredStore;
    }

    @Override
    public boolean browsingFiltersEnabled() {
        return this.filteredStore.getBrowsedTopics().size() != this.allTopics.size();
    }

    @Override
    public boolean messageFiltersEnabled() {
        return this.filteredStore.messageFiltersEnabled();
    }

    public Collection<String> getAllTopics() {
        return Collections.unmodifiableCollection(this.allTopics);
    }

    @Override
    public void clear() {
        super.clear();
        this.allTopics.clear();
        this.filteredStore.removeAllTopicFilters();
    }

    public void setAllShowValues(boolean show) {
        if (show) {
            this.filteredStore.addAllTopicFilters();
        } else {
            this.filteredStore.removeAllTopicFilters();
        }
        ((MessageListWithObservableTopicSummary)super.getMessageList()).getTopicSummary().setAllShowValues(show);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShowValues(boolean show, Collection<String> topics) {
        Collection<String> collection = topics;
        synchronized (collection) {
            if (show) {
                this.filteredStore.applyTopicFilters(topics, true);
            } else {
                this.filteredStore.removeTopicFilters(topics);
            }
            ((MessageListWithObservableTopicSummary)super.getMessageList()).getTopicSummary().setShowValues(topics, show);
        }
    }

    public void toggleAllShowValues() {
        this.toggleShowValues(this.allTopics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toggleShowValues(Collection<String> topics) {
        HashSet<String> topicsToAdd = new HashSet<String>();
        HashSet<String> topicsToRemove = new HashSet<String>();
        Collection<String> collection = topics;
        synchronized (collection) {
            for (String topic : topics) {
                if (this.filteredStore.getBrowsedTopics().contains(topic)) {
                    topicsToRemove.add(topic);
                    continue;
                }
                topicsToAdd.add(topic);
            }
            this.filteredStore.removeTopicFilters(topicsToRemove);
            this.filteredStore.applyTopicFilters(topicsToAdd, true);
            ((MessageListWithObservableTopicSummary)super.getMessageList()).getTopicSummary().toggleShowValues(topics);
        }
    }

    public void setShowValue(String topic, boolean show) {
        this.filteredStore.updateTopicFilter(topic, show);
        ((MessageListWithObservableTopicSummary)super.getMessageList()).getTopicSummary().setShowValue(topic, show);
    }

    public EventQueueManager<T> getUiEventQueue() {
        return this.uiEventQueue;
    }

    public FormattingManager getFormattingManager() {
        return this.formattingManager;
    }

    @Override
    public void cleanUp() {
        this.getMessageStoreGarbageCollector().setRunning(false);
        this.filteredStore.getMessageStoreGarbageCollector().setRunning(false);
    }
}

