/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.ui.stats;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.spy.exceptions.XMLException;
import pl.baczkowicz.spy.ui.stats.ConnectionIntervalStats;
import pl.baczkowicz.spy.ui.stats.ConnectionStats;
import pl.baczkowicz.spy.ui.stats.SpyStats;
import pl.baczkowicz.spy.ui.stats.StatsIO;
import pl.baczkowicz.spy.utils.ThreadingUtils;

public class StatisticsManager
implements Runnable {
    static final Logger logger = LoggerFactory.getLogger(StatisticsManager.class);
    public static final List<Integer> periods = Arrays.asList(5, 30, 300);
    private static final int removeAfter = 301;
    public static SpyStats stats;
    public static Map<String, ConnectionStats> runtimeMessagesPublished;
    public static Map<String, ConnectionStats> runtimeMessagesReceived;
    private StatsIO statsFileIO;
    public static final String STATS_FORMAT;

    public StatisticsManager(StatsIO statsFileIO) throws XMLException {
        stats = new SpyStats(0L, new Date(), 0L, 0L, 0L, 0L);
        this.statsFileIO = statsFileIO;
        new Thread(this).start();
    }

    public static void newConnection() {
        stats.setConnections(stats.getConnections() + 1L);
    }

    public static void newSubscription() {
        stats.setSubscriptions(stats.getSubscriptions() + 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(String connectionId, List<String> subscriptions) {
        stats.setMessagesReceived(stats.getMessagesReceived() + 1L);
        Map<String, ConnectionStats> map = runtimeMessagesReceived;
        synchronized (map) {
            if (runtimeMessagesReceived.get(connectionId) == null) {
                StatisticsManager.resetConnection(runtimeMessagesReceived, connectionId);
            }
            StatisticsManager.runtimeMessagesReceived.get((Object)connectionId).runtimeStats.get(0).add(subscriptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messagePublished(String connectionId, String topic) {
        stats.setMessagesPublished(stats.getMessagesPublished() + 1L);
        Map<String, ConnectionStats> map = runtimeMessagesPublished;
        synchronized (map) {
            if (runtimeMessagesPublished.get(connectionId) == null) {
                runtimeMessagesPublished.put(connectionId, new ConnectionStats(periods));
                StatisticsManager.runtimeMessagesPublished.get((Object)connectionId).runtimeStats.add(new ConnectionIntervalStats());
            }
            StatisticsManager.runtimeMessagesPublished.get((Object)connectionId).runtimeStats.get(0).add(topic);
        }
    }

    public static void nextInterval(Map<String, ConnectionStats> runtimeMessages) {
        for (String connectionId : runtimeMessages.keySet()) {
            Map<Integer, ConnectionIntervalStats> avgs = runtimeMessages.get((Object)connectionId).avgPeriods;
            List<ConnectionIntervalStats> runtime = runtimeMessages.get((Object)connectionId).runtimeStats;
            ConnectionIntervalStats lastComplete = runtime.size() > 0 ? runtime.get(0) : new ConnectionIntervalStats();
            for (int period : avgs.keySet()) {
                avgs.get(period).plus(lastComplete);
                if (runtime.size() <= period) continue;
                avgs.get(period).minus(runtime.get(period));
            }
            runtime.add(0, new ConnectionIntervalStats());
            if (runtime.size() <= 301) continue;
            runtime.remove(301);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void nextInterval() {
        Map<String, ConnectionStats> map = runtimeMessagesPublished;
        synchronized (map) {
            StatisticsManager.nextInterval(runtimeMessagesPublished);
        }
        map = runtimeMessagesReceived;
        synchronized (map) {
            StatisticsManager.nextInterval(runtimeMessagesReceived);
        }
    }

    public static ConnectionIntervalStats getMessagesPublished(String connectionId, int period) {
        if (runtimeMessagesPublished.get(connectionId) == null) {
            return new ConnectionIntervalStats();
        }
        return StatisticsManager.runtimeMessagesPublished.get((Object)connectionId).avgPeriods.get(period).average(period);
    }

    public static long getMessagesPublished() {
        long total = 0L;
        for (ConnectionStats stats : runtimeMessagesPublished.values()) {
            if (stats.runtimeStats.size() <= 1) continue;
            total += (long)((int)stats.runtimeStats.get((int)1).overallCount);
        }
        return total;
    }

    public static long getMessagesReceived() {
        long total = 0L;
        for (ConnectionStats stats : runtimeMessagesReceived.values()) {
            if (stats.runtimeStats.size() <= 1) continue;
            total += (long)((int)stats.runtimeStats.get((int)1).overallCount);
        }
        return total;
    }

    public static ConnectionIntervalStats getMessagesReceived(String connectionId, int period) {
        if (runtimeMessagesReceived.get(connectionId) == null) {
            return new ConnectionIntervalStats();
        }
        return StatisticsManager.runtimeMessagesReceived.get((Object)connectionId).avgPeriods.get(period).average(period);
    }

    public static void resetMessagesReceived(String connectionId, String topic) {
        if (runtimeMessagesReceived.get(connectionId) == null) {
            return;
        }
        runtimeMessagesReceived.get(connectionId).resetTopic(topic);
    }

    public static void resetMessagesReceived(String connectionId) {
        StatisticsManager.resetConnection(runtimeMessagesReceived, connectionId);
    }

    private static void resetConnection(Map<String, ConnectionStats> runtimeMessages, String connectionId) {
        runtimeMessages.put(connectionId, new ConnectionStats(periods));
        runtimeMessages.get((Object)connectionId).runtimeStats.add(new ConnectionIntervalStats());
    }

    @Override
    public void run() {
        ThreadingUtils.logThreadStarting("StatisticsManager");
        while (!ThreadingUtils.sleep(1000L)) {
            StatisticsManager.nextInterval();
        }
        ThreadingUtils.logThreadEnding();
    }

    public static String getPeriodList() {
        StringBuffer sb = new StringBuffer();
        Iterator<Integer> iterator = periods.iterator();
        while (iterator.hasNext()) {
            int period = iterator.next();
            if (period > 60) {
                sb.append(period / 60 + "m");
            } else {
                sb.append(period + "s");
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public static String getPeriodValues() {
        StringBuffer sb = new StringBuffer();
        Iterator<Integer> iterator = periods.iterator();
        while (iterator.hasNext()) {
            sb.append("%.1f");
            iterator.next();
            if (!iterator.hasNext()) continue;
            sb.append("/");
        }
        return sb.toString();
    }

    public void loadStats() {
        stats = this.statsFileIO.loadStats();
    }

    public void saveStats() {
        this.statsFileIO.saveStats(stats);
    }

    static {
        runtimeMessagesPublished = new HashMap<String, ConnectionStats>();
        runtimeMessagesReceived = new HashMap<String, ConnectionStats>();
        STATS_FORMAT = "load: " + StatisticsManager.getPeriodValues();
    }
}

