/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.ui.stats;

import javafx.application.Platform;
import pl.baczkowicz.spy.ui.IConnectionViewManager;
import pl.baczkowicz.spy.ui.controllers.IConnectionController;
import pl.baczkowicz.spy.utils.ThreadingUtils;

public class ConnectionStatsUpdater
implements Runnable {
    private static final int REFRESH_INTERVAL = 1000;
    private IConnectionViewManager connectionManager;

    public ConnectionStatsUpdater(IConnectionViewManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    @Override
    public void run() {
        ThreadingUtils.logThreadStarting("Connection Stats Updater");
        while (!ThreadingUtils.sleep(1000L)) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ConnectionStatsUpdater.this.updateConnectionStats();
                }
            });
        }
        ThreadingUtils.logThreadEnding();
    }

    private void updateConnectionStats() {
        for (IConnectionController iConnectionController : this.connectionManager.getConnectionControllers()) {
            iConnectionController.updateConnectionStats();
        }
    }
}

