/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.ui.stats;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConnectionIntervalStats {
    public Map<String, Double> messageCount = new HashMap<String, Double>();
    public double overallCount = 0.0;

    public void add(String topic) {
        this.overallCount += 1.0;
        if (this.messageCount.get(topic) == null) {
            this.messageCount.put(topic, 1.0);
        } else {
            this.messageCount.put(topic, this.messageCount.get(topic) + 1.0);
        }
    }

    public void add(List<String> topics) {
        this.overallCount += 1.0;
        for (String topic : topics) {
            if (this.messageCount.get(topic) == null) {
                this.messageCount.put(topic, 1.0);
                continue;
            }
            this.messageCount.put(topic, this.messageCount.get(topic) + 1.0);
        }
    }

    public void reset() {
        this.overallCount = 0.0;
        this.messageCount.clear();
    }

    public void resetTopic(String topic) {
        this.messageCount.put(topic, 0.0);
    }

    public ConnectionIntervalStats average(int interval) {
        ConnectionIntervalStats avg = new ConnectionIntervalStats();
        avg.overallCount = this.overallCount / (double)interval;
        for (String topic : this.messageCount.keySet()) {
            avg.messageCount.put(topic, this.messageCount.get(topic) / (double)interval);
        }
        return avg;
    }

    public void plus(ConnectionIntervalStats cs) {
        this.overallCount += cs.overallCount;
        for (String topic : cs.messageCount.keySet()) {
            if (this.messageCount.containsKey(topic)) {
                this.messageCount.put(topic, this.messageCount.get(topic) + cs.messageCount.get(topic));
                continue;
            }
            this.messageCount.put(topic, cs.messageCount.get(topic));
        }
    }

    public void minus(ConnectionIntervalStats cs) {
        this.overallCount -= cs.overallCount;
        for (String topic : cs.messageCount.keySet()) {
            if (!this.messageCount.containsKey(topic)) continue;
            this.messageCount.put(topic, this.messageCount.get(topic) - cs.messageCount.get(topic));
        }
    }
}

