/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.ui.search;

import pl.baczkowicz.spy.messages.BaseMessage;
import pl.baczkowicz.spy.messages.FormattedMessage;
import pl.baczkowicz.spy.storage.BasicMessageStore;
import pl.baczkowicz.spy.storage.MessageList;
import pl.baczkowicz.spy.ui.events.queuable.EventQueueManager;
import pl.baczkowicz.spy.ui.events.queuable.ui.BrowseRemovedMessageEvent;
import pl.baczkowicz.spy.ui.search.MessageFilter;

public class UniqueContentOnlyFilter<T extends FormattedMessage>
implements MessageFilter<T> {
    private boolean uniqueContentOnly;
    private int deleted = 0;
    protected final EventQueueManager<T> uiEventQueue;
    private BasicMessageStore<T> store;

    public UniqueContentOnlyFilter(BasicMessageStore<T> store, EventQueueManager<T> uiEventQueue) {
        this.uiEventQueue = uiEventQueue;
        this.store = store;
    }

    @Override
    public boolean filter(T message, MessageList<T> messageList, boolean updateUi) {
        if (!this.uniqueContentOnly || messageList.getMessages().size() == 0) {
            return false;
        }
        FormattedMessage lastMessage = (FormattedMessage)messageList.getMessages().get(0);
        if (((FormattedMessage)message).getFormattedPayload().equals(lastMessage.getFormattedPayload()) && ((BaseMessage)message).getTopic().equals(lastMessage.getTopic())) {
            FormattedMessage deletedMessage = (FormattedMessage)messageList.getMessages().remove(0);
            if (updateUi) {
                this.uiEventQueue.add(this.store, new BrowseRemovedMessageEvent<FormattedMessage>(messageList, deletedMessage, 0));
            }
            ++this.deleted;
        }
        return false;
    }

    public boolean isUniqueContentOnly() {
        return this.uniqueContentOnly;
    }

    public void setUniqueContentOnly(boolean uniqueContentOnly) {
        this.uniqueContentOnly = uniqueContentOnly;
        if (!uniqueContentOnly) {
            this.reset();
        }
    }

    @Override
    public void reset() {
        this.deleted = 0;
    }

    @Override
    public boolean isActive() {
        return this.deleted > 0;
    }
}

