/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.ui.scripts;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import pl.baczkowicz.spy.common.generated.ScriptDetails;
import pl.baczkowicz.spy.eventbus.IKBus;
import pl.baczkowicz.spy.files.FileUtils;
import pl.baczkowicz.spy.scripts.BaseScriptManager;
import pl.baczkowicz.spy.scripts.Script;
import pl.baczkowicz.spy.ui.configuration.BaseConfigurationManager;
import pl.baczkowicz.spy.ui.properties.PublicationScriptProperties;
import pl.baczkowicz.spy.ui.scripts.InteractiveBaseScriptManagerInterface;
import pl.baczkowicz.spy.ui.scripts.ScriptTypeEnum;

public abstract class InteractiveBaseScriptManager
extends BaseScriptManager
implements InteractiveBaseScriptManagerInterface {
    private final ObservableList<PublicationScriptProperties> observableScriptList = FXCollections.observableArrayList();

    public InteractiveBaseScriptManager(IKBus eventBus, Executor executor) {
        super(eventBus, executor);
    }

    public static String getScriptDirectoryForConnection(String configuredDirectory) {
        String filePathSeparator = System.getProperty("file.separator");
        if (configuredDirectory != null && !configuredDirectory.isEmpty()) {
            if (!configuredDirectory.endsWith(filePathSeparator)) {
                return configuredDirectory + filePathSeparator;
            }
            return configuredDirectory;
        }
        return BaseConfigurationManager.getDefaultHomeDirectory();
    }

    @Override
    public void addScripts(List<ScriptDetails> scriptDetails, ScriptTypeEnum type) {
        List<Script> addedScripts = this.populateScripts(scriptDetails);
        for (Script script : addedScripts) {
            PublicationScriptProperties properties = new PublicationScriptProperties(script);
            properties.typeProperty().setValue((Object)type);
            script.setObserver(properties);
            this.observableScriptList.add((Object)properties);
        }
    }

    @Override
    public void addScripts(String directory, boolean includeSubdirectories, ScriptTypeEnum type) {
        ArrayList<File> files = new ArrayList<File>();
        files.addAll(FileUtils.getFileNamesForDirectory(InteractiveBaseScriptManager.getScriptDirectoryForConnection(directory), includeSubdirectories, ".js"));
        this.populateScriptsFromFileList(directory, files, type);
    }

    @Override
    public void addScripts(String directory, ScriptTypeEnum type) {
        ArrayList<File> files = new ArrayList<File>();
        files.addAll(FileUtils.getFileNamesForDirectory(InteractiveBaseScriptManager.getScriptDirectoryForConnection(directory), ".js"));
        this.populateScriptsFromFileList(directory, files, type);
    }

    @Override
    public void populateScriptsFromFileList(String rootDirectory, List<File> files, ScriptTypeEnum type) {
        List<Script> addedScripts = this.populateScriptsFromFileList(files);
        for (Script script : addedScripts) {
            script.setRootDirectory(rootDirectory);
            PublicationScriptProperties properties = new PublicationScriptProperties(script);
            properties.typeProperty().setValue((Object)type);
            script.setObserver(properties);
            this.observableScriptList.add((Object)properties);
        }
    }

    @Override
    public void stopScriptFile(File scriptFile) {
        Script script = InteractiveBaseScriptManager.getPublicationScriptProperties(this.observableScriptList, InteractiveBaseScriptManager.getScriptName(scriptFile)).getScript();
        this.stopScript(script);
    }

    public static PublicationScriptProperties getPublicationScriptProperties(ObservableList<PublicationScriptProperties> observableScriptList, String scriptName) {
        for (PublicationScriptProperties properties : observableScriptList) {
            if (!properties.getScript().getName().equals(scriptName)) continue;
            return properties;
        }
        return null;
    }

    @Override
    public ObservableList<PublicationScriptProperties> getObservableScriptList() {
        return this.observableScriptList;
    }

    @Override
    public void removeScript(PublicationScriptProperties item) {
        this.getScriptsMap().remove(item.getScript().getScriptId());
        this.observableScriptList.remove((Object)item);
    }

    @Override
    public void clear() {
        this.getObservableScriptList().clear();
        this.getScriptsMap().clear();
    }
}

