/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.ui.properties;

import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import pl.baczkowicz.spy.scripts.ScriptChangeObserver;
import pl.baczkowicz.spy.testcases.TestCase;
import pl.baczkowicz.spy.testcases.TestCaseStatus;
import pl.baczkowicz.spy.testcases.TestCaseStep;
import pl.baczkowicz.spy.ui.properties.TestCaseStepProperties;
import pl.baczkowicz.spy.ui.scripts.ScriptTypeEnum;

public class TestCaseProperties
implements ScriptChangeObserver {
    private SimpleObjectProperty<TestCaseStatus> statusProperty;
    private SimpleObjectProperty<ScriptTypeEnum> typeProperty;
    private SimpleStringProperty lastUpdatedProperty;
    private SimpleLongProperty countProperty;
    private TestCase testCase;
    private ObservableList<TestCaseStepProperties> steps = FXCollections.observableArrayList();

    public TestCaseProperties(TestCase testCase) {
        this.testCase = testCase;
        this.statusProperty = new SimpleObjectProperty((Object)TestCaseStatus.NOT_RUN);
        this.typeProperty = new SimpleObjectProperty((Object)ScriptTypeEnum.PUBLICATION);
        this.lastUpdatedProperty = new SimpleStringProperty("");
        this.countProperty = new SimpleLongProperty(0L);
        for (TestCaseStep step : testCase.getSteps()) {
            TestCaseStepProperties properties = new TestCaseStepProperties(step);
            step.setObserver(properties);
            this.steps.add((Object)properties);
        }
        this.update();
    }

    public void update() {
        this.lastUpdatedProperty.setValue(this.testCase.getLastUpdated());
        this.statusProperty.setValue((Object)this.testCase.getTestCaseStatus());
    }

    public SimpleObjectProperty<TestCaseStatus> statusProperty() {
        return this.statusProperty;
    }

    public SimpleObjectProperty<ScriptTypeEnum> typeProperty() {
        return this.typeProperty;
    }

    public SimpleStringProperty lastUpdatedProperty() {
        return this.lastUpdatedProperty;
    }

    public SimpleLongProperty countProperty() {
        return this.countProperty;
    }

    public String getName() {
        return this.testCase.getName();
    }

    public TestCase getScript() {
        return this.testCase;
    }

    @Override
    public void onChange() {
        this.update();
    }

    public ObservableList<TestCaseStepProperties> getSteps() {
        return this.steps;
    }
}

