/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.ui.properties;

import java.util.Date;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import pl.baczkowicz.spy.ui.charts.ChartSeriesStatusEnum;
import pl.baczkowicz.spy.ui.charts.ChartSeriesTypeEnum;
import pl.baczkowicz.spy.utils.TimeUtils;

public class ChartSeriesProperties {
    private int id;
    private SimpleStringProperty statusProperty;
    private ChartSeriesStatusEnum seriesStatus = ChartSeriesStatusEnum.NO_MESSAGES;
    private SimpleStringProperty nameProperty;
    private SimpleStringProperty topicProperty;
    private SimpleObjectProperty<ChartSeriesTypeEnum> typeProperty;
    private SimpleStringProperty valueExpressionProperty;
    private SimpleBooleanProperty visibleProperty;
    private String errorMessage;
    private Date lastUpdated;

    public ChartSeriesProperties(int id, String name, String topic, ChartSeriesTypeEnum type, String valueExpression) {
        this.setId(id);
        this.nameProperty = new SimpleStringProperty(name);
        this.topicProperty = new SimpleStringProperty(topic);
        this.typeProperty = new SimpleObjectProperty((Object)type);
        this.statusProperty = new SimpleStringProperty();
        this.valueExpressionProperty = new SimpleStringProperty(valueExpression);
        this.visibleProperty = new SimpleBooleanProperty(true);
        this.lastUpdated = new Date();
    }

    public SimpleBooleanProperty visibleProperty() {
        return this.visibleProperty;
    }

    public SimpleObjectProperty<ChartSeriesTypeEnum> typeProperty() {
        return this.typeProperty;
    }

    public SimpleStringProperty statusProperty() {
        return this.statusProperty;
    }

    public SimpleStringProperty topicProperty() {
        return this.topicProperty;
    }

    public SimpleStringProperty nameProperty() {
        return this.nameProperty;
    }

    public SimpleStringProperty valueExpressionProperty() {
        return this.valueExpressionProperty;
    }

    public String getTopic() {
        return this.topicProperty.get();
    }

    public String getName() {
        return this.nameProperty.get();
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setErrorMessage(String message) {
        this.errorMessage = message;
        this.statusProperty.set(this.errorMessage);
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    public void setLastUpdated(Date date) {
        this.lastUpdated = date;
        this.statusProperty.set(TimeUtils.DATE_WITH_SECONDS_SDF.format(this.getLastUpdated()));
    }

    public ChartSeriesStatusEnum getSeriesStatus() {
        return this.seriesStatus;
    }

    public void setSeriesStatus(ChartSeriesStatusEnum seriesStatus) {
        this.seriesStatus = seriesStatus;
    }
}

