/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.ui.keyboard;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;

public class TimeBasedKeyEventFilter {
    private final long minimumInterval;
    private Map<Object, Long> lastEvents = new HashMap<Object, Long>();

    public TimeBasedKeyEventFilter(long minimumInterval) {
        this.minimumInterval = minimumInterval;
    }

    public boolean processEvent(KeyEvent event) {
        Long lastEvent = this.lastEvents.get(event.getCode());
        long now = new Date().getTime();
        if (lastEvent != null && lastEvent + this.minimumInterval > now) {
            return false;
        }
        this.lastEvents.put(event.getCode(), now);
        return true;
    }

    public boolean processEvent(MouseEvent event) {
        Long lastEvent = this.lastEvents.get(event.getClickCount());
        long now = new Date().getTime();
        if (lastEvent != null && lastEvent + this.minimumInterval > now) {
            return false;
        }
        this.lastEvents.put(event.getClickCount(), now);
        return true;
    }
}

