/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.ui.events.queuable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import pl.baczkowicz.spy.messages.FormattedMessage;
import pl.baczkowicz.spy.storage.BasicMessageStore;
import pl.baczkowicz.spy.ui.events.queuable.ui.BrowseReceivedMessageEvent;
import pl.baczkowicz.spy.ui.events.queuable.ui.BrowseRemovedMessageEvent;
import pl.baczkowicz.spy.ui.events.queuable.ui.SpyUIEvent;
import pl.baczkowicz.spy.ui.events.queuable.ui.TopicSummaryNewMessageEvent;
import pl.baczkowicz.spy.ui.events.queuable.ui.TopicSummaryRemovedMessageEvent;

public class EventQueueManager<T extends FormattedMessage> {
    private Map<String, List<SpyUIEvent<T>>> events = new HashMap<String, List<SpyUIEvent<T>>>();
    private AtomicLong eventCount = new AtomicLong();

    public EventQueueManager() {
        this.events.put(BrowseReceivedMessageEvent.class.toString(), new ArrayList());
        this.events.put(BrowseRemovedMessageEvent.class.toString(), new ArrayList());
        this.events.put(TopicSummaryNewMessageEvent.class.toString(), new ArrayList());
        this.events.put(TopicSummaryRemovedMessageEvent.class.toString(), new ArrayList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(BasicMessageStore<T> parent, SpyUIEvent<T> event) {
        String eventType = event.getClass().toString();
        Map<String, List<SpyUIEvent<T>>> map = this.events;
        synchronized (map) {
            List<SpyUIEvent<T>> eventList = this.events.get(eventType);
            eventList.add(event);
        }
        this.eventCount.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SpyUIEvent<T>> getAndRemoveEvents(String eventType) {
        List<SpyUIEvent<T>> eventList = this.events.get(eventType);
        Map<String, List<SpyUIEvent<T>>> map = this.events;
        synchronized (map) {
            this.events.put(eventType, new ArrayList());
        }
        this.reduceCount(eventList.size());
        return eventList;
    }

    public Map<String, List<SpyUIEvent<T>>> getEvents() {
        return this.events;
    }

    public long getEventCount() {
        return this.eventCount.get();
    }

    private void reduceCount(long reduceBy) {
        this.eventCount.addAndGet(-reduceBy);
    }
}

