/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.ui.controls;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.text.TextAlignment;
import pl.baczkowicz.spy.ui.controls.DialogAction;
import pl.baczkowicz.spy.ui.utils.ImageUtils;

public class CommandLinksDialog {
    public static Optional<DialogAction> showCommandLinks(String title, String message, DialogAction defaultCommandLink, List<DialogAction> links, double windowHeight, int minWidth, int longMessageMinHeight, double maxHeight, List<String> stylesheets) {
        final Dialog dialog = new Dialog();
        dialog.setTitle(title);
        dialog.getDialogPane().getScene().getStylesheets().addAll(stylesheets);
        dialog.getDialogPane().getButtonTypes().clear();
        dialog.setGraphic((Node)ImageUtils.createIcon("dialog-information-large", 55));
        dialog.setResizable(true);
        dialog.setHeight(windowHeight);
        Label label = new Label(message);
        label.setAlignment(Pos.TOP_LEFT);
        label.setTextAlignment(TextAlignment.LEFT);
        label.setMaxWidth(Double.MAX_VALUE);
        label.setMaxHeight(Double.MAX_VALUE);
        label.setWrapText(true);
        label.getStyleClass().add((Object)"command-link-message");
        int gapSize = 10;
        final ArrayList<Button> buttons = new ArrayList<Button>(links.size());
        GridPane content = new GridPane(){

            protected double computePrefWidth(double height) {
                double pw = 0.0;
                for (int i = 0; i < buttons.size(); ++i) {
                    Button btn = (Button)buttons.get(i);
                    pw = Math.min(pw, btn.prefWidth(-1.0));
                }
                return pw + 10.0;
            }

            protected double computePrefHeight(double width) {
                double ph = 10.0;
                for (int i = 0; i < buttons.size(); ++i) {
                    Button btn = (Button)buttons.get(i);
                    ph += btn.prefHeight(width) + 10.0;
                }
                return ph * 1.5;
            }
        };
        int row = 0;
        content.add((Node)label, 0, row++);
        content.setMinWidth((double)minWidth);
        content.setMaxHeight(windowHeight);
        content.setPrefHeight(windowHeight);
        content.setHgap(10.0);
        content.setVgap(10.0);
        for (final DialogAction commandLink : links) {
            if (commandLink == null) continue;
            Button button = CommandLinksDialog.buildCommandLinkButton(commandLink, longMessageMinHeight, maxHeight);
            button.setDefaultButton(commandLink == defaultCommandLink);
            button.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent ae) {
                    dialog.setResult((Object)commandLink);
                }
            });
            commandLink.setButton(button);
            GridPane.setHgrow((Node)button, (Priority)Priority.ALWAYS);
            GridPane.setVgrow((Node)button, (Priority)Priority.ALWAYS);
            content.add((Node)button, 0, row++);
            buttons.add(button);
        }
        GridPane.setMargin((Node)((Node)buttons.get(buttons.size() - 1)), (Insets)new Insets(0.0, 0.0, 10.0, 0.0));
        dialog.getDialogPane().setContent((Node)content);
        ButtonType cancel = new ButtonType("Cancel", ButtonBar.ButtonData.CANCEL_CLOSE);
        dialog.getDialogPane().getButtonTypes().add((Object)cancel);
        return dialog.showAndWait();
    }

    private static Button buildCommandLinkButton(DialogAction commandLink, int longMessageMinHeight, double maxHeight) {
        Button button = new Button();
        button.getStyleClass().addAll((Object[])new String[]{"command-link-button"});
        button.setMaxHeight(maxHeight);
        button.setMaxWidth(Double.MAX_VALUE);
        button.setAlignment(Pos.CENTER_LEFT);
        final Label titleLabel = new Label(commandLink.getHeading());
        titleLabel.minWidthProperty().bind((ObservableValue)new DoubleBinding(){
            {
                this.bind(new Observable[]{titleLabel.prefWidthProperty()});
            }

            protected double computeValue() {
                return titleLabel.getPrefWidth() + 400.0;
            }
        });
        titleLabel.getStyleClass().addAll((Object[])new String[]{"line-1"});
        titleLabel.setWrapText(true);
        titleLabel.setAlignment(Pos.TOP_LEFT);
        GridPane.setVgrow((Node)titleLabel, (Priority)Priority.NEVER);
        Label messageLabel = new Label(commandLink.getLongText());
        messageLabel.setMinHeight((double)longMessageMinHeight);
        messageLabel.setPrefHeight((double)(longMessageMinHeight + 10));
        messageLabel.getStyleClass().addAll((Object[])new String[]{"line-2"});
        messageLabel.setWrapText(true);
        messageLabel.setAlignment(Pos.TOP_LEFT);
        messageLabel.setMaxHeight(Double.MAX_VALUE);
        GridPane.setVgrow((Node)messageLabel, (Priority)Priority.ALWAYS);
        Pane graphicContainer = new Pane(new Node[]{ImageUtils.createIcon("go-next-green", 20)});
        graphicContainer.getStyleClass().add((Object)"graphic-container");
        GridPane.setValignment((Node)graphicContainer, (VPos)VPos.TOP);
        GridPane.setMargin((Node)graphicContainer, (Insets)new Insets(0.0, 15.0, 0.0, 0.0));
        GridPane grid = new GridPane();
        grid.minWidthProperty().bind((ObservableValue)titleLabel.prefWidthProperty());
        grid.setMaxHeight(Double.MAX_VALUE);
        grid.setMaxWidth(Double.MAX_VALUE);
        grid.getStyleClass().add((Object)"container");
        grid.add((Node)graphicContainer, 0, 0, 1, 2);
        grid.add((Node)titleLabel, 1, 0);
        grid.add((Node)messageLabel, 1, 1);
        button.setGraphic((Node)grid);
        button.minWidthProperty().bind((ObservableValue)titleLabel.prefWidthProperty());
        return button;
    }
}

