/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.ui.controlpanel;

import java.util.ArrayList;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.FlowPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.spy.eventbus.IKBus;
import pl.baczkowicz.spy.ui.IConnectionViewManager;
import pl.baczkowicz.spy.ui.configuration.ConfiguredConnectionGroupDetails;
import pl.baczkowicz.spy.ui.configuration.IConfigurationManager;
import pl.baczkowicz.spy.ui.connections.IConnectionFactory;
import pl.baczkowicz.spy.ui.controllers.ControlPanelItemController;
import pl.baczkowicz.spy.ui.controlpanel.IControlPanelItem;
import pl.baczkowicz.spy.ui.controlpanel.ItemStatus;
import pl.baczkowicz.spy.ui.events.ShowEditConnectionsWindowEvent;
import pl.baczkowicz.spy.ui.properties.ModifiableConnection;

public class ConnectionsControlPanelItem
implements IControlPanelItem {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionsControlPanelItem.class);
    private static final double MAX_CONNECTIONS_HEIGHT = 350.0;
    private IConfigurationManager configurationManager;
    private IKBus eventBus;
    private IConnectionViewManager connectionManager;
    private IConnectionFactory connectionFactory;

    public ConnectionsControlPanelItem(IConfigurationManager configurationManager, IConnectionViewManager connectionManager, IConnectionFactory connectionFactory, IKBus eventBus) {
        this.configurationManager = configurationManager;
        this.eventBus = eventBus;
        this.connectionManager = connectionManager;
        this.connectionFactory = connectionFactory;
    }

    @Override
    public void update(ControlPanelItemController controlPanelItemController, Button button) {
        this.showConnections(controlPanelItemController, button, this.configurationManager, this.connectionManager, this.eventBus);
    }

    public void showConnections(ControlPanelItemController controller, final Button button, IConfigurationManager configurationManager, IConnectionViewManager connectionManager, final IKBus eventBus) {
        button.setMaxHeight(350.0);
        while (controller.getCustomItems().getChildren().size() > 2) {
            controller.getCustomItems().getChildren().remove(2);
        }
        int connectionCount = configurationManager.getConnections().size();
        if (connectionCount > 0) {
            controller.setTitle("You have " + connectionCount + " connection" + (connectionCount > 1 ? "s" : "") + " configured.");
            controller.setDetails("Click here to edit your connections or on the relevant button to open, connect, reconnect or disconnect.");
            controller.setStatus(ItemStatus.OK);
            List<ConfiguredConnectionGroupDetails> groups = configurationManager.getOrderedGroups();
            final ArrayList<Label> labels = new ArrayList<Label>();
            for (ConfiguredConnectionGroupDetails group : groups) {
                List<? extends ModifiableConnection> connections = configurationManager.getConnections(group);
                if (connections.isEmpty()) continue;
                FlowPane buttons = new FlowPane();
                buttons.setVgap(4.0);
                buttons.setHgap(4.0);
                buttons.setMaxHeight(Double.MAX_VALUE);
                if (groups.size() > 1) {
                    Label groupLabel = new Label(group.getFullName() + " : ");
                    groupLabel.widthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

                        public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                            double maxWidth = 0.0;
                            for (Label label : labels) {
                                if (!(maxWidth < label.getWidth())) continue;
                                maxWidth = label.getWidth();
                            }
                            for (Label label : labels) {
                                logger.trace("Setting min width for " + label.getText() + " to " + maxWidth);
                                label.setMinWidth(maxWidth);
                            }
                        }
                    });
                    labels.add(groupLabel);
                    buttons.getChildren().add((Object)groupLabel);
                }
                for (ModifiableConnection modifiableConnection : connections) {
                    buttons.getChildren().add((Object)this.connectionFactory.createConnectionButton(modifiableConnection));
                }
                controller.getCustomItems().getChildren().add((Object)buttons);
                button.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent event) {
                        eventBus.publish(new ShowEditConnectionsWindowEvent(button.getScene().getWindow(), false, null));
                    }
                });
            }
        } else {
            controller.setTitle("You haven't got any connections configured.");
            controller.setDetails("Click here to create a new connection...");
            controller.setStatus(ItemStatus.INFO);
            button.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    eventBus.publish(new ShowEditConnectionsWindowEvent(button.getScene().getWindow(), true, null));
                }
            });
        }
        controller.refresh();
    }
}

