/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.ui.controllers;

import java.io.File;
import java.net.URL;
import java.util.Date;
import java.util.ResourceBundle;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TitledPane;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.stage.DirectoryChooser;
import javafx.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.spy.scripts.BaseScriptManagerInterface;
import pl.baczkowicz.spy.testcases.TestCaseManager;
import pl.baczkowicz.spy.testcases.TestCaseStatus;
import pl.baczkowicz.spy.ui.controllers.TestCaseExecutionController;
import pl.baczkowicz.spy.ui.panes.PaneVisibilityStatus;
import pl.baczkowicz.spy.ui.panes.TitledPaneController;
import pl.baczkowicz.spy.ui.properties.TestCaseProperties;
import pl.baczkowicz.spy.ui.testcases.InteractiveTestCaseManager;

public class TestCasesExecutionController
extends AnchorPane
implements Initializable,
TitledPaneController {
    public static final int WIDTH = 780;
    public static final int HEIGHT = 550;
    static final Logger logger = LoggerFactory.getLogger(TestCasesExecutionController.class);
    private TitledPane pane;
    @FXML
    private TreeTableView<TestCaseProperties> scriptTree;
    private TreeItem<TestCaseProperties> root = new TreeItem();
    @FXML
    private TestCaseExecutionController testCaseExecutionPaneController;
    @FXML
    private TreeTableColumn<TestCaseProperties, String> nameColumn;
    @FXML
    private TreeTableColumn<TestCaseProperties, String> lastRunColumn;
    @FXML
    private TreeTableColumn<TestCaseProperties, TestCaseStatus> statusColumn;
    @FXML
    private ContextMenu scriptTreeContextMenu;
    @FXML
    private MenuItem setLocationMenu;
    @FXML
    private MenuItem enqueueAllMenu;
    @FXML
    private MenuItem enqueueSelectedMenu;
    @FXML
    private MenuItem enqueueNotRunMenu;
    @FXML
    private MenuItem enqueueFailedMenu;
    @FXML
    private MenuItem clearEnqueuedMenu;
    @FXML
    private Label enqueuedLabel;
    @FXML
    private Label passesLabel;
    @FXML
    private Label failuresLabel;
    @FXML
    private Label runLabel;
    @FXML
    private Label totalLabel;
    @FXML
    private Label skippedLabel;
    private String scriptsLocation;
    private BaseScriptManagerInterface scriptManager;
    private InteractiveTestCaseManager testCaseManager;
    private MenuButton settingsButton;
    private Label titleLabel;

    public void initialize(URL location, ResourceBundle resources) {
        this.setLocationMenu.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                DirectoryChooser fileChooser = new DirectoryChooser();
                fileChooser.setTitle("Select test cases location");
                File selectedFile = fileChooser.showDialog(TestCasesExecutionController.this.scriptTree.getScene().getWindow());
                if (selectedFile != null) {
                    TestCasesExecutionController.this.scriptsLocation = selectedFile.getAbsolutePath();
                    TestCasesExecutionController.this.testCaseManager.loadTestCases(TestCasesExecutionController.this.scriptsLocation);
                    TestCasesExecutionController.this.root.getChildren().clear();
                    for (TestCaseProperties properties : TestCasesExecutionController.this.testCaseManager.getTestCasesProperties()) {
                        TestCasesExecutionController.this.root.getChildren().add((Object)new TreeItem((Object)properties));
                    }
                    TestCasesExecutionController.this.scriptTree.getSelectionModel().clearSelection();
                    TestCasesExecutionController.this.refreshInfo();
                    TestCasesExecutionController.this.scriptTree.getSortOrder().clear();
                    TestCasesExecutionController.this.scriptTree.getSortOrder().add((Object)TestCasesExecutionController.this.nameColumn);
                }
            }
        });
        this.enqueueAllMenu.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                TestCasesExecutionController.this.testCaseManager.enqueueAllTestCases();
                TreeItem selected = (TreeItem)TestCasesExecutionController.this.scriptTree.getSelectionModel().getSelectedItem();
                if (selected != null && selected.getValue() != null) {
                    TestCaseProperties testCaseProperties = (TestCaseProperties)selected.getValue();
                    TestCasesExecutionController.this.testCaseManager.runTestCase(testCaseProperties);
                    TestCasesExecutionController.this.refreshInfo();
                }
            }
        });
        this.enqueueSelectedMenu.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                TreeItem selected = (TreeItem)TestCasesExecutionController.this.scriptTree.getSelectionModel().getSelectedItem();
                if (selected != null && selected.getValue() != null) {
                    TestCaseProperties testCaseProperties = (TestCaseProperties)selected.getValue();
                    TestCasesExecutionController.this.testCaseManager.enqueueTestCase(testCaseProperties);
                    TestCasesExecutionController.this.refreshInfo();
                }
            }
        });
        this.enqueueNotRunMenu.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                TestCasesExecutionController.this.testCaseManager.enqueueAllNotRun();
                TestCasesExecutionController.this.refreshInfo();
            }
        });
        this.enqueueFailedMenu.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                TestCasesExecutionController.this.testCaseManager.enqueueAllFailed();
                TestCasesExecutionController.this.refreshInfo();
            }
        });
        this.clearEnqueuedMenu.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                TestCasesExecutionController.this.testCaseManager.clearEnqueued();
                TestCasesExecutionController.this.refreshInfo();
            }
        });
        this.scriptTree.setRoot(this.root);
        this.scriptTree.setShowRoot(false);
        this.scriptTree.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                TestCasesExecutionController.this.showSelected();
                TestCasesExecutionController.this.refreshInfo();
            }
        });
        this.nameColumn.setCellValueFactory(param -> new ReadOnlyStringWrapper(((TestCaseProperties)param.getValue().getValue()).getName()));
        this.lastRunColumn.setCellValueFactory((Callback)new Callback<TreeTableColumn.CellDataFeatures<TestCaseProperties, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TreeTableColumn.CellDataFeatures<TestCaseProperties, String> p) {
                return ((TestCaseProperties)p.getValue().getValue()).lastUpdatedProperty();
            }
        });
        this.lastRunColumn.setCellFactory((Callback)new Callback<TreeTableColumn<TestCaseProperties, String>, TreeTableCell<TestCaseProperties, String>>(){

            public TreeTableCell<TestCaseProperties, String> call(TreeTableColumn<TestCaseProperties, String> param) {
                TreeTableCell<TestCaseProperties, String> cell = new TreeTableCell<TestCaseProperties, String>(){

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        this.setText(item);
                    }
                };
                cell.setAlignment(Pos.CENTER);
                return cell;
            }
        });
        this.statusColumn.setCellValueFactory((Callback)new Callback<TreeTableColumn.CellDataFeatures<TestCaseProperties, TestCaseStatus>, ObservableValue<TestCaseStatus>>(){

            public ObservableValue<TestCaseStatus> call(TreeTableColumn.CellDataFeatures<TestCaseProperties, TestCaseStatus> p) {
                return ((TestCaseProperties)p.getValue().getValue()).statusProperty();
            }
        });
        this.statusColumn.setCellFactory((Callback)new Callback<TreeTableColumn<TestCaseProperties, TestCaseStatus>, TreeTableCell<TestCaseProperties, TestCaseStatus>>(){

            public TreeTableCell<TestCaseProperties, TestCaseStatus> call(TreeTableColumn<TestCaseProperties, TestCaseStatus> param) {
                TreeTableCell<TestCaseProperties, TestCaseStatus> cell = new TreeTableCell<TestCaseProperties, TestCaseStatus>(){

                    public void updateItem(TestCaseStatus item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (!this.isEmpty()) {
                            this.setGraphic(TestCasesExecutionController.this.testCaseExecutionPaneController.getIconForStatus(item));
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
                cell.setAlignment(Pos.CENTER);
                cell.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
                return cell;
            }
        });
        this.scriptTree.setFixedCellSize(24.0);
        this.scriptTree.setPlaceholder((Node)new Label("Right click to load test cases..."));
    }

    public void init() {
        this.titleLabel = new Label(this.pane.getText());
        this.testCaseManager = new InteractiveTestCaseManager(this.scriptManager, this, this.testCaseExecutionPaneController);
        this.testCaseExecutionPaneController.setTestCaseManager(this.testCaseManager);
    }

    public void refreshInfo() {
        this.totalLabel.setText(this.totalLabel.getText().substring(0, this.totalLabel.getText().indexOf(" ") + 1) + this.testCaseManager.getTotalCount());
        this.enqueuedLabel.setText(this.enqueuedLabel.getText().substring(0, this.enqueuedLabel.getText().indexOf(" ") + 1) + this.testCaseManager.getEnqueuedCount());
        int passes = 0;
        int failures = 0;
        int skipped = 0;
        int run = 0;
        this.enqueueAllMenu.setDisable(true);
        this.enqueueSelectedMenu.setDisable(true);
        this.enqueueNotRunMenu.setDisable(true);
        this.enqueueFailedMenu.setDisable(true);
        this.clearEnqueuedMenu.setDisable(this.testCaseManager.getEnqueuedCount() == 0);
        if (this.root.getChildren().size() > 0 && this.testCaseManager.getTotalCount() > 0) {
            this.enqueueAllMenu.setDisable(false);
            TreeItem selected = (TreeItem)this.scriptTree.getSelectionModel().getSelectedItem();
            if (selected != null && selected.getValue() != null) {
                this.enqueueSelectedMenu.setDisable(false);
            }
            for (TestCaseProperties testCase : this.testCaseManager.getTestCasesProperties()) {
                if (TestCaseStatus.PASSED.equals(testCase.statusProperty().getValue())) {
                    ++passes;
                } else if (TestCaseStatus.FAILED.equals(testCase.statusProperty().getValue())) {
                    ++failures;
                } else if (TestCaseStatus.SKIPPED.equals(testCase.statusProperty().getValue())) {
                    ++skipped;
                }
                run = passes + failures + skipped;
            }
            this.enqueueNotRunMenu.setDisable(run == this.testCaseManager.getTotalCount());
            this.enqueueFailedMenu.setDisable(failures <= 0);
        }
        this.passesLabel.setText(this.passesLabel.getText().substring(0, this.passesLabel.getText().indexOf(" ") + 1) + passes);
        this.failuresLabel.setText(this.failuresLabel.getText().substring(0, this.failuresLabel.getText().indexOf(" ") + 1) + failures);
        this.skippedLabel.setText(this.skippedLabel.getText().substring(0, this.skippedLabel.getText().indexOf(" ") + 1) + skipped);
        this.runLabel.setText(this.runLabel.getText().substring(0, this.runLabel.getText().indexOf(" ") + 1) + run);
        if (this.scriptsLocation != null) {
            String parentDir = this.scriptsLocation + System.getProperty("file.separator");
            this.testCaseManager.exportTestCasesResultsAsCSV(new File(parentDir + "results_" + TestCaseManager.testCasesFileSdf.format(new Date()) + ".csv"));
        }
    }

    public void showSelected() {
        TreeItem selected = (TreeItem)this.scriptTree.getSelectionModel().getSelectedItem();
        if (selected != null && selected.getValue() != null) {
            TestCaseProperties testCaseProperties = (TestCaseProperties)selected.getValue();
            logger.info("About to display selected test case - " + testCaseProperties.getName());
            this.testCaseExecutionPaneController.display(testCaseProperties, testCaseProperties.getSteps());
        } else {
            logger.warn("No test case selected");
        }
    }

    @Override
    public TitledPane getTitledPane() {
        return this.pane;
    }

    @Override
    public void setTitledPane(TitledPane pane) {
        this.pane = pane;
    }

    @Override
    public void updatePane(PaneVisibilityStatus status) {
        if (PaneVisibilityStatus.ATTACHED.equals((Object)status)) {
            this.settingsButton.setVisible(true);
        } else {
            this.settingsButton.setVisible(false);
        }
    }

    @Override
    public Label getTitleLabel() {
        return this.titleLabel;
    }

    public void setScriptManager(BaseScriptManagerInterface scriptManager) {
        this.scriptManager = scriptManager;
    }

    public void setSettingsButton(MenuButton settingsButton) {
        this.settingsButton = settingsButton;
    }
}

