/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.ui.controllers;

import java.io.File;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Insets;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuButton;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.HBox;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.spy.eventbus.IKBus;
import pl.baczkowicz.spy.files.FileUtils;
import pl.baczkowicz.spy.messages.FormattedMessage;
import pl.baczkowicz.spy.ui.events.MessageAddedEvent;
import pl.baczkowicz.spy.ui.events.MessageIndexChangeEvent;
import pl.baczkowicz.spy.ui.events.MessageIndexIncrementEvent;
import pl.baczkowicz.spy.ui.events.MessageIndexToFirstEvent;
import pl.baczkowicz.spy.ui.events.MessageRemovedEvent;
import pl.baczkowicz.spy.ui.events.queuable.ui.BrowseRemovedMessageEvent;
import pl.baczkowicz.spy.ui.storage.BasicMessageStoreWithSummary;
import pl.baczkowicz.spy.ui.storage.ManagedMessageStoreWithFiltering;
import pl.baczkowicz.spy.ui.storage.MessageAuditUtils;
import pl.baczkowicz.spy.ui.utils.TextUtils;
import pl.baczkowicz.spy.ui.utils.UiUtils;

public class MessageNavigationController
implements Initializable {
    static final Logger logger = LoggerFactory.getLogger(MessageNavigationController.class);
    @FXML
    private Label messageLabel;
    @FXML
    private Label filterStatusLabel;
    @FXML
    private CheckBox showLatestBox;
    @FXML
    private ToggleGroup wholeMessageFormat;
    @FXML
    private MenuButton formattingMenuButton;
    @FXML
    private Menu formatterMenu;
    @FXML
    private Menu customFormatterMenu;
    @FXML
    private ToggleGroup selectionFormat;
    @FXML
    private Button moreRecentButton;
    @FXML
    private Button lessRecentButton;
    @FXML
    private Button showFirstButton;
    @FXML
    private Button showLastButton;
    @FXML
    private HBox messageIndexBox;
    private int selectedMessage;
    private BasicMessageStoreWithSummary<? extends FormattedMessage> store;
    private TextField messageIndexValueField;
    private Label totalMessagesValueLabel;
    private IKBus eventBus;
    private int messagesShown = 1;
    private MessageAuditUtils messageAuditUtils;

    public void initialize(URL location, ResourceBundle resources) {
        this.messageIndexValueField = new TextField();
        this.messageIndexValueField.setEditable(false);
        this.messageIndexValueField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> ob, String o, String n) {
                MessageNavigationController.this.messageIndexValueField.setPrefWidth(TextUtils.computeTextWidth(MessageNavigationController.this.messageIndexValueField.getFont(), MessageNavigationController.this.messageIndexValueField.getText()) + 12.0);
            }
        });
        this.messageLabel.getStyleClass().add((Object)"messageIndex");
        this.messageLabel.setPadding(new Insets(2.0, 2.0, 2.0, 2.0));
        this.totalMessagesValueLabel = new Label();
        this.totalMessagesValueLabel.getStyleClass().add((Object)"messageIndex");
        this.totalMessagesValueLabel.setPadding(new Insets(2.0, 2.0, 2.0, 2.0));
        this.filterStatusLabel = new Label();
        this.filterStatusLabel.getStyleClass().add((Object)"filterOn");
        this.filterStatusLabel.setPadding(new Insets(2.0, 2.0, 2.0, 2.0));
        this.messageIndexValueField.setPadding(new Insets(2.0, 5.0, 2.0, 5.0));
        this.messageIndexValueField.getStyleClass().add((Object)"messageIndex");
        this.messageIndexValueField.addEventFilter(ScrollEvent.SCROLL, (EventHandler)new EventHandler<ScrollEvent>(){

            public void handle(ScrollEvent event) {
                switch (event.getTextDeltaYUnits()) {
                    case LINES: {
                        MessageNavigationController.this.updateMessageIndexFromScroll((int)event.getTextDeltaY());
                        break;
                    }
                    case PAGES: {
                        MessageNavigationController.this.updateMessageIndexFromScroll((int)event.getTextDeltaY());
                        break;
                    }
                    case NONE: {
                        MessageNavigationController.this.updateMessageIndexFromScroll((int)event.getDeltaY());
                    }
                }
            }
        });
        this.messageIndexValueField.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent keyEvent) {
                switch (keyEvent.getCode()) {
                    case SPACE: {
                        MessageNavigationController.this.showLatestBox.setSelected(!MessageNavigationController.this.showLatestBox.isSelected());
                        break;
                    }
                    case HOME: {
                        MessageNavigationController.this.showFirst();
                        break;
                    }
                    case END: {
                        MessageNavigationController.this.showLast();
                        break;
                    }
                    case PAGE_UP: {
                        MessageNavigationController.this.changeSelectedMessageIndexDelta(5);
                        break;
                    }
                    case PAGE_DOWN: {
                        MessageNavigationController.this.changeSelectedMessageIndexDelta(-5);
                        break;
                    }
                    case UP: {
                        MessageNavigationController.this.changeSelectedMessageIndexDelta(1);
                        break;
                    }
                    case DOWN: {
                        MessageNavigationController.this.changeSelectedMessageIndexDelta(-1);
                        break;
                    }
                }
            }
        });
    }

    public void updateRange(int newValue) {
        this.messagesShown = newValue;
        this.updateIndex(false);
    }

    public void init() {
        this.moreRecentButton.setTooltip(new Tooltip("Show more recent message"));
        this.lessRecentButton.setTooltip(new Tooltip("Show less recent message"));
        this.showFirstButton.setTooltip(new Tooltip("Show the latest message"));
        this.showLastButton.setTooltip(new Tooltip("Show the oldest message"));
    }

    @FXML
    private void showFirst() {
        this.showFirstMessage();
    }

    @FXML
    private void showLast() {
        this.showLastMessage();
    }

    @FXML
    private void showMoreRecent() {
        this.changeSelectedMessageIndexDelta(-1);
    }

    @FXML
    private void showLessRecent() {
        this.changeSelectedMessageIndexDelta(1);
    }

    public void onMessageAdded(MessageAddedEvent<FormattedMessage> event) {
        if (this.showLatest()) {
            this.onNavigateToFirst(new MessageIndexToFirstEvent(this));
        } else {
            this.onMessageIndexIncrement(new MessageIndexIncrementEvent(event.getMessages().size(), this.store));
        }
    }

    public void onMessageIndexChange(MessageIndexChangeEvent event) {
        if (event.getDispatcher() == this) {
            return;
        }
        if (this.selectedMessage != event.getIndex()) {
            this.changeSelectedMessageIndexAbsolute(event.getIndex());
        }
    }

    public void onNavigateToFirst(MessageIndexToFirstEvent event) {
        this.showFirstMessage();
    }

    public void onMessageIndexIncrement(MessageIndexIncrementEvent event) {
        this.selectedMessage += event.getIncrement();
        this.updateIndex(false);
    }

    public void onMessageRemoved(MessageRemovedEvent<FormattedMessage> event) {
        for (BrowseRemovedMessageEvent<FormattedMessage> message : event.getMessages()) {
            if (message.getMessageIndex() >= this.selectedMessage) continue;
            --this.selectedMessage;
        }
        this.updateIndex(false);
    }

    private void showFirstMessage() {
        if (this.store.getMessages().size() > 0) {
            this.selectedMessage = 1;
            this.updateIndex();
        } else {
            this.selectedMessage = 0;
            this.updateIndex();
        }
    }

    private int getMaxMessageIndex() {
        return this.store.getMessages().size() - this.messagesShown + 1;
    }

    private void showLastMessage() {
        if (this.getMaxMessageIndex() > 0) {
            this.selectedMessage = this.getMaxMessageIndex();
            this.updateIndex();
        }
    }

    private void changeSelectedMessageIndexDelta(int count) {
        this.changeSelectedMessageIndexAbsolute(this.selectedMessage + count);
    }

    private void changeSelectedMessageIndexAbsolute(int absolute) {
        if (this.getMaxMessageIndex() > 0) {
            if (absolute <= 1) {
                this.showFirstMessage();
            } else if (absolute >= this.getMaxMessageIndex()) {
                this.showLastMessage();
            } else {
                this.selectedMessage = absolute;
                this.updateIndex();
            }
        }
    }

    private void updateIndex() {
        this.updateIndex(true);
    }

    private void updateIndex(boolean refreshMessageDetails) {
        String selectedIndexValue = "-";
        if (this.selectedMessage > 0) {
            selectedIndexValue = this.messagesShown == 1 ? String.valueOf(this.selectedMessage) : String.valueOf(this.selectedMessage) + "-" + String.valueOf(this.selectedMessage + this.messagesShown - 1);
        }
        String totalMessagesValue = "/ " + this.store.getMessages().size();
        if (this.messageIndexBox.getChildren().size() == 1) {
            this.messageLabel.setText("Message ");
            this.messageIndexBox.getChildren().add((Object)this.messageIndexValueField);
            this.messageIndexBox.getChildren().add((Object)this.totalMessagesValueLabel);
            this.messageIndexBox.getChildren().add((Object)this.filterStatusLabel);
        }
        this.messageIndexValueField.setText(selectedIndexValue);
        this.totalMessagesValueLabel.setText(totalMessagesValue);
        this.updateFilterStatus();
        if (refreshMessageDetails) {
            this.eventBus.publish(new MessageIndexChangeEvent(this.selectedMessage, this.store, this));
        }
    }

    private void updateFilterStatus() {
        if (!this.store.browsingFiltersEnabled()) {
            if (!this.store.messageFiltersEnabled()) {
                this.filterStatusLabel.setText("");
            } else {
                this.filterStatusLabel.setText("(filter is active)");
            }
        } else if (this.store instanceof ManagedMessageStoreWithFiltering) {
            if (!this.store.messageFiltersEnabled()) {
                this.filterStatusLabel.setText("(" + MessageNavigationController.getBrowsingTopicsInfo((ManagedMessageStoreWithFiltering)this.store) + ")");
            } else {
                this.filterStatusLabel.setText("(" + MessageNavigationController.getBrowsingTopicsInfo((ManagedMessageStoreWithFiltering)this.store) + "; filter is active)");
            }
        }
    }

    public static String getBrowsingTopicsInfo(ManagedMessageStoreWithFiltering<?> store) {
        int selectedTopics = store.getFilteredMessageStore().getBrowsedTopics().size();
        int totalTopics = store.getAllTopics().size();
        return "browsing " + selectedTopics + "/" + totalTopics + " " + (totalTopics == 1 ? "topic" : "topics");
    }

    private void updateMessageIndexFromScroll(int scroll) {
        if (scroll > 0) {
            this.changeSelectedMessageIndexDelta(1);
        } else {
            this.changeSelectedMessageIndexDelta(-1);
        }
    }

    public void clear() {
        this.messageLabel.setText("No messages");
        this.messageIndexBox.getChildren().clear();
        this.messageIndexBox.getChildren().add((Object)this.messageLabel);
    }

    public boolean showLatest() {
        return this.showLatestBox.isSelected();
    }

    public void hideShowLatest() {
        this.showLatestBox.setVisible(false);
    }

    public void copyMessageToClipboard() {
        if (this.getSelectedMessageIndex() > 0) {
            UiUtils.copyToClipboard(this.messageAuditUtils.getCurrentMessageAsMessageLog(this.store, this.getSelectedMessageIndex() - 1));
        }
    }

    public void copyMessagesToClipboard() {
        UiUtils.copyToClipboard(this.messageAuditUtils.getAllMessagesAsMessageLog(this.store));
    }

    public void copyMessageTopicToClipboard() {
        if (this.getSelectedMessageIndex() > 0) {
            FormattedMessage message = (FormattedMessage)this.store.getMessages().get(this.getSelectedMessageIndex() - 1);
            UiUtils.copyToClipboard(message.getTopic());
        }
    }

    public void copyMessageToFile() {
        if (this.getSelectedMessageIndex() > 0) {
            FileChooser fileChooser = new FileChooser();
            fileChooser.setTitle("Select message audit log file to save to");
            String extensions = "messages";
            fileChooser.setSelectedExtensionFilter(new FileChooser.ExtensionFilter("Message audit log file", new String[]{extensions}));
            File selectedFile = fileChooser.showSaveDialog(this.getParentWindow());
            if (selectedFile != null) {
                FileUtils.writeToFile(selectedFile, this.messageAuditUtils.getCurrentMessageAsMessageLog(this.store, this.getSelectedMessageIndex() - 1));
            }
        }
    }

    public void copyMessageToBinaryFile() {
        if (this.getSelectedMessageIndex() > 0) {
            FileChooser fileChooser = new FileChooser();
            fileChooser.setTitle("Select file to save to");
            String extensions = "*";
            fileChooser.setSelectedExtensionFilter(new FileChooser.ExtensionFilter("File", new String[]{extensions}));
            File selectedFile = fileChooser.showSaveDialog(this.getParentWindow());
            if (selectedFile != null) {
                FileUtils.writeToFile(selectedFile, ((FormattedMessage)this.store.getMessages().get(this.getSelectedMessageIndex() - 1)).getRawPayload());
            }
        }
    }

    public void copyMessagesToFile() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Select message audit log file to save to");
        String extensions = "messages";
        fileChooser.setSelectedExtensionFilter(new FileChooser.ExtensionFilter("Message audit log file", new String[]{extensions}));
        File selectedFile = fileChooser.showSaveDialog(this.getParentWindow());
        if (selectedFile != null) {
            FileUtils.writeToFile(selectedFile, this.messageAuditUtils.getAllMessagesAsMessageLog(this.store));
        }
    }

    private Window getParentWindow() {
        return this.messageLabel.getScene().getWindow();
    }

    public void setMessageAuditUtils(MessageAuditUtils messageAuditUtils) {
        this.messageAuditUtils = messageAuditUtils;
    }

    public void setStore(BasicMessageStoreWithSummary<? extends FormattedMessage> store) {
        this.store = store;
    }

    public int getSelectedMessageIndex() {
        return this.selectedMessage;
    }

    public void setViewVisibility(boolean detailedView) {
    }

    public void toggleDetaileledViewVisibility() {
    }

    public void setEventBus(IKBus eventBus) {
        this.eventBus = eventBus;
    }
}

