/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.ui.controllers;

import java.net.URL;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.AnchorPane;
import javafx.util.Callback;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.spy.common.generated.ConversionMethod;
import pl.baczkowicz.spy.common.generated.FormatterDetails;
import pl.baczkowicz.spy.common.generated.FormatterFunction;
import pl.baczkowicz.spy.common.generated.ScriptExecutionDetails;
import pl.baczkowicz.spy.eventbus.IKBus;
import pl.baczkowicz.spy.formatting.FormattingManager;
import pl.baczkowicz.spy.formatting.FormattingUtils;
import pl.baczkowicz.spy.formatting.ScriptBasedFormatter;
import pl.baczkowicz.spy.messages.FormattedMessage;
import pl.baczkowicz.spy.scripts.BaseScriptManagerInterface;
import pl.baczkowicz.spy.scripts.Script;
import pl.baczkowicz.spy.ui.configuration.IConfigurationManager;
import pl.baczkowicz.spy.ui.events.FormattersChangedEvent;
import pl.baczkowicz.spy.ui.utils.DialogFactory;
import pl.baczkowicz.spy.ui.utils.TooltipFactory;
import pl.baczkowicz.spy.utils.ConversionUtils;

public class FormattersController
implements Initializable {
    static final Logger logger = LoggerFactory.getLogger(FormattersController.class);
    @FXML
    private Label detailsLabel;
    @FXML
    private TextArea sampleInput;
    @FXML
    private TextArea sampleOutput;
    @FXML
    private TextArea formatterDetails;
    @FXML
    private TextField formatterName;
    @FXML
    private TextField formatterType;
    @FXML
    private ListView<FormatterDetails> formattersList;
    @FXML
    private Button newButton;
    @FXML
    private Button applyChangesButton;
    @FXML
    private Button deleteButton;
    private FormatterDetails selectedFormatter = FormattingUtils.createBasicFormatter("default", "Plain", "", ConversionMethod.PLAIN);
    private IConfigurationManager configurationManager;
    private ScriptBasedFormatter scriptBasedFormatter;
    private final ChangeListener basicOnChangeListener = new ChangeListener(){

        public void changed(ObservableValue observable, Object oldValue, Object newValue) {
            FormattersController.this.onChange();
        }
    };
    private FormatterDetails newFormatter;
    private boolean ignoreChanges;
    private IKBus eventBus;
    @FXML
    private AnchorPane formattersWindow;
    private BaseScriptManagerInterface scriptManager;

    public void initialize(URL location, ResourceBundle resources) {
        this.formatterName.textProperty().addListener(this.basicOnChangeListener);
        this.formatterDetails.textProperty().addListener(this.basicOnChangeListener);
        this.sampleInput.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                FormattedMessage message = new FormattedMessage(0L, "");
                message.setRawPayload(FormattersController.this.sampleInput.getText().getBytes());
                message.setPayload(FormattersController.this.sampleInput.getText());
                FormattersController.this.formatInput(message);
            }
        });
        this.formattersList.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<FormatterDetails>(){

            public void changed(ObservableValue<? extends FormatterDetails> observable, FormatterDetails oldValue, FormatterDetails newValue) {
                FormattersController.this.selectedFormatter = newValue;
                FormattersController.this.showFormatterInfo();
            }
        });
        this.formattersList.setCellFactory((Callback)new Callback<ListView<FormatterDetails>, ListCell<FormatterDetails>>(){

            public ListCell<FormatterDetails> call(ListView<FormatterDetails> l) {
                return new ListCell<FormatterDetails>(){

                    protected void updateItem(FormatterDetails item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item == null || empty) {
                            this.setText(null);
                        } else {
                            this.setText(item == FormattersController.this.newFormatter ? "* " + item.getName() : item.getName());
                        }
                    }
                };
            }
        });
    }

    public void init() {
        this.scriptBasedFormatter = new ScriptBasedFormatter(this.scriptManager);
        this.formattersList.getItems().clear();
        List<FormatterDetails> defaultFormatters = FormattingUtils.createBaseFormatters();
        defaultFormatters.addAll(FormattingManager.createDefaultScriptFormatters());
        this.formattersList.getItems().addAll(defaultFormatters);
        FormattersController.addFormattersToList(this.configurationManager.getFormatters(), (ObservableList<FormatterDetails>)this.formattersList.getItems());
        this.formattersList.getSelectionModel().select(0);
    }

    private void readValues(FormatterDetails formatter) {
        formatter.setName(this.formatterName.getText());
        if (FormattingUtils.isScriptBased(formatter)) {
            formatter.getFunction().get(0).getScriptExecution().setInlineScript(ConversionUtils.stringToBase64(this.formatterDetails.getText()));
        }
    }

    private void checkInlineScript(FormatterDetails formatter) throws ScriptException {
        Script script = this.scriptBasedFormatter.getScript(formatter);
        script.setScriptContent(this.formatterDetails.getText());
        this.scriptBasedFormatter.evaluate(script);
        if (script.getScriptRunner().getLastThrownException() != null) {
            this.formatterDetails.getStyleClass().add((Object)"invalid");
        } else {
            FormattedMessage message = new FormattedMessage(0L, "");
            message.setRawPayload(this.sampleInput.getText().getBytes());
            this.sampleOutput.setText(this.scriptBasedFormatter.formatMessage(formatter, message, true));
            this.formatterDetails.getStyleClass().add((Object)"valid");
        }
    }

    private void onChange() {
        if (this.ignoreChanges || this.newFormatter == null && this.selectedFormatter == null) {
            return;
        }
        this.formatterDetails.getStyleClass().removeAll((Object[])new String[]{"valid", "invalid"});
        this.applyChangesButton.setDisable(true);
        if (this.newFormatter != null) {
            try {
                this.checkInlineScript(this.newFormatter);
                this.applyChangesButton.setDisable(false);
            }
            catch (ScriptException e) {
                this.formatterDetails.getStyleClass().add((Object)"invalid");
                logger.error("Script error", e);
            }
            return;
        }
        if (this.selectedFormatter.getID().startsWith("script")) {
            try {
                if (!this.formatterName.getText().equals(this.selectedFormatter.getName()) || !this.formatterDetails.getText().equals(this.scriptBasedFormatter.getScript(this.selectedFormatter).getScriptContent())) {
                    this.checkInlineScript(this.selectedFormatter);
                    this.applyChangesButton.setDisable(false);
                }
            }
            catch (ScriptException e) {
                logger.error("Script error: ", e);
            }
        }
    }

    public static void addFormattersToList(List<FormatterDetails> formatters, ObservableList<FormatterDetails> observableList) {
        for (FormatterDetails formatterDetails : formatters) {
            boolean found = false;
            for (FormatterDetails existingFormatterDetails : observableList) {
                if (!existingFormatterDetails.getID().equals(formatterDetails.getID())) continue;
                found = true;
                break;
            }
            if (found) continue;
            observableList.add((Object)formatterDetails);
        }
    }

    @FXML
    private void deleteFormatter() {
        if (this.selectedFormatter == null) {
            return;
        }
        int count = this.configurationManager.countFormatter(this.selectedFormatter);
        Optional<ButtonType> result = null;
        if (count > 0) {
            result = DialogFactory.createQuestionDialog("Formatter is still in use", "There are " + count + " connections configured with this formatter. Are you sure you want to delete it?", false);
        }
        if ((count == 0 || result.get() == ButtonType.YES) && this.configurationManager.removeFormatter(this.selectedFormatter)) {
            TooltipFactory.createTooltip(this.deleteButton, "Formatter deleted. Changes saved.");
            this.init();
            this.formattersList.getSelectionModel().selectFirst();
            this.eventBus.publish(new FormattersChangedEvent());
        }
    }

    @FXML
    private void newFormatter() throws ScriptException {
        this.ignoreChanges = true;
        this.selectedFormatter = null;
        this.newFormatter = new FormatterDetails();
        Optional<String> name = DialogFactory.createInputDialog(this.formattersWindow.getScene().getWindow(), "Enter formatter name", "Name for the new formatter");
        boolean cancelled = !name.isPresent();
        boolean valid = false;
        block0: while (!cancelled && !valid) {
            this.newFormatter.setID("script-" + name.get().replace(" ", "-").toLowerCase());
            this.newFormatter.setName(name.get());
            valid = true;
            for (FormatterDetails formatter : this.formattersList.getItems()) {
                logger.info("{}, {}, {}, {}", formatter.getName(), this.newFormatter.getName(), formatter.getID(), this.newFormatter.getID());
                if (!formatter.getName().equals(this.newFormatter.getName()) && !formatter.getID().equals(this.newFormatter.getID())) continue;
                DialogFactory.createWarningDialog("Invalid name", "Entered formatter name/ID already exists. Please chose a different one.");
                name = DialogFactory.createInputDialog(this.formattersWindow.getScene().getWindow(), "Enter formatter name", "Name for the new formatter");
                cancelled = name.isPresent();
                valid = false;
                continue block0;
            }
        }
        if (!cancelled & valid) {
            this.newFormatter.setID("script-" + name.get().replace(" ", "-").toLowerCase());
            this.newFormatter.setName(name.get());
            this.formattersList.getItems().add((Object)this.newFormatter);
            this.formattersList.getSelectionModel().select((Object)this.newFormatter);
            ScriptExecutionDetails scriptExecution = new ScriptExecutionDetails("ZnVuY3Rpb24gZm9ybWF0KCkKewkKCXJldHVybiByZWNlaXZlZE1lc3NhZ2UuZ2V0UGF5bG9hZCgpICsgIi0gbW9kaWZpZWQhIjsKfQ==");
            this.newFormatter.getFunction().add(new FormatterFunction(null, null, null, null, null, scriptExecution));
            this.formatterName.setText(this.newFormatter.getName());
            this.formatterType.setText("Script-based");
            this.detailsLabel.setText("Inline script");
            this.scriptBasedFormatter.addFormatter(this.newFormatter);
            this.formatterDetails.setText(this.scriptBasedFormatter.getScript(this.newFormatter).getScriptContent());
            FormattedMessage message = new FormattedMessage(0L, "");
            message.setRawPayload(this.sampleInput.getText().getBytes());
            this.sampleOutput.setText(this.scriptBasedFormatter.formatMessage(this.newFormatter, message, true));
            this.newButton.setDisable(true);
            this.applyChangesButton.setDisable(false);
            this.deleteButton.setDisable(true);
            this.eventBus.publish(new FormattersChangedEvent());
        }
        this.ignoreChanges = false;
    }

    @FXML
    private void applyChanges() {
        if (this.newFormatter != null) {
            this.readValues(this.newFormatter);
            this.configurationManager.getFormatters().add(this.newFormatter);
        } else {
            this.readValues(this.selectedFormatter);
        }
        if (this.configurationManager.saveConfiguration()) {
            TooltipFactory.createTooltip(this.newButton, "Formatter added. Changes saved.");
            this.init();
            this.formattersList.getSelectionModel().selectFirst();
            this.eventBus.publish(new FormattersChangedEvent());
        }
    }

    private void formatInput(FormattedMessage message) {
        if (FormattingUtils.isScriptBased(this.selectedFormatter)) {
            logger.debug("Formatting using {} with content {}", (Object)this.selectedFormatter.getName(), (Object)message.getPayload());
            message.setFormattedPayload(this.scriptBasedFormatter.formatMessage(this.selectedFormatter, message, false));
            logger.debug("Value set = {}", (Object)message.getFormattedPayload());
            message.setPrettyPayload(this.scriptBasedFormatter.formatMessage(this.selectedFormatter, message, true));
            logger.debug("Pretty value set = {}", (Object)message.getPrettyPayload());
        } else {
            message.setFormattedPayload(FormattingUtils.checkAndFormatText(this.selectedFormatter, message.getRawPayload()));
            message.setPrettyPayload(message.getFormattedPayload());
        }
        this.sampleOutput.setText(message.getPrettyPayload());
    }

    private void showFormatterInfo() {
        if (this.selectedFormatter == this.newFormatter) {
            return;
        }
        this.ignoreChanges = true;
        if (this.newFormatter != null) {
            this.formattersList.getItems().remove((Object)this.newFormatter);
            this.newFormatter = null;
        } else if (this.selectedFormatter != null) {
            this.newButton.setDisable(false);
            this.deleteButton.setDisable(false);
            this.detailsLabel.setText("Details");
            this.formatterName.setText(this.selectedFormatter.getName());
            if (FormattingUtils.isDefault(this.selectedFormatter)) {
                this.formatterType.setText("Built-in");
                this.formatterDetails.setText(this.selectedFormatter.getDescription());
                this.deleteButton.setDisable(true);
                if (this.selectedFormatter.getName().startsWith("Plain")) {
                    this.sampleInput.setText("hello from mqtt-spy!");
                } else if (this.selectedFormatter.getName().contains("JSON")) {
                    this.sampleInput.setText("{hello: {from: \"mqtt-spy\", message: \"welcome!\"}}");
                } else if (this.selectedFormatter.getName().contains("XML")) {
                    this.sampleInput.setText("<hello><from>mqtt-spy</from><message>welcome!</message></hello>");
                } else if (this.selectedFormatter.getName().startsWith("Base64 decoder")) {
                    this.sampleInput.setText(ConversionUtils.stringToBase64("hello from mqtt-spy!"));
                } else if (this.selectedFormatter.getName().startsWith("Base64 encoder")) {
                    this.sampleInput.setText("hello from mqtt-spy!");
                } else if (this.selectedFormatter.getName().startsWith("HEX decoder")) {
                    this.sampleInput.setText(ConversionUtils.stringToHex("hello from mqtt-spy!"));
                } else if (this.selectedFormatter.getName().startsWith("HEX encoder")) {
                    this.sampleInput.setText("hello from mqtt-spy!");
                }
                FormattedMessage message = new FormattedMessage(0L, "");
                if (this.selectedFormatter.getName().startsWith("Eclipse Kura")) {
                    String base64encoded = "H4sIAAAAAAAAAHWR227TQBCGoSU9bB0aSkFNA8JIXLSAjZ0DQeKqpEGINk6V0qJeWZv1Jiz1HrQ+tOHJuObJmHUSkSDwjUf7zcw/889ObfPO7HswD6rz4NfPlX1UJlIISlImRchUpfRh/SI4CfpfA6AHaON7zkOBOQWw/xnn2P4k03Ml04MvvUO7EzMqUvuyB7lltCITyCqdMpHdwoODtrFSMSN42jsydK/TDz46l/7rTu/Y/I67Z6f9K4ig4D3aMmpKyxGLjeBLI1gInXftQSZSxqndFTnTUnAj7LvvXM8Z+o06lFcRkkmYU52AHFRvNl3fbTt5+xXACloHiDX5BmQVa14UbGNCqEpDKoiMmBgDuzf+wRTAZ6icUM1wHIqMD6kGZA1woiDUE+eMFd5tcBnRGFb7B62iyohpfoM1XRhqNXhzBHAHWRFLVIwnc3PNMR4ha8iWdpilv5g68+f9Yb1lFm97Nme3NLLNHEWDtUwZl8z6vve23va9lgfgOdpdPLNIqR5hQpevXUO74DeL8TCm5gqEJonU5mp3m0WPxzIZs3CkYeIbqa8X5imB064R2kNWKlNwjVMu9QTQWr3VaDYNe4LQ1K/Zyn879hRtKazT/xteQ/eXJzDzd0nMVEKL/tZ1pvHCWOjkYnAU+m7D9X4DdrXTyAkDAAA=";
                    this.sampleInput.setText(ConversionUtils.base64ToString("H4sIAAAAAAAAAHWR227TQBCGoSU9bB0aSkFNA8JIXLSAjZ0DQeKqpEGINk6V0qJeWZv1Jiz1HrQ+tOHJuObJmHUSkSDwjUf7zcw/889ObfPO7HswD6rz4NfPlX1UJlIISlImRchUpfRh/SI4CfpfA6AHaON7zkOBOQWw/xnn2P4k03Ml04MvvUO7EzMqUvuyB7lltCITyCqdMpHdwoODtrFSMSN42jsydK/TDz46l/7rTu/Y/I67Z6f9K4ig4D3aMmpKyxGLjeBLI1gInXftQSZSxqndFTnTUnAj7LvvXM8Z+o06lFcRkkmYU52AHFRvNl3fbTt5+xXACloHiDX5BmQVa14UbGNCqEpDKoiMmBgDuzf+wRTAZ6icUM1wHIqMD6kGZA1woiDUE+eMFd5tcBnRGFb7B62iyohpfoM1XRhqNXhzBHAHWRFLVIwnc3PNMR4ha8iWdpilv5g68+f9Yb1lFm97Nme3NLLNHEWDtUwZl8z6vve23va9lgfgOdpdPLNIqR5hQpevXUO74DeL8TCm5gqEJonU5mp3m0WPxzIZs3CkYeIbqa8X5imB064R2kNWKlNwjVMu9QTQWr3VaDYNe4LQ1K/Zyn879hRtKazT/xteQ/eXJzDzd0nMVEKL/tZ1pvHCWOjkYnAU+m7D9X4DdrXTyAkDAAA="));
                    message.setRawPayload(ConversionUtils.base64ToArray("H4sIAAAAAAAAAHWR227TQBCGoSU9bB0aSkFNA8JIXLSAjZ0DQeKqpEGINk6V0qJeWZv1Jiz1HrQ+tOHJuObJmHUSkSDwjUf7zcw/889ObfPO7HswD6rz4NfPlX1UJlIISlImRchUpfRh/SI4CfpfA6AHaON7zkOBOQWw/xnn2P4k03Ml04MvvUO7EzMqUvuyB7lltCITyCqdMpHdwoODtrFSMSN42jsydK/TDz46l/7rTu/Y/I67Z6f9K4ig4D3aMmpKyxGLjeBLI1gInXftQSZSxqndFTnTUnAj7LvvXM8Z+o06lFcRkkmYU52AHFRvNl3fbTt5+xXACloHiDX5BmQVa14UbGNCqEpDKoiMmBgDuzf+wRTAZ6icUM1wHIqMD6kGZA1woiDUE+eMFd5tcBnRGFb7B62iyohpfoM1XRhqNXhzBHAHWRFLVIwnc3PNMR4ha8iWdpilv5g68+f9Yb1lFm97Nme3NLLNHEWDtUwZl8z6vve23va9lgfgOdpdPLNIqR5hQpevXUO74DeL8TCm5gqEJonU5mp3m0WPxzIZs3CkYeIbqa8X5imB064R2kNWKlNwjVMu9QTQWr3VaDYNe4LQ1K/Zyn879hRtKazT/xteQ/eXJzDzd0nMVEKL/tZ1pvHCWOjkYnAU+m7D9X4DdrXTyAkDAAA="));
                } else {
                    message.setRawPayload(this.sampleInput.getText().getBytes());
                    message.setPayload(this.sampleInput.getText());
                }
                this.formatInput(message);
            } else if (this.selectedFormatter.getID().startsWith("script")) {
                try {
                    this.scriptBasedFormatter.addFormatter(this.selectedFormatter);
                }
                catch (ScriptException e) {
                    logger.error("Script error", e);
                }
                this.formatterType.setText("Script-based");
                this.detailsLabel.setText("Inline script");
                try {
                    this.formatterDetails.setText(this.scriptBasedFormatter.getScript(this.selectedFormatter).getScriptContent());
                }
                catch (ScriptException e) {
                    logger.error("Script error", e);
                }
                FormattedMessage message = new FormattedMessage(0L, "");
                message.setRawPayload(this.sampleInput.getText().getBytes());
                message.setPayload(this.sampleInput.getText());
                this.formatInput(message);
            } else {
                logger.debug("Formatter = {} {}", (Object)this.selectedFormatter.getID(), (Object)this.selectedFormatter.getName());
                this.formatterType.setText("Function-based");
                this.formatterDetails.setText("(this formatter type has been deprecated)");
                this.sampleOutput.setText(FormattingUtils.formatText(this.selectedFormatter, this.sampleInput.getText(), this.sampleInput.getText().getBytes()));
            }
        }
        this.applyChangesButton.setDisable(true);
        this.ignoreChanges = false;
    }

    public void setConfigurationManager(IConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    public void setScriptManager(BaseScriptManagerInterface scriptManager) {
        this.scriptManager = scriptManager;
    }

    public void setEventBus(IKBus eventBus) {
        this.eventBus = eventBus;
    }
}

