/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.ui.controllers;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.MenuButton;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.spy.common.generated.ConnectionGroup;
import pl.baczkowicz.spy.common.generated.ConnectionGroupReference;
import pl.baczkowicz.spy.common.generated.ConnectionReference;
import pl.baczkowicz.spy.eventbus.IKBus;
import pl.baczkowicz.spy.ui.configuration.ConfiguredConnectionGroupDetails;
import pl.baczkowicz.spy.ui.configuration.IConfigurationManager;
import pl.baczkowicz.spy.ui.connections.IConnectionFactory;
import pl.baczkowicz.spy.ui.controllers.EditConnectionGroupController;
import pl.baczkowicz.spy.ui.controls.DragAndDropTreeViewCell;
import pl.baczkowicz.spy.ui.events.ConnectionNameChangedEvent;
import pl.baczkowicz.spy.ui.events.ConnectionStatusChangeEvent;
import pl.baczkowicz.spy.ui.events.CreateNewConnectionEvent;
import pl.baczkowicz.spy.ui.events.observers.ItemsReorderedObserver;
import pl.baczkowicz.spy.ui.panes.SpyPerspective;
import pl.baczkowicz.spy.ui.properties.ConnectionTreeItemProperties;
import pl.baczkowicz.spy.ui.properties.ModifiableConnection;
import pl.baczkowicz.spy.ui.threading.SimpleRunLaterExecutor;
import pl.baczkowicz.spy.ui.utils.DialogFactory;
import pl.baczkowicz.spy.ui.utils.TooltipFactory;

public class EditConnectionsController
extends AnchorPane
implements Initializable,
ItemsReorderedObserver {
    private static final Logger logger = LoggerFactory.getLogger(EditConnectionsController.class);
    @FXML
    private EditConnectionGroupController editConnectionGroupPaneController;
    @FXML
    private AnchorPane connectionDetailsPane;
    @FXML
    private TreeView<ConnectionTreeItemProperties> connectionList;
    @FXML
    private Button duplicateConnectionButton;
    @FXML
    private Button deleteConnectionButton;
    @FXML
    private Button importConnectionsButton;
    @FXML
    private Button applyAllButton;
    @FXML
    private Button undoAllButton;
    @FXML
    private Label changesDetectedLabel;
    private IConfigurationManager configurationManager;
    private List<ModifiableConnection> connections = new ArrayList<ModifiableConnection>();
    private IKBus eventBus;
    int lastUsedId = 0;
    final ConnectionTreeItemProperties rootItemProperties = new ConnectionTreeItemProperties(this.lastUsedId++);
    final TreeItem<ConnectionTreeItemProperties> rootItem = new TreeItem((Object)this.rootItemProperties);
    private List<ConfiguredConnectionGroupDetails> groups;
    private IConnectionFactory connectionFactory;
    @FXML
    private Node editConnectionGroupPane;
    @FXML
    private MenuButton newConnectionButton;

    public void initialize(URL location, ResourceBundle resources) {
        final EditConnectionsController controller = this;
        this.connectionList.setCellFactory((Callback)new Callback<TreeView<ConnectionTreeItemProperties>, TreeCell<ConnectionTreeItemProperties>>(){

            public TreeCell call(TreeView<ConnectionTreeItemProperties> treeView) {
                return new DragAndDropTreeViewCell(treeView, controller);
            }
        });
        this.duplicateConnectionButton.setDisable(true);
        this.deleteConnectionButton.setDisable(true);
        this.connectionList.setShowRoot(true);
        this.connectionList.setRoot(this.rootItem);
        this.rootItem.setExpanded(true);
        this.rootItem.expandedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (!EditConnectionsController.this.rootItem.isExpanded()) {
                    EditConnectionsController.this.rootItem.setExpanded(true);
                }
            }
        });
        this.connectionList.getStyleClass().add((Object)"connectionList");
        this.connectionList.getSelectionModel().selectedItemProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observable, Object oldValue, Object newValue) {
                logger.debug("Item selected = " + newValue);
                if (newValue == null) {
                    return;
                }
                EditConnectionsController.this.updateUIForSelectedItem((ConnectionTreeItemProperties)((TreeItem)newValue).getValue());
            }
        });
        this.connectionList.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (mouseEvent.getButton().equals((Object)MouseButton.PRIMARY) && mouseEvent.getClickCount() == 2 && EditConnectionsController.this.getSelectedItem() != null && !EditConnectionsController.this.getSelectedItem().isGroup()) {
                    EditConnectionsController.this.connectionFactory.openConnection(EditConnectionsController.this.getSelectedItem().getConnection());
                }
            }
        });
    }

    public void init() {
        this.connections = this.configurationManager.getConnections();
        this.newConnectionButton.getItems().addAll(0, this.connectionFactory.createMenuItems());
        this.groups = this.configurationManager.getConnectionGrops();
        this.rootItemProperties.setGroup(this.configurationManager.getRootGroup());
        this.eventBus.subscribe(this, this::onConnectionStatusChanged, ConnectionStatusChangeEvent.class, new SimpleRunLaterExecutor());
        this.eventBus.subscribe(this, this::onNewConnection, CreateNewConnectionEvent.class);
        this.editConnectionGroupPaneController.setEditConnectionsController(this);
        this.editConnectionGroupPaneController.setConnectionFactory(this.connectionFactory);
        this.editConnectionGroupPaneController.init();
        this.eventBus.subscribe(this, this::connectionNameChanged, ConnectionNameChangedEvent.class);
        this.connectionDetailsPane.getChildren().addAll(this.connectionFactory.loadControllers(this));
        this.connectionFactory.setRecordModifications(false);
        this.listConnections();
        this.connectionFactory.setRecordModifications(true);
    }

    private void populateConnections(List<ConfiguredConnectionGroupDetails> groups) {
        this.rootItem.getChildren().clear();
        this.rootItemProperties.getChildren().clear();
        ArrayList<ConnectionTreeItemProperties> treeItemGroupProperties = new ArrayList<ConnectionTreeItemProperties>();
        ArrayList<ConnectionTreeItemProperties> treeItemConnectionProperties = new ArrayList<ConnectionTreeItemProperties>();
        this.buildTree(this.rootItemProperties, treeItemGroupProperties, treeItemConnectionProperties);
        EditConnectionsController.addToTree(this.rootItem, this.rootItemProperties);
    }

    private void buildTree(ConnectionTreeItemProperties treeItem, List<ConnectionTreeItemProperties> treeItemGroupProperties, List<ConnectionTreeItemProperties> treeItemConnectionProperties) {
        ConfiguredConnectionGroupDetails group = (ConfiguredConnectionGroupDetails)treeItem.getGroup();
        for (ConnectionGroupReference connectionGroupReference : group.getSubgroups()) {
            ConfiguredConnectionGroupDetails subgroup = (ConfiguredConnectionGroupDetails)connectionGroupReference.getReference();
            ConnectionTreeItemProperties subgroupTreeItemProperties = new ConnectionTreeItemProperties(this.lastUsedId++);
            subgroupTreeItemProperties.setGroup(subgroup);
            treeItemGroupProperties.add(subgroupTreeItemProperties);
            subgroupTreeItemProperties.setParent(treeItem);
            treeItem.addChild(subgroupTreeItemProperties);
            this.buildTree(subgroupTreeItemProperties, treeItemGroupProperties, treeItemConnectionProperties);
        }
        for (ConnectionReference connectionReference : group.getConnections()) {
            ModifiableConnection connection = (ModifiableConnection)connectionReference.getReference();
            ConnectionTreeItemProperties connectionTreeItemProperties = new ConnectionTreeItemProperties(this.lastUsedId++);
            connectionTreeItemProperties.setConnection(connection);
            treeItemConnectionProperties.add(connectionTreeItemProperties);
            connectionTreeItemProperties.setParent(treeItem);
            treeItem.addChild(connectionTreeItemProperties);
        }
    }

    private static boolean addToTree(TreeItem<ConnectionTreeItemProperties> treeItem, ConnectionTreeItemProperties properties) {
        boolean added = false;
        for (ConnectionTreeItemProperties item : properties.getChildren()) {
            TreeItem newTreeItem = new TreeItem((Object)item);
            if (item.isGroup() && EditConnectionsController.addToTree((TreeItem<ConnectionTreeItemProperties>)newTreeItem, item)) {
                newTreeItem.setExpanded(true);
            }
            treeItem.getChildren().add((Object)newTreeItem);
            added = true;
        }
        return added;
    }

    public void updateUIForSelectedItem() {
        this.updateUIForSelectedItem(this.getSelectedItem());
    }

    public void updateUIForSelectedItem(ConnectionTreeItemProperties selected) {
        if (selected == null) {
            logger.debug("Selection is null");
            this.selectFirst();
            return;
        }
        if (this.connections.isEmpty() && this.groups.isEmpty()) {
            this.duplicateConnectionButton.setDisable(true);
            this.deleteConnectionButton.setDisable(true);
            this.connectionFactory.setEmptyConnectionListMode(true);
        } else {
            if (!selected.isGroup() || !selected.getGroup().getID().equals("default_group")) {
                this.deleteConnectionButton.setDisable(false);
            } else {
                this.deleteConnectionButton.setDisable(true);
            }
            this.duplicateConnectionButton.setDisable(selected.isGroup());
            this.connectionFactory.setEmptyConnectionListMode(false);
            this.connectionFactory.setVisible(selected.isGroup());
            this.editConnectionGroupPane.setVisible(selected.isGroup());
            if (selected.isGroup()) {
                this.editConnectionGroupPaneController.setRecordModifications(false);
                this.editConnectionGroupPaneController.editConnectionGroup((ConfiguredConnectionGroupDetails)selected.getGroup(), selected.getChildren());
                this.editConnectionGroupPaneController.setRecordModifications(true);
            } else if (!selected.getConnection().isBeingCreated()) {
                logger.trace("Editing connection {}", (Object)selected.getName());
                this.connectionFactory.setRecordModifications(false);
                this.connectionFactory.editConnection(selected.getConnection());
                this.connectionFactory.setRecordModifications(true);
            }
        }
    }

    private static void addToParentGroup(ConfiguredConnectionGroupDetails groupDetails, ConfiguredConnectionGroupDetails parent) {
        groupDetails.setGroup(new ConnectionGroupReference(parent));
        parent.getSubgroups().add(new ConnectionGroupReference(groupDetails));
    }

    private static void addToParentGroup(ModifiableConnection connectionDetails, ConfiguredConnectionGroupDetails parent) {
        connectionDetails.setGroup(new ConnectionGroupReference(parent));
        parent.getConnections().add(new ConnectionReference(connectionDetails));
    }

    public void onNewConnection(CreateNewConnectionEvent event) {
        this.newConnection(event.getProtocol());
    }

    public void newConnection(String protocol) {
        ModifiableConnection connectionDetails = this.connectionFactory.newConnection(protocol);
        EditConnectionsController.addToParentGroup(connectionDetails, this.configurationManager.getRootGroup());
        this.connections.add(connectionDetails);
        this.newConnectionMode(connectionDetails);
    }

    @FXML
    private void duplicateConnection() {
        ConnectionGroupReference parent = this.getSelectedItem().getConnection().getGroup();
        this.getSelectedItem().getConnection().setGroup(null);
        ModifiableConnection connectionDetails = this.connectionFactory.duplicateConnection(this.getSelectedItem().getConnection());
        if (connectionDetails != null) {
            this.getSelectedItem().getConnection().setGroup(parent);
            EditConnectionsController.addToParentGroup(connectionDetails, (ConfiguredConnectionGroupDetails)parent.getReference());
            this.connections.add(connectionDetails);
            this.newConnectionMode(connectionDetails);
        }
    }

    @FXML
    private void newGroup() {
        try {
            Optional<String> result = DialogFactory.createInputDialog(this.connectionList.getScene().getWindow(), "New connection group", "Please enter the connection group name: ");
            if (result.isPresent()) {
                ConnectionGroup group = new ConnectionGroup(this.configurationManager.generateConnectionGroupId(), result.get(), new ArrayList<ConnectionGroupReference>(), new ArrayList<ConnectionReference>());
                ConfiguredConnectionGroupDetails groupDetails = new ConfiguredConnectionGroupDetails(group, true);
                EditConnectionsController.addToParentGroup(groupDetails, this.configurationManager.getRootGroup());
                this.groups.add(groupDetails);
                this.listConnections();
                this.selectGroup(groupDetails);
            }
        }
        catch (Exception e) {
            logger.error("Cannot create a new group", e);
        }
    }

    @FXML
    private void deleteConnection() {
        ConnectionTreeItemProperties selected = this.getSelectedItem();
        if (this.getSelectedItem().isGroup()) {
            ConfiguredConnectionGroupDetails group = (ConfiguredConnectionGroupDetails)this.getSelectedItem().getGroup();
            String groupName = group.getName();
            int childrenCount = selected.getChildren().size();
            if (DialogFactory.createQuestionDialog("Deleting connection group", "Are you sure you want to delete connection group '" + groupName + "'" + (childrenCount == 0 ? "" : " and all subitems") + "? This cannot be undone.", false).get() == ButtonType.YES) {
                group.removeFromGroup();
                this.groups.remove(group);
                this.listConnections();
                this.selectFirst();
                logger.debug("Saving all connections");
                if (this.configurationManager.saveConfiguration()) {
                    TooltipFactory.createTooltip(this.deleteConnectionButton, "Connection group " + groupName + " deleted.");
                }
            }
        } else {
            ModifiableConnection connection = this.getSelectedItem().getConnection();
            connection.setDeleted(true);
            String connectionName = connection.getName();
            if (DialogFactory.createQuestionDialog("Deleting connection", "Are you sure you want to delete connection '" + connectionName + "'? This cannot be undone.", false).get() == ButtonType.YES) {
                this.connectionFactory.setRecordModifications(false);
                connection.removeFromGroup();
                this.connections.remove(connection);
                this.listConnections();
                this.selectFirst();
                this.connectionFactory.setRecordModifications(true);
                logger.debug("Saving all connections");
                if (this.configurationManager.saveConfiguration()) {
                    TooltipFactory.createTooltip(this.deleteConnectionButton, "Connection " + connectionName + " deleted.");
                }
            }
        }
    }

    @FXML
    private void undoAll() {
        ArrayList<ModifiableConnection> allConnections = new ArrayList<ModifiableConnection>();
        allConnections.addAll(this.connections);
        for (ModifiableConnection connection : allConnections) {
            if (connection.isNew()) {
                connection.removeFromGroup();
                this.connections.remove(connection);
                continue;
            }
            connection.undoAll();
        }
        ArrayList<ConfiguredConnectionGroupDetails> allGroups = new ArrayList<ConfiguredConnectionGroupDetails>();
        allGroups.addAll(this.groups);
        for (ConfiguredConnectionGroupDetails group : allGroups) {
            if (group.isNew()) {
                group.removeFromGroup();
                this.groups.remove(group);
                continue;
            }
            group.undoAll();
        }
        this.listConnections();
    }

    @FXML
    private void applyAll() {
        if (this.configurationManager.isConfigurationWritable()) {
            for (ModifiableConnection modifiableConnection : this.connections) {
                modifiableConnection.apply();
            }
            for (ModifiableConnection modifiableConnection : this.groups) {
                modifiableConnection.apply();
            }
            this.listConnections();
            logger.debug("Saving all connections & groups");
            if (this.configurationManager.saveConfiguration()) {
                TooltipFactory.createTooltip(this.applyAllButton, "Changes for all connections and groups have been saved.");
            } else {
                DialogFactory.createErrorDialog("Cannot save the configuration file", "Oops... an error has occurred while trying to save your configuration. Please check the log file for more information. Your changes were not saved.");
            }
        } else {
            DialogFactory.createErrorDialog("Cannot save the configuration file", "Oops... your configuration file isn't right. Please restore default configuration. ");
        }
    }

    @FXML
    private void importConnections() {
    }

    private void selectFirst() {
        logger.info("Selecting first item...");
        if (this.connections.size() > 0) {
            this.connectionList.getSelectionModel().select(0);
        }
    }

    public void selectConnection(ModifiableConnection connection) {
        this.selectConnection(this.rootItem, connection);
    }

    public void selectGroup(ConfiguredConnectionGroupDetails group) {
        this.selectGroup(this.rootItem, group);
    }

    public void selectConnection(TreeItem<ConnectionTreeItemProperties> parentItem, ModifiableConnection connection) {
        for (TreeItem treeItem : parentItem.getChildren()) {
            ConnectionTreeItemProperties item = (ConnectionTreeItemProperties)treeItem.getValue();
            if (!item.isGroup() && item.getConnection().equals(connection)) {
                this.connectionList.getSelectionModel().select((Object)treeItem);
                this.updateUIForSelectedItem(item);
                return;
            }
            this.selectConnection((TreeItem<ConnectionTreeItemProperties>)treeItem, connection);
        }
    }

    public void selectGroup(TreeItem<ConnectionTreeItemProperties> parentItem, ConfiguredConnectionGroupDetails group) {
        for (TreeItem treeItem : parentItem.getChildren()) {
            ConnectionTreeItemProperties item = (ConnectionTreeItemProperties)treeItem.getValue();
            if (item.isGroup() && item.getGroup().equals(group)) {
                this.connectionList.getSelectionModel().select((Object)treeItem);
                this.updateUIForSelectedItem(item);
                return;
            }
            this.selectGroup((TreeItem<ConnectionTreeItemProperties>)treeItem, group);
        }
    }

    private ConnectionTreeItemProperties getSelectedItem() {
        if (this.connectionList.getSelectionModel().getSelectedItem() == null) {
            return null;
        }
        return (ConnectionTreeItemProperties)((TreeItem)this.connectionList.getSelectionModel().getSelectedItem()).getValue();
    }

    public void listConnections() {
        int i;
        TreeItem selectedItem = (TreeItem)this.connectionList.getSelectionModel().getSelectedItem();
        ConnectionTreeItemProperties selected = null;
        if (selectedItem != null) {
            selected = (ConnectionTreeItemProperties)selectedItem.getValue();
        }
        this.applyAllButton.setDisable(true);
        this.undoAllButton.setDisable(true);
        this.setChangesInfoLabelVisibility(false);
        this.populateConnections(this.groups);
        for (i = 0; i < this.connections.size(); ++i) {
            if (!this.connections.get(i).isModified() && !this.connections.get(i).isGroupingModified()) continue;
            this.applyAllButton.setDisable(false);
            this.undoAllButton.setDisable(false);
            this.setChangesInfoLabelVisibility(true);
            break;
        }
        for (i = 0; i < this.groups.size(); ++i) {
            if (!this.groups.get(i).isModified() && !this.groups.get(i).isGroupingModified()) continue;
            this.applyAllButton.setDisable(false);
            this.undoAllButton.setDisable(false);
            this.setChangesInfoLabelVisibility(true);
            break;
        }
        if (selected != null) {
            if (selected.isGroup()) {
                this.selectGroup((ConfiguredConnectionGroupDetails)selected.getGroup());
            } else {
                this.selectConnection(selected.getConnection());
            }
        } else {
            logger.debug("No selection present");
            this.selectFirst();
        }
        this.updateUIForSelectedItem();
    }

    public void setChangesInfoLabelVisibility(boolean visible) {
        if (visible) {
            AnchorPane.setBottomAnchor(this.connectionList, (Double)98.0);
        } else {
            AnchorPane.setBottomAnchor(this.connectionList, (Double)85.0);
        }
        this.changesDetectedLabel.setVisible(visible);
    }

    protected void connectionNameChanged(ConnectionNameChangedEvent event) {
        if (this.getSelectedItem() != null) {
            String newName = event.getName();
            this.getSelectedItem().getConnection().setName(newName);
            this.listConnections();
        }
    }

    private void newConnectionMode(ModifiableConnection createdConnection) {
        this.connectionFactory.setRecordModifications(false);
        this.listConnections();
        this.selectConnection(this.rootItem, createdConnection);
        this.connectionFactory.editConnection(createdConnection);
        this.connectionFactory.setRecordModifications(true);
    }

    public void openConnection(ModifiableConnection connectionDetails) {
        this.connectionFactory.openConnection(connectionDetails);
    }

    public void setConfigurationManager(IConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    public void onConnectionStatusChanged(ConnectionStatusChangeEvent event) {
        if (this.getSelectedItem() != null) {
            this.updateUIForSelectedItem();
        }
    }

    @Override
    public void onItemsReordered() {
        this.listConnections();
    }

    public void setPerspective(SpyPerspective perspective) {
        this.connectionFactory.setPerspective(perspective);
    }

    public void setEventBus(IKBus eventBus) {
        this.eventBus = eventBus;
    }

    public void setConnectionFactory(IConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }
}

