/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.ui.controllers;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.spy.exceptions.ConfigurationException;
import pl.baczkowicz.spy.ui.configuration.ConfiguredConnectionGroupDetails;
import pl.baczkowicz.spy.ui.connections.IConnectionFactory;
import pl.baczkowicz.spy.ui.controllers.EditConnectionsController;
import pl.baczkowicz.spy.ui.properties.ConnectionListItemProperties;
import pl.baczkowicz.spy.ui.properties.ConnectionTreeItemProperties;
import pl.baczkowicz.spy.ui.properties.ModifiableConnection;
import pl.baczkowicz.spy.ui.utils.UiUtils;

public class EditConnectionGroupController
extends AnchorPane
implements Initializable {
    static final Logger logger = LoggerFactory.getLogger(EditConnectionGroupController.class);
    @FXML
    private TextField connectionGroupNameText;
    @FXML
    private Button connectButton;
    @FXML
    private Button saveButton;
    @FXML
    private Button undoButton;
    @FXML
    private TableView<ConnectionListItemProperties> connectionList;
    @FXML
    private TableColumn<ConnectionListItemProperties, String> nameColumn;
    @FXML
    private TableColumn<ConnectionListItemProperties, String> protocolColumn;
    @FXML
    private TableColumn<ConnectionListItemProperties, String> detailsColumn;
    private ConfiguredConnectionGroupDetails editedConnectionGroupDetails;
    private List<ModifiableConnection> connections;
    private Map<ConnectionListItemProperties, ModifiableConnection> connectionMapping;
    private boolean recordModifications;
    private int noModificationsLock;
    private EditConnectionsController editConnectionsController;
    private IConnectionFactory connectionFactory;

    public void initialize(URL location, ResourceBundle resources) {
        this.nameColumn.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.protocolColumn.setCellValueFactory((Callback)new PropertyValueFactory("protocol"));
        this.protocolColumn.setCellFactory((Callback)new Callback<TableColumn<ConnectionListItemProperties, String>, TableCell<ConnectionListItemProperties, String>>(){

            public TableCell<ConnectionListItemProperties, String> call(TableColumn<ConnectionListItemProperties, String> param) {
                TableCell<ConnectionListItemProperties, String> cell = new TableCell<ConnectionListItemProperties, String>(){

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (this.getTableRow().getItem() != null) {
                            EditConnectionGroupController.this.connectionFactory.populateProtocolCell(this, item);
                        } else {
                            this.setGraphic(null);
                            this.setText(null);
                        }
                    }
                };
                cell.setAlignment(Pos.TOP_CENTER);
                return cell;
            }
        });
        this.detailsColumn.setCellValueFactory((Callback)new PropertyValueFactory("details"));
        this.detailsColumn.setCellFactory((Callback)new Callback<TableColumn<ConnectionListItemProperties, String>, TableCell<ConnectionListItemProperties, String>>(){

            public TableCell<ConnectionListItemProperties, String> call(TableColumn<ConnectionListItemProperties, String> param) {
                TableCell<ConnectionListItemProperties, String> cell = new TableCell<ConnectionListItemProperties, String>(){

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (this.getTableRow().getItem() != null) {
                            ConnectionListItemProperties row = (ConnectionListItemProperties)this.getTableRow().getItem();
                            this.setGraphic((Node)UiUtils.createSecurityIcons(row.isTlsEnabled(), row.isUserAuthenticationEnabled(), true));
                            this.setText(item);
                        } else {
                            this.setGraphic(null);
                            this.setText(null);
                        }
                    }
                };
                return cell;
            }
        });
        this.connectionList.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                ConnectionListItemProperties selected;
                if (mouseEvent.getButton().equals((Object)MouseButton.PRIMARY) && mouseEvent.getClickCount() == 2 && (selected = (ConnectionListItemProperties)EditConnectionGroupController.this.connectionList.getSelectionModel().getSelectedItem()) != null) {
                    EditConnectionGroupController.this.editConnectionsController.selectConnection((ModifiableConnection)EditConnectionGroupController.this.connectionMapping.get(selected));
                }
            }
        });
        this.connectionGroupNameText.textProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observable, Object oldValue, Object newValue) {
                EditConnectionGroupController.this.onChange();
            }
        });
    }

    public void init() {
    }

    @FXML
    private void undo() {
        this.editedConnectionGroupDetails.undo();
        this.editConnectionsController.listConnections();
        this.updateButtons();
    }

    @FXML
    private void save() {
        this.editedConnectionGroupDetails.apply();
        this.editConnectionsController.listConnections();
        this.updateButtons();
    }

    @FXML
    public void createConnection() throws ConfigurationException {
        for (ModifiableConnection connection : this.connections) {
            this.editConnectionsController.openConnection(connection);
        }
    }

    public void onChange() {
        if (this.recordModifications && this.readAndDetectChanges()) {
            this.updateButtons();
            this.editConnectionsController.listConnections();
        }
    }

    private boolean readAndDetectChanges() {
        this.editedConnectionGroupDetails.setName(this.connectionGroupNameText.getText());
        boolean changed = !this.editedConnectionGroupDetails.getName().equals(this.editedConnectionGroupDetails.getLastSavedValues().getName());
        logger.debug("Values read. Changed = " + changed);
        this.editedConnectionGroupDetails.setModified(changed);
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void editConnectionGroup(ConfiguredConnectionGroupDetails connectionGroup, List<ConnectionTreeItemProperties> list) {
        EditConnectionGroupController editConnectionGroupController = this;
        synchronized (editConnectionGroupController) {
            this.editedConnectionGroupDetails = connectionGroup;
            this.connections = new ArrayList<ModifiableConnection>();
            this.connectionFactory.findConnections(connectionGroup, this.connections);
            this.displayConnectionDetails(this.editedConnectionGroupDetails);
            this.updateButtons();
        }
    }

    private void updateButtons() {
        if (this.editedConnectionGroupDetails != null && this.editedConnectionGroupDetails.isModified()) {
            this.saveButton.setDisable(false);
            this.undoButton.setDisable(false);
        } else {
            this.saveButton.setDisable(true);
            this.undoButton.setDisable(true);
        }
    }

    private void displayConnectionDetails(ConfiguredConnectionGroupDetails group) {
        this.connectionGroupNameText.setText(group.getName());
        this.connectionGroupNameText.setDisable(group.getID().equals("default_group"));
        this.connectionList.getItems().clear();
        this.connectionMapping = new HashMap<ConnectionListItemProperties, ModifiableConnection>();
        for (ModifiableConnection connection : this.connections) {
            ConnectionListItemProperties properties = this.connectionFactory.createConnectionListItemProperties(connection);
            this.connectionList.getItems().add((Object)properties);
            this.connectionMapping.put(properties, connection);
        }
    }

    public void setEditConnectionsController(EditConnectionsController editConnectionsController) {
        this.editConnectionsController = editConnectionsController;
    }

    public void setRecordModifications(boolean recordModifications) {
        if (!recordModifications) {
            logger.trace("Modifications suspended...");
            ++this.noModificationsLock;
            this.recordModifications = recordModifications;
        } else {
            --this.noModificationsLock;
            if (this.noModificationsLock == 0) {
                logger.trace("Modifications restored...");
                this.recordModifications = recordModifications;
            }
        }
    }

    public void setConnectionFactory(IConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }
}

