/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.ui.controllers;

import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;
import javafx.util.Callback;
import javafx.util.StringConverter;
import pl.baczkowicz.spy.eventbus.IKBus;
import pl.baczkowicz.spy.ui.charts.ChartSeriesTypeEnum;
import pl.baczkowicz.spy.ui.events.SaveChartSeriesEvent;
import pl.baczkowicz.spy.ui.properties.ChartSeriesProperties;

public class EditChartSeriesController
extends AnchorPane
implements Initializable {
    @FXML
    private TextField topicText;
    @FXML
    private TextField expressionText;
    @FXML
    private ComboBox<ChartSeriesTypeEnum> typeCombo;
    @FXML
    private TextField nameText;
    @FXML
    private Button cancelButton;
    @FXML
    private Button saveButton;
    private IKBus eventBus;
    private ChartSeriesProperties editedProperties;

    public void initialize(URL location, ResourceBundle resources) {
        this.typeCombo.setCellFactory((Callback)new Callback<ListView<ChartSeriesTypeEnum>, ListCell<ChartSeriesTypeEnum>>(){

            public ListCell<ChartSeriesTypeEnum> call(ListView<ChartSeriesTypeEnum> l) {
                return new ListCell<ChartSeriesTypeEnum>(){

                    protected void updateItem(ChartSeriesTypeEnum item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item == null || empty) {
                            this.setText(null);
                        } else {
                            this.setText(item.value());
                        }
                    }
                };
            }
        });
        this.typeCombo.setConverter((StringConverter)new StringConverter<ChartSeriesTypeEnum>(){

            public String toString(ChartSeriesTypeEnum item) {
                if (item == null) {
                    return null;
                }
                return item.value();
            }

            public ChartSeriesTypeEnum fromString(String id) {
                return null;
            }
        });
        this.typeCombo.getItems().addAll((Object[])ChartSeriesTypeEnum.values());
    }

    public void init() {
    }

    @FXML
    private void cancel() {
        Stage stage = (Stage)this.nameText.getScene().getWindow();
        stage.close();
    }

    @FXML
    private void save() {
        if (this.editedProperties == null) {
            ChartSeriesProperties updatedProperties = new ChartSeriesProperties(0, this.nameText.getText(), this.topicText.getText(), (ChartSeriesTypeEnum)((Object)this.typeCombo.getSelectionModel().getSelectedItem()), this.expressionText.getText());
            this.eventBus.publish(new SaveChartSeriesEvent(updatedProperties, true));
        } else {
            this.editedProperties.nameProperty().set(this.nameText.getText());
            this.editedProperties.topicProperty().set(this.topicText.getText());
            this.editedProperties.typeProperty().set(this.typeCombo.getSelectionModel().getSelectedItem());
            this.editedProperties.valueExpressionProperty().set(this.expressionText.getText());
            this.eventBus.publish(new SaveChartSeriesEvent(this.editedProperties, false));
        }
        Stage stage = (Stage)this.nameText.getScene().getWindow();
        stage.close();
    }

    public void setEventBus(IKBus eventBus) {
        this.eventBus = eventBus;
    }

    public void populateValues(ChartSeriesProperties editedProperties) {
        this.editedProperties = editedProperties;
        if (editedProperties == null) {
            this.nameText.setText("");
            this.topicText.setText("");
            this.typeCombo.getSelectionModel().select(0);
            this.expressionText.setText("");
        } else {
            this.nameText.setText(editedProperties.getName());
            this.topicText.setText(editedProperties.getTopic());
            this.typeCombo.getSelectionModel().select(editedProperties.typeProperty().get());
            this.expressionText.setText(editedProperties.valueExpressionProperty().get());
        }
    }
}

