/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.ui.controllers;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TitledPane;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.stage.DirectoryChooser;
import javafx.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.spy.eventbus.IKBus;
import pl.baczkowicz.spy.scripts.ScriptRunningState;
import pl.baczkowicz.spy.scripts.events.ScriptStateChangeEvent;
import pl.baczkowicz.spy.ui.BaseViewManager;
import pl.baczkowicz.spy.ui.panes.PaneVisibilityManager;
import pl.baczkowicz.spy.ui.panes.PaneVisibilityStatus;
import pl.baczkowicz.spy.ui.panes.TitledPaneController;
import pl.baczkowicz.spy.ui.properties.PublicationScriptProperties;
import pl.baczkowicz.spy.ui.scripts.InteractiveBaseScriptManagerInterface;
import pl.baczkowicz.spy.ui.scripts.ScriptTypeEnum;
import pl.baczkowicz.spy.ui.threading.SimpleRunLaterExecutor;
import pl.baczkowicz.spy.ui.utils.DialogFactory;
import pl.baczkowicz.spy.ui.utils.UiUtils;

public abstract class BasePublicationScriptsController
implements Initializable,
TitledPaneController {
    private static final Logger logger = LoggerFactory.getLogger(BasePublicationScriptsController.class);
    @FXML
    protected TableView<PublicationScriptProperties> scriptTable;
    @FXML
    private TableColumn<PublicationScriptProperties, String> nameColumn;
    @FXML
    private TableColumn<PublicationScriptProperties, ScriptTypeEnum> typeColumn;
    @FXML
    private TableColumn<PublicationScriptProperties, Boolean> repeatColumn;
    @FXML
    private TableColumn<PublicationScriptProperties, ScriptRunningState> runningStatusColumn;
    @FXML
    private TableColumn<PublicationScriptProperties, String> lastPublishedColumn;
    @FXML
    private TableColumn<PublicationScriptProperties, Long> messageCountColumn;
    protected InteractiveBaseScriptManagerInterface scriptManager;
    protected IKBus eventBus;
    private Map<ScriptTypeEnum, ContextMenu> contextMenus = new HashMap<ScriptTypeEnum, ContextMenu>();
    private TitledPane pane;
    private AnchorPane paneTitle;
    private MenuButton settingsButton;
    private PaneVisibilityManager paneVisibilityManager;
    private Label titleLabel;
    protected String publicationScriptsDirectory;
    protected boolean includeSubdirectories;

    public void initialize(URL location, ResourceBundle resources) {
        this.nameColumn.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        this.typeColumn.setCellValueFactory((Callback)new PropertyValueFactory("type"));
        this.typeColumn.setCellFactory((Callback)new Callback<TableColumn<PublicationScriptProperties, ScriptTypeEnum>, TableCell<PublicationScriptProperties, ScriptTypeEnum>>(){

            public TableCell<PublicationScriptProperties, ScriptTypeEnum> call(TableColumn<PublicationScriptProperties, ScriptTypeEnum> param) {
                TableCell<PublicationScriptProperties, ScriptTypeEnum> cell = new TableCell<PublicationScriptProperties, ScriptTypeEnum>(){

                    public void updateItem(ScriptTypeEnum item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (!this.isEmpty()) {
                            this.setText(item.toString());
                        } else {
                            this.setText(null);
                            this.setGraphic(null);
                        }
                    }
                };
                cell.setAlignment(Pos.TOP_CENTER);
                return cell;
            }
        });
        this.repeatColumn.setCellValueFactory((Callback)new PropertyValueFactory("repeat"));
        this.repeatColumn.setCellFactory((Callback)new Callback<TableColumn<PublicationScriptProperties, Boolean>, TableCell<PublicationScriptProperties, Boolean>>(){

            public TableCell<PublicationScriptProperties, Boolean> call(TableColumn<PublicationScriptProperties, Boolean> param) {
                CheckBoxTableCell<PublicationScriptProperties, Boolean> cell = new CheckBoxTableCell<PublicationScriptProperties, Boolean>(){

                    public void updateItem(Boolean checked, boolean empty) {
                        super.updateItem((Object)checked, empty);
                        if (!this.isEmpty() && checked != null && this.getTableRow() != null && this.getTableRow().getItem() != null) {
                            PublicationScriptProperties item = (PublicationScriptProperties)this.getTableRow().getItem();
                            if (!ScriptTypeEnum.SUBSCRIPTION.equals(item.typeProperty().getValue())) {
                                this.setDisable(false);
                                if (logger.isTraceEnabled()) {
                                    logger.trace("Setting repeat for {} to {}", (Object)item.getScript().getName(), (Object)checked);
                                }
                                item.setRepeat(checked);
                            } else {
                                this.setDisable(true);
                            }
                        }
                    }
                };
                cell.setAlignment(Pos.TOP_CENTER);
                return cell;
            }
        });
        this.messageCountColumn.setCellValueFactory((Callback)new PropertyValueFactory("count"));
        this.messageCountColumn.setCellFactory((Callback)new Callback<TableColumn<PublicationScriptProperties, Long>, TableCell<PublicationScriptProperties, Long>>(){

            public TableCell<PublicationScriptProperties, Long> call(TableColumn<PublicationScriptProperties, Long> param) {
                TableCell<PublicationScriptProperties, Long> cell = new TableCell<PublicationScriptProperties, Long>(){

                    public void updateItem(Long item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (!this.isEmpty()) {
                            this.setText(item.toString());
                        } else {
                            this.setText(null);
                        }
                    }
                };
                cell.setAlignment(Pos.TOP_CENTER);
                return cell;
            }
        });
        this.runningStatusColumn.setCellValueFactory((Callback)new PropertyValueFactory("status"));
        this.runningStatusColumn.setCellFactory((Callback)new Callback<TableColumn<PublicationScriptProperties, ScriptRunningState>, TableCell<PublicationScriptProperties, ScriptRunningState>>(){

            public TableCell<PublicationScriptProperties, ScriptRunningState> call(TableColumn<PublicationScriptProperties, ScriptRunningState> param) {
                TableCell<PublicationScriptProperties, ScriptRunningState> cell = new TableCell<PublicationScriptProperties, ScriptRunningState>(){

                    public void updateItem(ScriptRunningState item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (!this.isEmpty()) {
                            this.setText(item.toString());
                        } else {
                            this.setText(null);
                            this.setGraphic(null);
                        }
                    }
                };
                cell.setAlignment(Pos.TOP_CENTER);
                return cell;
            }
        });
        this.lastPublishedColumn.setCellValueFactory((Callback)new PropertyValueFactory("lastPublished"));
        this.lastPublishedColumn.setCellFactory((Callback)new Callback<TableColumn<PublicationScriptProperties, String>, TableCell<PublicationScriptProperties, String>>(){

            public TableCell<PublicationScriptProperties, String> call(TableColumn<PublicationScriptProperties, String> param) {
                TableCell<PublicationScriptProperties, String> cell = new TableCell<PublicationScriptProperties, String>(){

                    public void updateItem(String item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (!this.isEmpty()) {
                            this.setText(item.toString());
                        } else {
                            this.setText(null);
                        }
                    }
                };
                cell.setAlignment(Pos.TOP_CENTER);
                return cell;
            }
        });
        this.scriptTable.setRowFactory((Callback)new Callback<TableView<PublicationScriptProperties>, TableRow<PublicationScriptProperties>>(){

            public TableRow<PublicationScriptProperties> call(TableView<PublicationScriptProperties> tableView) {
                TableRow<PublicationScriptProperties> row = new TableRow<PublicationScriptProperties>(){

                    protected void updateItem(PublicationScriptProperties item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (!this.isEmpty() && item != null) {
                            ContextMenu rowMenu = (ContextMenu)BasePublicationScriptsController.this.contextMenus.get(item.typeProperty().getValue());
                            this.setContextMenu(rowMenu);
                        }
                    }
                };
                row.setOnMouseClicked(arg_0 -> this.lambda$call$0((TableRow)row, arg_0));
                return row;
            }

            private /* synthetic */ void lambda$call$0(TableRow row, MouseEvent event) {
                if (event.getClickCount() == 2 && !row.isEmpty()) {
                    BasePublicationScriptsController.this.startScript();
                }
            }
        });
        this.scriptTable.setPlaceholder((Node)new Label("No scripts found - edit your connection settings or use the context menu to set script directory."));
    }

    public void init() {
        this.titleLabel = new Label(this.pane.getText());
        this.includeSubdirectories = true;
        this.eventBus.subscribe(this, this::onScriptStateChange, ScriptStateChangeEvent.class, new SimpleRunLaterExecutor());
        this.contextMenus.put(ScriptTypeEnum.PUBLICATION, this.createDirectoryTypeScriptTableContextMenu(ScriptTypeEnum.PUBLICATION));
        this.contextMenus.put(ScriptTypeEnum.BACKGROUND, this.createDirectoryTypeScriptTableContextMenu(ScriptTypeEnum.BACKGROUND));
        this.contextMenus.put(ScriptTypeEnum.SUBSCRIPTION, this.createDirectoryTypeScriptTableContextMenu(ScriptTypeEnum.SUBSCRIPTION));
        this.scriptTable.setContextMenu(this.createScriptTableContextMenu());
        this.paneTitle = new AnchorPane();
        this.settingsButton = BaseViewManager.createTitleButtons(this, this.paneTitle, this.paneVisibilityManager);
        this.scriptTable.getSortOrder().clear();
        this.scriptTable.getSortOrder().add(this.nameColumn);
    }

    protected abstract void refreshList();

    public void startScript(PublicationScriptProperties item) {
        this.scriptManager.runScript(item.getScript(), true);
    }

    public void stopScript(File file) {
        this.scriptManager.stopScriptFile(file);
    }

    private void startScript() {
        PublicationScriptProperties item = (PublicationScriptProperties)this.scriptTable.getSelectionModel().getSelectedItem();
        if (item != null && (((ScriptTypeEnum)((Object)item.typeProperty().getValue())).equals((Object)ScriptTypeEnum.BACKGROUND) || ((ScriptTypeEnum)((Object)item.typeProperty().getValue())).equals((Object)ScriptTypeEnum.PUBLICATION))) {
            this.startScript(item);
        }
    }

    private ContextMenu createScriptTableContextMenu() {
        return new ContextMenu(new MenuItem[]{this.createSetScriptDirectoryMenuItem(), this.createIncludeSubdirectoriesMenuItem(), new SeparatorMenuItem(), this.createRefreshListMenuItem()});
    }

    public ContextMenu createDirectoryTypeScriptTableContextMenu(ScriptTypeEnum type) {
        ContextMenu contextMenu = new ContextMenu();
        if (ScriptTypeEnum.PUBLICATION.equals((Object)type) || ScriptTypeEnum.BACKGROUND.equals((Object)type)) {
            MenuItem startScriptItem = new MenuItem("Start");
            startScriptItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent e) {
                    BasePublicationScriptsController.this.startScript();
                }
            });
            contextMenu.getItems().add((Object)startScriptItem);
            MenuItem stopScriptItem = new MenuItem("Stop");
            stopScriptItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent e) {
                    PublicationScriptProperties item = (PublicationScriptProperties)BasePublicationScriptsController.this.scriptTable.getSelectionModel().getSelectedItem();
                    if (item != null) {
                        BasePublicationScriptsController.this.stopScript(item.getScript().getScriptFile());
                    }
                }
            });
            contextMenu.getItems().add((Object)stopScriptItem);
            contextMenu.getItems().add((Object)new SeparatorMenuItem());
        }
        MenuItem copyScriptLocationItem = new MenuItem("Copy script location to clipboard");
        copyScriptLocationItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                PublicationScriptProperties item = (PublicationScriptProperties)BasePublicationScriptsController.this.scriptTable.getSelectionModel().getSelectedItem();
                if (item != null) {
                    UiUtils.copyToClipboard(item.getScript().getScriptFile().getAbsolutePath());
                }
            }
        });
        contextMenu.getItems().add((Object)copyScriptLocationItem);
        contextMenu.getItems().add((Object)new SeparatorMenuItem());
        if (type.equals((Object)ScriptTypeEnum.PUBLICATION)) {
            Menu deleteItem = new Menu("Delete");
            contextMenu.getItems().add((Object)deleteItem);
            MenuItem deleteFromListItem = new MenuItem("Delete from list (until next refresh)");
            deleteFromListItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent e) {
                    PublicationScriptProperties item = (PublicationScriptProperties)BasePublicationScriptsController.this.scriptTable.getSelectionModel().getSelectedItem();
                    if (item != null) {
                        BasePublicationScriptsController.this.scriptManager.removeScript(item);
                    }
                }
            });
            deleteItem.getItems().add((Object)deleteFromListItem);
            MenuItem deleteFromDiskItem = new MenuItem("Delete from disk (permanently)");
            deleteFromDiskItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent e) {
                    PublicationScriptProperties item = (PublicationScriptProperties)BasePublicationScriptsController.this.scriptTable.getSelectionModel().getSelectedItem();
                    if (item != null) {
                        BasePublicationScriptsController.this.scriptManager.removeScript(item);
                        if (!item.getScript().getScriptFile().delete()) {
                            DialogFactory.createWarningDialog("File cannot be deleted", "File \"" + item.getScript().getScriptFile().getAbsolutePath() + "\" couln't be deleted. Try doing it manually.");
                        }
                    }
                    BasePublicationScriptsController.this.refreshList();
                }
            });
            deleteItem.getItems().add((Object)deleteFromDiskItem);
            contextMenu.getItems().add((Object)new SeparatorMenuItem());
        }
        contextMenu.getItems().addAll((Object[])new MenuItem[]{this.createSetScriptDirectoryMenuItem(), this.createIncludeSubdirectoriesMenuItem(), new SeparatorMenuItem(), this.createRefreshListMenuItem()});
        return contextMenu;
    }

    private MenuItem createSetScriptDirectoryMenuItem() {
        MenuItem setDirectoryItem = new MenuItem("Set script directory...");
        setDirectoryItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                File initialDirectory = new File(BasePublicationScriptsController.this.publicationScriptsDirectory);
                DirectoryChooser chooser = new DirectoryChooser();
                chooser.setTitle("Select the script directory");
                chooser.setInitialDirectory(initialDirectory);
                File selectedDirectory = chooser.showDialog(BasePublicationScriptsController.this.scriptTable.getScene().getWindow());
                if (selectedDirectory != null) {
                    BasePublicationScriptsController.this.publicationScriptsDirectory = selectedDirectory.getAbsolutePath();
                    BasePublicationScriptsController.this.clearAndRefesh();
                }
            }
        });
        return setDirectoryItem;
    }

    private void clearAndRefesh() {
        this.scriptManager.clear();
        this.scriptTable.getItems().clear();
        this.refreshList();
        this.scriptTable.getSortOrder().clear();
        this.scriptTable.getSortOrder().add(this.nameColumn);
    }

    private MenuItem createIncludeSubdirectoriesMenuItem() {
        CheckMenuItem includeSubdirectoriesItem = new CheckMenuItem("Include subdirectories (recursive)");
        includeSubdirectoriesItem.setSelected(this.includeSubdirectories);
        includeSubdirectoriesItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                BasePublicationScriptsController.this.includeSubdirectories = !BasePublicationScriptsController.this.includeSubdirectories;
                BasePublicationScriptsController.this.clearAndRefesh();
            }
        });
        return includeSubdirectoriesItem;
    }

    private MenuItem createRefreshListMenuItem() {
        MenuItem refreshListItem = new MenuItem("Refresh list");
        refreshListItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                BasePublicationScriptsController.this.refreshList();
            }
        });
        return refreshListItem;
    }

    public void onScriptStateChange(ScriptStateChangeEvent event) {
    }

    @Override
    public TitledPane getTitledPane() {
        return this.pane;
    }

    @Override
    public void setTitledPane(TitledPane pane) {
        this.pane = pane;
    }

    @Override
    public void updatePane(PaneVisibilityStatus status) {
        if (PaneVisibilityStatus.ATTACHED.equals((Object)status)) {
            this.settingsButton.setVisible(true);
        } else {
            this.settingsButton.setVisible(false);
        }
    }

    public void setPaneVisibilityManager(PaneVisibilityManager paneVisibilityManager) {
        this.paneVisibilityManager = paneVisibilityManager;
    }

    public void setEventBus(IKBus eventBus) {
        this.eventBus = eventBus;
    }

    @Override
    public Label getTitleLabel() {
        return this.titleLabel;
    }
}

