/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.ui.controllers;

import java.util.List;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.paint.Color;
import org.fxmisc.richtext.StyleClassedTextArea;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.spy.formatting.FormattingManager;
import pl.baczkowicz.spy.messages.BaseMessage;
import pl.baczkowicz.spy.messages.FormattedMessage;
import pl.baczkowicz.spy.ui.configuration.IConfigurationManager;
import pl.baczkowicz.spy.ui.configuration.UiProperties;
import pl.baczkowicz.spy.ui.controls.StyledTextAreaWrapper;
import pl.baczkowicz.spy.ui.controls.TextAreaInterface;
import pl.baczkowicz.spy.ui.controls.TextAreaWrapper;
import pl.baczkowicz.spy.ui.events.MessageFormatChangeEvent;
import pl.baczkowicz.spy.ui.events.MessageIndexChangeEvent;
import pl.baczkowicz.spy.ui.search.SearchOptions;
import pl.baczkowicz.spy.ui.storage.BasicMessageStoreWithSummary;
import pl.baczkowicz.spy.ui.utils.StylingUtils;
import pl.baczkowicz.spy.utils.TimeUtils;

public abstract class BaseMessageController<T extends FormattedMessage> {
    static final Logger logger = LoggerFactory.getLogger(BaseMessageController.class);
    @FXML
    protected AnchorPane parentPane;
    @FXML
    protected TextArea dataField;
    protected TextAreaInterface dataFieldInteface;
    protected StyleClassedTextArea styledDataField;
    @FXML
    protected TextField topicField;
    @FXML
    protected TextField timeField;
    @FXML
    protected Label dataLabel;
    @FXML
    protected Label lengthLabel;
    protected BasicMessageStoreWithSummary<T> store;
    protected T message;
    protected Tooltip lengthTooltip;
    protected SearchOptions searchOptions;
    protected boolean detailedView;
    protected IConfigurationManager configurationManager;
    protected FormattingManager formattingManager;
    protected boolean styled;
    protected int offset = 0;

    public void init() {
        if (this.styled) {
            this.styledDataField = new StyleClassedTextArea();
            AnchorPane.setBottomAnchor((Node)this.styledDataField, (Double)(AnchorPane.getBottomAnchor((Node)this.dataField) - 1.0));
            AnchorPane.setLeftAnchor((Node)this.styledDataField, (Double)(AnchorPane.getLeftAnchor((Node)this.dataField) - 1.0));
            AnchorPane.setTopAnchor((Node)this.styledDataField, (Double)(AnchorPane.getTopAnchor((Node)this.dataField) - 1.0));
            AnchorPane.setRightAnchor((Node)this.styledDataField, (Double)(AnchorPane.getRightAnchor((Node)this.dataField) - 1.0));
            this.parentPane.getChildren().add((Object)this.styledDataField);
            this.parentPane.getChildren().remove((Object)this.dataField);
            this.dataFieldInteface = new StyledTextAreaWrapper(this.styledDataField);
        } else {
            this.dataFieldInteface = new TextAreaWrapper(this.dataField);
        }
        this.dataFieldInteface.setEditable(false);
        this.dataFieldInteface.setWrapText(true);
        this.dataLabel.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (event.getClickCount() == 2) {
                    BaseMessageController.this.formattingManager.formatMessage((FormattedMessage)BaseMessageController.this.message, BaseMessageController.this.store.getFormatter());
                    String textToDisplay = ((FormattedMessage)BaseMessageController.this.message).getPrettyPayload();
                    BaseMessageController.this.displayNewText(textToDisplay);
                }
            }
        });
        this.lengthTooltip = new Tooltip();
        this.lengthLabel.setTooltip(this.lengthTooltip);
    }

    protected void updateVisibility() {
        if (this.detailedView) {
            AnchorPane.setRightAnchor((Node)this.topicField, null);
            this.topicField.setPrefWidth(100.0);
            AnchorPane.setRightAnchor((Node)this.topicField, (Double)342.0);
        } else {
            AnchorPane.setRightAnchor((Node)this.topicField, (Double)205.0);
        }
        this.lengthLabel.setVisible(this.detailedView);
    }

    public void setMessageIndexOfset(int offset) {
        this.offset = offset;
    }

    public void setViewVisibility(boolean detailedView) {
        this.detailedView = detailedView;
        this.updateVisibility();
    }

    public void toggleDetailedViewVisibility() {
        this.detailedView = !this.detailedView;
        this.updateVisibility();
    }

    public void onMessageIndexChange(MessageIndexChangeEvent event) {
        this.updateMessage(event.getIndex() + this.offset);
    }

    public void onFormatChange(MessageFormatChangeEvent event) {
        this.showMessageData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMessage(int messageIndex) {
        if (messageIndex > 0 && this.store.getMessages().size() > 0) {
            BasicMessageStoreWithSummary<T> basicMessageStoreWithSummary;
            FormattedMessage message = null;
            if (messageIndex == 1) {
                basicMessageStoreWithSummary = this.store;
                synchronized (basicMessageStoreWithSummary) {
                    message = (FormattedMessage)this.store.getMessages().get(0);
                    this.populate(message);
                }
            }
            basicMessageStoreWithSummary = this.store;
            synchronized (basicMessageStoreWithSummary) {
                List messages = this.store.getMessages();
                if (messageIndex <= messages.size()) {
                    message = (FormattedMessage)messages.get(messageIndex - 1);
                    this.populate(message);
                }
            }
            double opacity = 0.02 * (double)((messageIndex - 1) % 2);
            this.parentPane.setStyle("-fx-background-color: " + StylingUtils.createRGBAString(Color.BLACK, opacity));
        } else {
            this.clear();
            this.parentPane.setStyle(null);
        }
    }

    public void populate(T message) {
        if (message != null && !message.equals(this.message)) {
            this.message = message;
            String payload = new String(((BaseMessage)message).getPayload());
            logger.trace("Message payload = " + payload);
            this.topicField.setText(((BaseMessage)message).getTopic());
            this.timeField.setText(TimeUtils.DATE_WITH_MILLISECONDS_SDF.format(((BaseMessage)message).getDate()));
            this.populateLength(((BaseMessage)message).getRawPayload().length);
            this.showMessageData();
        }
    }

    protected void populateLength(long length) {
        BaseMessageController.populatePayloadLength(this.lengthLabel, this.lengthTooltip, length);
    }

    public static void populatePayloadLength(Label lengthLabel, Tooltip lengthTooltip, long length) {
        if (lengthTooltip != null) {
            lengthTooltip.setText("Message length = " + length);
        }
        if (length < 1000L) {
            lengthLabel.setText("(" + length + "B)");
        } else {
            long lengthInKB = length / 1000L;
            if (lengthInKB < 1000L) {
                lengthLabel.setText("(" + lengthInKB + "kB)");
            } else {
                long lengthInMB = lengthInKB / 1000L;
                lengthLabel.setText("(" + lengthInMB + "MB)");
            }
        }
    }

    public void clear() {
        this.message = null;
        this.topicField.setText("");
        this.dataFieldInteface.clear();
        this.timeField.setText("");
        this.lengthLabel.setText("(0)");
    }

    protected void showMessageData() {
        if (this.message != null) {
            String textToDisplay = "";
            if (((BaseMessage)this.message).getRawPayload().length >= UiProperties.getLargeMessageSize(this.configurationManager.getUiPropertyFile())) {
                if (UiProperties.getLargeMessageHide(this.configurationManager.getUiPropertyFile())) {
                    textToDisplay = "[message is too large and has been hidden - double click on 'Data' to display]";
                } else {
                    int max = UiProperties.getLargeMessageSubstring(this.configurationManager.getUiPropertyFile());
                    this.formattingManager.formatMessage((FormattedMessage)this.message, this.store.getFormatter());
                    textToDisplay = ((FormattedMessage)this.message).getPrettyPayload().substring(0, max) + "... [message truncated to " + max + " characters - double click on 'Data' to display]";
                }
            } else {
                this.formattingManager.formatMessage((FormattedMessage)this.message, this.store.getFormatter());
                textToDisplay = ((FormattedMessage)this.message).getPrettyPayload();
            }
            this.displayNewText(textToDisplay);
        }
    }

    private void displayNewText(String textToDisplay) {
        if (!textToDisplay.equals(this.dataFieldInteface.getText())) {
            this.dataFieldInteface.clear();
            this.dataFieldInteface.appendText(textToDisplay);
            this.dataFieldInteface.positionCaret(0);
            if (this.searchOptions != null && this.styled) {
                this.styledDataField.setStyleClass(0, this.dataFieldInteface.getText().length(), "messageText");
                if (this.searchOptions.getSearchValue().length() > 0) {
                    String textToSearch = this.searchOptions.isMatchCase() ? this.dataFieldInteface.getText() : this.dataFieldInteface.getText().toLowerCase();
                    int pos = textToSearch.indexOf(this.searchOptions.getSearchValue());
                    while (pos >= 0) {
                        this.styledDataField.setStyleClass(pos, pos + this.searchOptions.getSearchValue().length(), "messageTextHighlighted");
                        pos = textToSearch.indexOf(this.searchOptions.getSearchValue(), pos + 1);
                    }
                }
            }
        }
    }

    public void setSearchOptions(SearchOptions searchOptions) {
        this.searchOptions = searchOptions;
    }

    public void setConfingurationManager(IConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    public void setFormattingManager(FormattingManager formattingManager) {
        this.formattingManager = formattingManager;
    }

    public void setStore(BasicMessageStoreWithSummary<T> store) {
        this.store = store;
    }

    public void setStyled(boolean styled) {
        this.styled = styled;
    }
}

