/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.ui.controllers;

import java.net.URL;
import java.util.ResourceBundle;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Cursor;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.spy.configuration.PropertyFileLoader;
import pl.baczkowicz.spy.eventbus.IKBus;
import pl.baczkowicz.spy.exceptions.XMLException;
import pl.baczkowicz.spy.ui.controllers.ControlPanelItemController;
import pl.baczkowicz.spy.ui.events.ShowExternalWebPageEvent;
import pl.baczkowicz.spy.ui.events.VersionInfoErrorEvent;
import pl.baczkowicz.spy.ui.events.VersionInfoReceivedEvent;
import pl.baczkowicz.spy.ui.generated.versions.SpyVersions;
import pl.baczkowicz.spy.ui.properties.VersionInfoProperties;
import pl.baczkowicz.spy.ui.threading.SimpleRunLaterExecutor;
import pl.baczkowicz.spy.ui.utils.ImageUtils;
import pl.baczkowicz.spy.ui.versions.VersionManager;
import pl.baczkowicz.spy.utils.ThreadingUtils;

public class AboutController
implements Initializable {
    static final Logger logger = LoggerFactory.getLogger(AboutController.class);
    @FXML
    private Label javaLabel;
    @FXML
    private Label versionLabel;
    @FXML
    private Label projectInfoLabel;
    @FXML
    private Label statusLabel;
    @FXML
    private ImageView logo;
    @FXML
    private ImageView statusIcon;
    @FXML
    private ProgressIndicator progressIndicator;
    private VersionManager versionManager;
    private IKBus eventBus;
    private PropertyFileLoader propertyFileLoader;

    public void initialize(URL location, ResourceBundle resources) {
        String javaVersion = System.getProperty("java.version") + " / " + System.getProperty("java.vendor");
        String osVersion = System.getProperty("os.name") + " / " + System.getProperty("os.version") + " / " + System.getProperty("os.arch");
        this.javaLabel.setText("Java: " + javaVersion + System.getProperty("line.separator") + "OS: " + osVersion);
        this.projectInfoLabel.setOnMouseClicked((EventHandler)new EventHandler<Event>(){

            public void handle(Event event) {
                AboutController.this.openProjectWebsite();
            }
        });
        this.projectInfoLabel.setCursor(Cursor.HAND);
        this.statusLabel.setOnMouseClicked((EventHandler)new EventHandler<Event>(){

            public void handle(Event event) {
                AboutController.this.openProjectWebsite();
            }
        });
        this.statusLabel.setCursor(Cursor.HAND);
        this.logo.setOnMouseClicked((EventHandler)new EventHandler<Event>(){

            public void handle(Event event) {
                AboutController.this.openProjectWebsite();
            }
        });
        this.logo.setCursor(Cursor.HAND);
        this.statusIcon.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (event.getClickCount() == 2) {
                    AboutController.this.reloadVersionInfo();
                }
            }
        });
    }

    public void reloadVersionInfo() {
        this.progressIndicator.setVisible(true);
        this.statusIcon.setVisible(false);
        this.statusLabel.setText("Connecting to the mqtt-spy update server...");
        if (!this.versionManager.isLoading()) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        AboutController.this.versionManager.setLoading(true);
                        ThreadingUtils.sleep(2000L);
                        SpyVersions versions = AboutController.this.versionManager.loadVersions();
                        logger.debug("Retrieved version info = " + versions.toString());
                        AboutController.this.eventBus.publish(new VersionInfoReceivedEvent(versions));
                    }
                    catch (XMLException e) {
                        AboutController.this.eventBus.publish(new VersionInfoErrorEvent(e));
                    }
                }
            }).start();
        }
    }

    public void init() {
        this.eventBus.subscribe(this, this::onVersionInfoReceived, VersionInfoReceivedEvent.class, new SimpleRunLaterExecutor());
        this.eventBus.subscribe(this, this::onVersionInfoError, VersionInfoErrorEvent.class, new SimpleRunLaterExecutor());
        this.versionLabel.setText(this.propertyFileLoader.getFullVersionName());
        this.reloadVersionInfo();
    }

    @FXML
    private void openProjectWebsite() {
        this.eventBus.publish(new ShowExternalWebPageEvent("http://kamilfb.github.io/mqtt-spy/"));
    }

    public void setPropertyFileLoader(PropertyFileLoader propertyFileLoader) {
        this.propertyFileLoader = propertyFileLoader;
    }

    public void setVersionManager(VersionManager versionManager) {
        this.versionManager = versionManager;
    }

    public void onVersionInfoReceived(VersionInfoReceivedEvent event) {
        this.progressIndicator.setVisible(false);
        this.statusIcon.setVisible(true);
        VersionInfoProperties properties = this.versionManager.getVersionInfoProperties(this.propertyFileLoader);
        String imageName = ControlPanelItemController.getStatusIconName(properties.getStatus());
        this.statusIcon.setImage(ImageUtils.createIcon(imageName).getImage());
        this.statusLabel.setText(properties.getTitle() + System.getProperty("line.separator") + properties.getDetails());
    }

    public void onVersionInfoError(VersionInfoErrorEvent event) {
        this.progressIndicator.setVisible(false);
        this.statusIcon.setVisible(true);
        this.statusLabel.setText("Error occurred while getting version info. Please perform manual update.");
    }

    public void setEventBus(IKBus eventBus) {
        this.eventBus = eventBus;
    }
}

