/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.ui.configuration;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.spy.configuration.BaseConfigurationUtils;
import pl.baczkowicz.spy.configuration.PropertyFileLoader;
import pl.baczkowicz.spy.ui.panes.SpyPerspective;

public class UiProperties {
    public static final int DEFAULT_WIDTH = 800;
    public static final int DEFAULT_HEIGHT = 600;
    public static final String WIDTH_PROPERTY = "application.width";
    public static final String HEIGHT_PROPERTY = "application.height";
    public static final String PERSPECTIVE_PROPERTY = "application.perspective";
    public static final String MESSAGE_PANE_RESIZE_PROPERTY = "application.panes.message.resize";
    public static final String MAXIMIZED_PROPERTY = "application.maximized";
    public static final String SUMMARYTABLE_PAYLOAD_MAX = "ui.summarytable.columns.payload.maxlength";
    public static final String BROWSER_LM_SIZE = "ui.messagebrowser.largemessage.size";
    public static final String BROWSER_LM_HIDE = "ui.messagebrowser.largemessage.hide";
    public static final String BROWSER_LM_SUBSTRING = "ui.messagebrowser.largemessage.substring";
    private static final Logger logger = LoggerFactory.getLogger(UiProperties.class);
    private static Integer summaryMaxPayloadLength;
    private static Integer largeMessageSize;
    private static Boolean largeMessageHide;
    private static Integer largeMessageSubstring;

    public static double getApplicationHeight(PropertyFileLoader fileLoader) {
        return BaseConfigurationUtils.getDoubleProperty(HEIGHT_PROPERTY, 600.0, fileLoader);
    }

    public static boolean getApplicationMaximized(PropertyFileLoader fileLoader) {
        return BaseConfigurationUtils.getBooleanProperty(MAXIMIZED_PROPERTY, Boolean.FALSE, fileLoader);
    }

    public static double getApplicationWidth(PropertyFileLoader fileLoader) {
        return BaseConfigurationUtils.getDoubleProperty(WIDTH_PROPERTY, 800.0, fileLoader);
    }

    public static int getSummaryMaxPayloadLength(PropertyFileLoader fileLoader) {
        if (summaryMaxPayloadLength == null) {
            summaryMaxPayloadLength = BaseConfigurationUtils.getIntegerProperty(SUMMARYTABLE_PAYLOAD_MAX, 250, fileLoader);
        }
        return summaryMaxPayloadLength;
    }

    public static int getLargeMessageSize(PropertyFileLoader fileLoader) {
        if (largeMessageSize == null) {
            largeMessageSize = BaseConfigurationUtils.getIntegerProperty(BROWSER_LM_SIZE, 10000, fileLoader);
        }
        return largeMessageSize;
    }

    public static boolean getLargeMessageHide(PropertyFileLoader fileLoader) {
        if (largeMessageHide == null) {
            largeMessageHide = BaseConfigurationUtils.getBooleanProperty(BROWSER_LM_HIDE, Boolean.FALSE, fileLoader);
        }
        return largeMessageHide;
    }

    public static int getLargeMessageSubstring(PropertyFileLoader fileLoader) {
        if (largeMessageSubstring == null) {
            largeMessageSubstring = BaseConfigurationUtils.getIntegerProperty(BROWSER_LM_SUBSTRING, 1000, fileLoader);
        }
        return largeMessageSubstring;
    }

    public static SpyPerspective getApplicationPerspective(PropertyFileLoader fileLoader) {
        String value = fileLoader.getProperty(PERSPECTIVE_PROPERTY);
        try {
            return SpyPerspective.valueOf(value);
        }
        catch (IllegalArgumentException e) {
            logger.error("Invalid format " + value);
            return SpyPerspective.DEFAULT;
        }
    }

    public static boolean getResizeMessagePane(PropertyFileLoader fileLoader) {
        return BaseConfigurationUtils.getBooleanProperty(MESSAGE_PANE_RESIZE_PROPERTY, Boolean.TRUE, fileLoader);
    }
}

