/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.ui.configuration;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.spy.common.generated.ConnectionDetails;
import pl.baczkowicz.spy.common.generated.ConnectionGroup;
import pl.baczkowicz.spy.common.generated.ConnectionGroupReference;
import pl.baczkowicz.spy.common.generated.ConnectionReference;
import pl.baczkowicz.spy.configuration.PropertyFileLoader;
import pl.baczkowicz.spy.exceptions.ConfigurationException;
import pl.baczkowicz.spy.exceptions.XMLException;
import pl.baczkowicz.spy.ui.configuration.ConfiguredConnectionGroupDetails;
import pl.baczkowicz.spy.ui.configuration.IConfigurationManager;
import pl.baczkowicz.spy.ui.panes.SpyPerspective;
import pl.baczkowicz.spy.ui.properties.ModifiableConnection;
import pl.baczkowicz.spy.ui.utils.DialogFactory;
import pl.baczkowicz.spy.utils.ThreadingUtils;
import pl.baczkowicz.spy.utils.TimeUtils;
import pl.baczkowicz.spy.xml.XMLParser;

public abstract class BaseConfigurationManager
implements IConfigurationManager {
    public static final String SPY_COMMON_SCHEMA = "/spy-common.xsd";
    private static final Logger logger = LoggerFactory.getLogger(BaseConfigurationManager.class);
    private List<ConfiguredConnectionGroupDetails> connectionGroups = new ArrayList<ConfiguredConnectionGroupDetails>();
    private ConfiguredConnectionGroupDetails rootGroup;
    private File loadedConfigurationFile;
    private Exception lastException;
    public static String APPLICATION_NAME = "mqtt-spy";
    private PropertyFileLoader defaultPropertyFile;
    private PropertyFileLoader uiPropertyFile;

    protected void loadDefaultPropertyFile() throws ConfigurationException {
        this.defaultPropertyFile = new PropertyFileLoader();
        this.defaultPropertyFile.readFromClassPath(BaseConfigurationManager.getDefaultPropertyFileLocation());
    }

    public Object loadConfiguration(XMLParser parser, File file) {
        try {
            this.clear();
            Object configuration = parser.loadFromFile(file);
            this.setLoadedConfigurationFile(file);
            return configuration;
        }
        catch (XMLException e) {
            this.setLastException(e);
            DialogFactory.createErrorDialog("Invalid configuration file", "Cannot process the given configuration file. See the log file for more details.");
            logger.error("Cannot process the configuration file at " + file.getAbsolutePath(), e);
        }
        catch (FileNotFoundException e) {
            this.setLastException(e);
            DialogFactory.createErrorDialog("Invalid configuration file", "Cannot read the given configuration file. See the log file for more details.");
            logger.error("Cannot read the configuration file from " + file.getAbsolutePath(), e);
        }
        return null;
    }

    public void createConnectionGroups(List<ConnectionGroup> configuredGroups, List<ModifiableConnection> configuredConnections) {
        ArrayList<ConnectionGroup> groupsWithoutParent = new ArrayList<ConnectionGroup>(configuredGroups);
        this.getConnectionGrops().clear();
        this.setRootGroup(null);
        for (ConnectionGroup group : configuredGroups) {
            ConfiguredConnectionGroupDetails details = new ConfiguredConnectionGroupDetails(group, false);
            for (ConnectionGroupReference subgroup : group.getSubgroups()) {
                groupsWithoutParent.remove(subgroup.getReference());
            }
            this.getConnectionGrops().add(details);
        }
        if (this.getConnectionGrops().isEmpty() || groupsWithoutParent.isEmpty()) {
            logger.debug("Creating root group called 'All connections'");
            this.setRootGroup(new ConfiguredConnectionGroupDetails(new ConnectionGroup("default_group", "All connections", new ArrayList<ConnectionGroupReference>(), new ArrayList<ConnectionReference>()), false));
            this.getConnectionGrops().add(this.getRootGroup());
            for (ModifiableConnection connection : configuredConnections) {
                connection.setGroup(new ConnectionGroupReference(this.getRootGroup()));
                this.getRootGroup().getConnections().add(new ConnectionReference(connection));
            }
            this.getRootGroup().apply();
        } else {
            String rootId = ((ConnectionGroup)groupsWithoutParent.get(0)).getID();
            for (ConfiguredConnectionGroupDetails group : this.getConnectionGrops()) {
                if (!group.getID().equals(rootId)) continue;
                this.setRootGroup(group);
                break;
            }
            this.updateTree(this.getRootGroup());
        }
    }

    private void updateTree(ConfiguredConnectionGroupDetails parentGroup) {
        ArrayList<ConnectionGroupReference> subgroups = new ArrayList<ConnectionGroupReference>(parentGroup.getSubgroups());
        parentGroup.getSubgroups().clear();
        for (ConnectionGroupReference reference : subgroups) {
            ConnectionGroup group = (ConnectionGroup)reference.getReference();
            ConfiguredConnectionGroupDetails groupDetails = this.findMatchingGroup(group);
            parentGroup.getSubgroups().add(new ConnectionGroupReference(groupDetails));
            groupDetails.setGroup(new ConnectionGroupReference(parentGroup));
            groupDetails.apply();
            this.updateTree(groupDetails);
        }
        ArrayList<ConnectionReference> connections = new ArrayList<ConnectionReference>(parentGroup.getConnections());
        parentGroup.getConnections().clear();
        for (ConnectionReference reference : connections) {
            ConnectionDetails connection = (ConnectionDetails)reference.getReference();
            ModifiableConnection connectionDetails = BaseConfigurationManager.findMatchingConnection(connection, new ArrayList<ModifiableConnection>(this.getConnections()));
            if (connectionDetails != null) {
                parentGroup.getConnections().add(new ConnectionReference(connectionDetails));
                connectionDetails.setGroup(new ConnectionGroupReference(parentGroup));
                connectionDetails.apply();
                continue;
            }
            logger.warn("Match not found for connection {}", (Object)connection.getName());
        }
        parentGroup.apply();
    }

    public static ModifiableConnection findMatchingConnection(ConnectionDetails connection, List<ModifiableConnection> connections) {
        for (ModifiableConnection connectionDetails : connections) {
            if (!connection.getID().equals(connectionDetails.getID())) continue;
            return connectionDetails;
        }
        return null;
    }

    @Override
    public List<ConfiguredConnectionGroupDetails> getOrderedGroups() {
        ArrayList<ModifiableConnection> orderedConnections = new ArrayList<ModifiableConnection>();
        ArrayList<ConfiguredConnectionGroupDetails> orderedGroups = new ArrayList<ConfiguredConnectionGroupDetails>();
        orderedGroups.add(this.getRootGroup());
        this.sortConnections(this.getRootGroup(), orderedGroups, orderedConnections);
        return orderedGroups;
    }

    public List<ModifiableConnection> getOrderedConnections() {
        ArrayList<ModifiableConnection> orderedConnections = new ArrayList<ModifiableConnection>();
        ArrayList<ConfiguredConnectionGroupDetails> orderedGroups = new ArrayList<ConfiguredConnectionGroupDetails>();
        this.sortConnections(this.getRootGroup(), orderedGroups, orderedConnections);
        return orderedConnections;
    }

    private void sortConnections(ConfiguredConnectionGroupDetails parentGroup, List<ConfiguredConnectionGroupDetails> orderedGroups, List<ModifiableConnection> orderedConnections) {
        for (ConnectionGroupReference connectionGroupReference : parentGroup.getSubgroups()) {
            ConfiguredConnectionGroupDetails group = (ConfiguredConnectionGroupDetails)connectionGroupReference.getReference();
            orderedGroups.add(group);
            this.sortConnections(group, orderedGroups, orderedConnections);
        }
        for (ConnectionReference connectionReference : parentGroup.getConnections()) {
            ModifiableConnection connection = (ModifiableConnection)connectionReference.getReference();
            orderedConnections.add(connection);
        }
    }

    public List<ModifiableConnection> getConnections(ConfiguredConnectionGroupDetails group) {
        ArrayList<ModifiableConnection> orderedConnections = new ArrayList<ModifiableConnection>();
        for (ConnectionReference connetionRef : group.getConnections()) {
            orderedConnections.add((ModifiableConnection)connetionRef.getReference());
        }
        return orderedConnections;
    }

    protected abstract void clear();

    protected void loadUiPropertyFile() throws ConfigurationException {
        if (!BaseConfigurationManager.getUiPropertyFileObject().exists()) {
            logger.info("Creating UI property file");
            BaseConfigurationManager.createUiPropertyFileFromClassPath();
        }
        this.uiPropertyFile = new PropertyFileLoader();
        this.uiPropertyFile.readFromFileSystem(BaseConfigurationManager.getUiPropertyFileObject());
    }

    public static String getDefaultHomeDirectory() {
        String filePathSeparator = System.getProperty("file.separator");
        String userHomeDirectory = System.getProperty("user.home");
        if (!userHomeDirectory.endsWith(filePathSeparator)) {
            userHomeDirectory = userHomeDirectory + filePathSeparator;
        }
        return userHomeDirectory + APPLICATION_NAME + filePathSeparator;
    }

    public static String getDefaultPropertyFileLocation() {
        return "/" + APPLICATION_NAME + ".properties";
    }

    public static String getUiPropertyFileLocation() {
        return "/" + APPLICATION_NAME + "-ui.properties";
    }

    public static String getDefaultConfigurationFileName() {
        return APPLICATION_NAME + "-configuration.xml";
    }

    public static File getDefaultConfigurationFileObject() {
        return new File(BaseConfigurationManager.getDefaultHomeDirectory() + BaseConfigurationManager.getDefaultConfigurationFileName());
    }

    @Override
    public PropertyFileLoader getDefaultPropertyFile() {
        return this.defaultPropertyFile;
    }

    @Override
    public PropertyFileLoader getUiPropertyFile() {
        return this.uiPropertyFile;
    }

    public static File getUiPropertyFileObject() {
        return new File(BaseConfigurationManager.getDefaultHomeDirectory() + BaseConfigurationManager.getUiPropertyFileLocation());
    }

    public static boolean createUiPropertyFileFromClassPath() {
        String origin = "/samples" + BaseConfigurationManager.getUiPropertyFileLocation();
        try {
            return BaseConfigurationManager.copyFileFromClassPath(BaseConfigurationManager.class.getResourceAsStream(origin), BaseConfigurationManager.getUiPropertyFileObject());
        }
        catch (IOException | IllegalArgumentException e) {
            logger.error("Cannot copy file from {}", (Object)origin, (Object)e);
            return false;
        }
    }

    public static File getDefaultHomeDirectoryFileObject() {
        return new File(BaseConfigurationManager.getDefaultHomeDirectory());
    }

    public static boolean copyFileFromClassPath(InputStream orig, File dest) throws IOException {
        BaseConfigurationManager.getDefaultHomeDirectoryFileObject().mkdirs();
        BaseConfigurationManager.streamToFile(orig, dest);
        return true;
    }

    public static void streamToFile(InputStream input, File output) throws IOException {
        try (FileOutputStream out = new FileOutputStream(output);){
            IOUtils.copy(input, (OutputStream)out);
        }
    }

    @Override
    public String generateConnectionGroupId() {
        ThreadingUtils.sleep(1L);
        return "cg" + TimeUtils.getMonotonicTime();
    }

    public static String generateConnectionId() {
        ThreadingUtils.sleep(1L);
        return "conn" + TimeUtils.getMonotonicTime();
    }

    @Override
    public List<ConfiguredConnectionGroupDetails> getConnectionGrops() {
        return this.connectionGroups;
    }

    @Override
    public ConfiguredConnectionGroupDetails getRootGroup() {
        return this.rootGroup;
    }

    public void setRootGroup(ConfiguredConnectionGroupDetails value) {
        this.rootGroup = value;
    }

    protected ConfiguredConnectionGroupDetails findMatchingGroup(ConnectionGroup group) {
        for (ConfiguredConnectionGroupDetails groupDetails : this.connectionGroups) {
            if (!group.getID().equals(groupDetails.getID())) continue;
            return groupDetails;
        }
        return null;
    }

    public Exception getLastException() {
        return this.lastException;
    }

    public void setLastException(Exception lastException) {
        this.lastException = lastException;
    }

    @Override
    public File getLoadedConfigurationFile() {
        return this.loadedConfigurationFile;
    }

    public void setLoadedConfigurationFile(File file) {
        this.loadedConfigurationFile = file;
    }

    @Override
    public boolean isConfigurationWritable() {
        return this.loadedConfigurationFile != null && this.loadedConfigurationFile.canWrite();
    }

    @Override
    public boolean isConfigurationReadOnly() {
        return this.loadedConfigurationFile != null && !this.loadedConfigurationFile.canWrite();
    }

    public void updateUiProperty(String propertyName, String propertyValue) {
        this.getUiPropertyFile().setProperty(propertyName, propertyValue);
    }

    public static boolean createDefaultConfigFromFile(File orig) {
        try {
            File dest = BaseConfigurationManager.getDefaultConfigurationFileObject();
            dest.mkdirs();
            Files.copy(orig.toPath(), dest.toPath(), StandardCopyOption.REPLACE_EXISTING);
            return true;
        }
        catch (IOException e) {
            logger.error("Cannot copy configuration file", e);
            return false;
        }
    }

    public static boolean createDefaultConfigFromClassPath(String name) {
        String origin = "/samples/" + name + "-" + APPLICATION_NAME + "-configuration.xml";
        try {
            return BaseConfigurationManager.copyFileFromClassPath(BaseConfigurationManager.class.getResourceAsStream(origin), BaseConfigurationManager.getDefaultConfigurationFileObject());
        }
        catch (IOException | IllegalArgumentException e) {
            logger.error("Cannot copy configuration file from {}", (Object)origin, (Object)e);
            return false;
        }
    }

    @Override
    public void saveUiProperties(double width, double height, boolean maximized, SpyPerspective selectedPerspective, boolean resizeMessagePane) {
        this.updateUiProperty("application.width", String.valueOf(width));
        this.updateUiProperty("application.height", String.valueOf(height));
        this.updateUiProperty("application.maximized", String.valueOf(maximized));
        this.updateUiProperty("application.perspective", selectedPerspective.toString());
        this.updateUiProperty("application.panes.message.resize", String.valueOf(resizeMessagePane));
        try {
            this.getUiPropertyFile().saveToFileSystem(APPLICATION_NAME + "-ui", BaseConfigurationManager.getUiPropertyFileObject());
        }
        catch (IOException e) {
            logger.error("Cannot save UI properties", e);
        }
    }
}

