/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.ui;

import java.io.File;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.text.TextAlignment;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.spy.configuration.BaseConfigurationUtils;
import pl.baczkowicz.spy.eventbus.IKBus;
import pl.baczkowicz.spy.scripts.BaseScriptManagerInterface;
import pl.baczkowicz.spy.ui.configuration.BaseConfigurationManager;
import pl.baczkowicz.spy.ui.configuration.IConfigurationManager;
import pl.baczkowicz.spy.ui.connections.IConnectionFactory;
import pl.baczkowicz.spy.ui.controllers.AboutController;
import pl.baczkowicz.spy.ui.controllers.EditChartSeriesController;
import pl.baczkowicz.spy.ui.controllers.EditConnectionsController;
import pl.baczkowicz.spy.ui.controllers.FormattersController;
import pl.baczkowicz.spy.ui.controllers.TestCasesExecutionController;
import pl.baczkowicz.spy.ui.events.ConnectionStatusChangeEvent;
import pl.baczkowicz.spy.ui.events.ConnectionsChangedEvent;
import pl.baczkowicz.spy.ui.events.LoadConfigurationFileEvent;
import pl.baczkowicz.spy.ui.events.ShowAboutWindowEvent;
import pl.baczkowicz.spy.ui.events.ShowEditChartSeriesWindowEvent;
import pl.baczkowicz.spy.ui.events.ShowEditConnectionsWindowEvent;
import pl.baczkowicz.spy.ui.events.ShowExternalWebPageEvent;
import pl.baczkowicz.spy.ui.events.ShowFormattersWindowEvent;
import pl.baczkowicz.spy.ui.events.ShowTestCasesWindowEvent;
import pl.baczkowicz.spy.ui.panes.PaneVisibilityManager;
import pl.baczkowicz.spy.ui.panes.PaneVisibilityStatus;
import pl.baczkowicz.spy.ui.panes.SpyPerspective;
import pl.baczkowicz.spy.ui.panes.TitledPaneController;
import pl.baczkowicz.spy.ui.stats.StatisticsManager;
import pl.baczkowicz.spy.ui.utils.FxmlUtils;
import pl.baczkowicz.spy.ui.utils.ImageUtils;
import pl.baczkowicz.spy.ui.versions.VersionManager;

public abstract class BaseViewManager {
    private static final Logger logger = LoggerFactory.getLogger(BaseViewManager.class);
    public static final KeyCombination newSubscription = new KeyCodeCombination(KeyCode.S, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN, KeyCombination.SHIFT_DOWN});
    public static final KeyCombination newPublication = new KeyCodeCombination(KeyCode.P, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN, KeyCombination.SHIFT_DOWN});
    public static int TITLE_MARGIN = 13;
    protected IConfigurationManager configurationManager;
    protected VersionManager versionManager;
    protected Application application;
    protected IKBus eventBus;
    protected IConnectionFactory connectionFactory;
    protected ObservableList<String> stylesheets;
    protected StatisticsManager statisticsManager;
    protected SpyPerspective selectedPerspective = SpyPerspective.DEFAULT;
    protected Stage aboutStage;
    protected Stage formattersStage;
    protected Stage testCasesStage;
    protected Stage editConnectionsStage;
    protected AboutController aboutController;
    protected EditConnectionsController editConnectionsController;
    protected Stage chartSeriesStage;
    protected EditChartSeriesController editChartSeriesController;
    private BaseScriptManagerInterface genericScriptManager;

    public void init() {
        this.eventBus.subscribe(this, this::showAbout, ShowAboutWindowEvent.class);
        this.eventBus.subscribe(this, this::showFormatters, ShowFormattersWindowEvent.class);
        this.eventBus.subscribe(this, this::showTestCases, ShowTestCasesWindowEvent.class);
        this.eventBus.subscribe(this, this::showEditConnectionsWindow, ShowEditConnectionsWindowEvent.class);
        this.eventBus.subscribe(this, this::showEditChartSeries, ShowEditChartSeriesWindowEvent.class);
        this.eventBus.subscribe(this, this::showExternalWebPage, ShowExternalWebPageEvent.class);
        TITLE_MARGIN = BaseConfigurationUtils.getIntegerProperty("ui.titlepane.margin", TITLE_MARGIN, this.configurationManager.getUiPropertyFile());
        logger.trace("Property TITLE_MARGIN = {}", (Object)TITLE_MARGIN);
    }

    private void initialiseAboutWindow(Window parentWindow) {
        FXMLLoader loader = FxmlUtils.createFxmlLoaderForProjectFile("AboutWindow.fxml");
        AnchorPane window = FxmlUtils.loadAnchorPane(loader);
        this.aboutController = (AboutController)loader.getController();
        this.aboutController.setVersionManager(this.versionManager);
        this.aboutController.setEventBus(this.eventBus);
        this.aboutController.setPropertyFileLoader(this.configurationManager.getDefaultPropertyFile());
        this.aboutController.init();
        Scene scene = new Scene((Parent)window);
        scene.getStylesheets().addAll(this.stylesheets);
        this.aboutStage = new Stage();
        this.aboutStage.setTitle("About mqtt-spy");
        this.aboutStage.initModality(Modality.WINDOW_MODAL);
        this.aboutStage.initOwner(parentWindow);
        this.aboutStage.setScene(scene);
    }

    private void initialiseEditChartSeriesWindow(Window parentWindow) {
        FXMLLoader loader = FxmlUtils.createFxmlLoaderForProjectFile("EditChartSeries.fxml");
        AnchorPane editChartSeriesWindow = FxmlUtils.loadAnchorPane(loader);
        this.editChartSeriesController = (EditChartSeriesController)((Object)loader.getController());
        this.editChartSeriesController.setEventBus(this.eventBus);
        Scene scene = new Scene((Parent)editChartSeriesWindow);
        scene.getStylesheets().addAll(this.stylesheets);
        this.chartSeriesStage = new Stage();
        this.chartSeriesStage.setTitle("Chart series editor");
        this.chartSeriesStage.initOwner(parentWindow);
        this.chartSeriesStage.setScene(scene);
        ((EditChartSeriesController)((Object)loader.getController())).init();
    }

    private void initialiseTestCasesWindow(Window parentWindow) {
        FXMLLoader loader = FxmlUtils.createFxmlLoaderForProjectFile("TestCasesExecutionPane.fxml");
        AnchorPane testCasesWindow = FxmlUtils.loadAnchorPane(loader);
        Scene scene = new Scene((Parent)testCasesWindow);
        scene.getStylesheets().addAll(this.stylesheets);
        this.testCasesStage = new Stage();
        this.testCasesStage.setTitle("Test cases");
        this.testCasesStage.initOwner(parentWindow);
        this.testCasesStage.setScene(scene);
        ((TestCasesExecutionController)loader.getController()).init();
    }

    private void initialiseFormattersWindow(Window parentWindow) {
        FXMLLoader loader = FxmlUtils.createFxmlLoaderForProjectFile("FormattersWindow.fxml");
        AnchorPane formattersWindow = FxmlUtils.loadAnchorPane(loader);
        FormattersController formattersController = (FormattersController)loader.getController();
        formattersController.setConfigurationManager(this.configurationManager);
        formattersController.setScriptManager(this.genericScriptManager);
        formattersController.setEventBus(this.eventBus);
        formattersController.init();
        Scene scene = new Scene((Parent)formattersWindow);
        scene.getStylesheets().addAll(this.stylesheets);
        this.formattersStage = new Stage();
        this.formattersStage.setTitle("Formatters");
        this.formattersStage.initModality(Modality.WINDOW_MODAL);
        this.formattersStage.initOwner(parentWindow);
        this.formattersStage.setScene(scene);
    }

    protected void initialiseEditConnectionsWindow(Window parentWindow) {
        if (this.editConnectionsController != null) {
            this.eventBus.unsubscribeConsumer((Object)this.editConnectionsController, ConnectionStatusChangeEvent.class);
        }
        FXMLLoader loader = FxmlUtils.createFxmlLoaderForProjectFile("EditConnectionsWindow.fxml");
        AnchorPane connectionWindow = FxmlUtils.loadAnchorPane(loader);
        this.editConnectionsController = (EditConnectionsController)loader.getController();
        this.editConnectionsController.setEventBus(this.eventBus);
        this.editConnectionsController.setConnectionFactory(this.connectionFactory);
        this.editConnectionsController.setConfigurationManager(this.configurationManager);
        this.editConnectionsController.init();
        Scene scene = new Scene((Parent)connectionWindow);
        scene.getStylesheets().addAll(this.stylesheets);
        this.editConnectionsStage = new Stage();
        this.editConnectionsStage.setTitle("Connection list");
        this.editConnectionsStage.initModality(Modality.WINDOW_MODAL);
        this.editConnectionsStage.initOwner(parentWindow);
        this.editConnectionsStage.setMinWidth(950.0);
        this.editConnectionsStage.setScene(scene);
    }

    public void showAbout(ShowAboutWindowEvent event) {
        if (this.aboutStage == null) {
            this.initialiseAboutWindow(event.getParent());
        }
        this.aboutController.reloadVersionInfo();
        this.aboutStage.show();
    }

    public void showEditChartSeries(ShowEditChartSeriesWindowEvent event) {
        if (this.chartSeriesStage == null) {
            this.initialiseEditChartSeriesWindow(event.getParent());
        }
        this.editChartSeriesController.populateValues(event.getEditedProperties());
        this.chartSeriesStage.show();
    }

    public void showFormatters(ShowFormattersWindowEvent event) {
        if (this.formattersStage == null || !event.getParent().equals(this.formattersStage.getScene().getWindow())) {
            this.initialiseFormattersWindow(event.getParent());
        }
        if (event.isShowAndWait()) {
            this.formattersStage.initOwner(event.getParent());
            this.formattersStage.showAndWait();
        } else {
            this.formattersStage.show();
        }
    }

    public void showTestCases(ShowTestCasesWindowEvent event) {
        if (this.testCasesStage == null) {
            this.initialiseTestCasesWindow(event.getParent());
        }
        this.testCasesStage.show();
    }

    public void showEditConnectionsWindow(ShowEditConnectionsWindowEvent event) {
        logger.debug("showEditConnectionsWindow()");
        if (this.editConnectionsController == null) {
            this.initialiseEditConnectionsWindow(event.getParent());
        }
        if (event.isCreateNew()) {
            this.editConnectionsController.newConnection("MQTT");
        }
        if (event.getConnectionProperties() != null) {
            this.editConnectionsController.selectConnection(event.getConnectionProperties());
        }
        this.editConnectionsController.updateUIForSelectedItem();
        this.editConnectionsController.setPerspective(this.selectedPerspective);
        this.editConnectionsStage.showAndWait();
        this.eventBus.publish(new ConnectionsChangedEvent());
    }

    public static boolean getDetailedViewStatus(SpyPerspective perspective) {
        switch (perspective) {
            case BASIC: {
                return false;
            }
            case DETAILED: {
                return true;
            }
            case SPY: {
                return false;
            }
            case SUPER_SPY: {
                return true;
            }
        }
        return false;
    }

    public static boolean getBasicViewStatus(SpyPerspective perspective) {
        switch (perspective) {
            case BASIC: {
                return true;
            }
            case DETAILED: {
                return false;
            }
            case SPY: {
                return false;
            }
            case SUPER_SPY: {
                return false;
            }
        }
        return false;
    }

    public void loadDefaultConfigurationFile() {
        File defaultConfigurationFile = BaseConfigurationManager.getDefaultConfigurationFileObject();
        logger.info("Default configuration file present (" + defaultConfigurationFile.getAbsolutePath() + ") = " + defaultConfigurationFile.exists());
        if (defaultConfigurationFile.exists()) {
            this.eventBus.publish(new LoadConfigurationFileEvent(defaultConfigurationFile));
        } else {
            this.configurationManager.initialiseConfiguration();
        }
    }

    public void showExternalWebPage(ShowExternalWebPageEvent event) {
        this.application.getHostServices().showDocument(event.getWebpage());
    }

    public static ChangeListener<Number> createPaneTitleWidthListener(final TitledPane pane, final AnchorPane paneTitle) {
        return new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        BaseViewManager.updateTitleWidth(pane, paneTitle, TITLE_MARGIN, null);
                    }
                });
            }
        };
    }

    public static MenuButton createTitleButton(String title, String iconLocation, double offset, final PaneVisibilityManager paneVisibilityManager, final TitledPane pane) {
        MenuButton button = new MenuButton();
        button.setId("pane-settings-button");
        button.setTooltip(new Tooltip(title));
        button.setPadding(Insets.EMPTY);
        button.setLineSpacing(0.0);
        button.setBorder(null);
        button.setGraphicTextGap(0.0);
        button.setFocusTraversable(false);
        button.setGraphic((Node)ImageUtils.createIcon(iconLocation, 14));
        button.setStyle("-fx-background-color: transparent;");
        MenuItem detach = new MenuItem("Detach to a separate window", (Node)ImageUtils.createIcon("tab-detach", 14, "pane-settings-menu-graphic"));
        detach.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                paneVisibilityManager.setPaneVisiblity(paneVisibilityManager.getPaneToStatusMapping().get(pane), PaneVisibilityStatus.DETACHED);
            }
        });
        MenuItem hide = new MenuItem("Hide this pane", (Node)ImageUtils.createIcon("tab-close", 14, "pane-settings-menu-graphic"));
        hide.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                paneVisibilityManager.setPaneVisiblity(paneVisibilityManager.getPaneToStatusMapping().get(pane), PaneVisibilityStatus.NOT_VISIBLE);
            }
        });
        button.getItems().add((Object)detach);
        button.getItems().add((Object)hide);
        for (MenuItem item : button.getItems()) {
            item.getStyleClass().add((Object)"pane-settings-menu-item");
        }
        button.setTextAlignment(TextAlignment.RIGHT);
        button.setAlignment(Pos.CENTER_RIGHT);
        AnchorPane.setRightAnchor((Node)button, (Double)offset);
        return button;
    }

    public static MenuButton createTitleButtons(TitledPaneController controller, AnchorPane paneTitle, PaneVisibilityManager paneVisibilityManager) {
        TitledPane pane = controller.getTitledPane();
        MenuButton settingsButton = BaseViewManager.createTitleButton("Pane settings", "settings", -5.0, paneVisibilityManager, pane);
        HBox titleBox = new HBox();
        titleBox.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
        logger.trace(pane + ", " + paneTitle + ", " + paneVisibilityManager);
        titleBox.getChildren().addAll((Object[])new Node[]{controller.getTitleLabel()});
        titleBox.prefWidth(Double.MAX_VALUE);
        paneTitle.setPadding(new Insets(0.0, 0.0, 0.0, 0.0));
        paneTitle.getChildren().addAll((Object[])new Node[]{titleBox, settingsButton});
        paneTitle.setMaxWidth(Double.MAX_VALUE);
        pane.setText(null);
        pane.setGraphic((Node)paneTitle);
        pane.widthProperty().addListener(BaseViewManager.createPaneTitleWidthListener(pane, paneTitle));
        return settingsButton;
    }

    public static double updateTitleWidth(TitledPane titledPane, AnchorPane paneTitle, double margin, Double target) {
        double marginWithPositionOfset = margin + paneTitle.getLayoutX();
        double titledPaneWidth = titledPane.getWidth();
        if (titledPane.getScene() != null && titledPane.getScene().getWidth() < titledPaneWidth) {
            titledPaneWidth = titledPane.getScene().getWidth();
            logger.debug("Scene is smaller; {} titledPane.getScene().getWidth() = {}", (Object)titledPane, (Object)titledPaneWidth);
        }
        double jump = 0.0;
        double newWidth = titledPaneWidth - marginWithPositionOfset;
        if (target != null && paneTitle.getWidth() - newWidth < 30.0 && paneTitle.getWidth() - newWidth > 0.0) {
            jump = target;
        }
        BaseViewManager.updatePaneTitleWidth(paneTitle, newWidth - jump);
        return titledPaneWidth;
    }

    private static void updatePaneTitleWidth(AnchorPane paneTitle, double width) {
        logger.debug("Setting title pane width to {}", (Object)width);
        paneTitle.setPrefWidth(width);
        paneTitle.setMaxWidth(width);
    }

    public void setConfigurationManager(IConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    public void setEventBus(IKBus eventBus) {
        this.eventBus = eventBus;
    }

    public void setVersionManager(VersionManager versionManager) {
        this.versionManager = versionManager;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public void setConnectionFactory(IConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public void setGenericScriptManager(BaseScriptManagerInterface genericBaseScriptManager) {
        this.genericScriptManager = genericBaseScriptManager;
    }

    public void setStatisticsManager(StatisticsManager statisticsManager) {
        this.statisticsManager = statisticsManager;
    }

    public SpyPerspective getPerspective() {
        return this.selectedPerspective;
    }
}

