/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.storage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageList<T> {
    static final Logger logger = LoggerFactory.getLogger(MessageList.class);
    public static final int DEFAULT_MAX_SIZE = 5000;
    public static final int DEFAULT_MIN_MESSAGES_PER_TOPIC = 10;
    private final List<T> messages;
    private final int maxSize;
    private final String name;
    private final int preferredSize;

    public MessageList(int preferredSize, int maxSize, String name) {
        this.name = name;
        this.preferredSize = preferredSize;
        this.maxSize = maxSize;
        this.messages = Collections.synchronizedList(new ArrayList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<T> list = this.messages;
        synchronized (list) {
            this.messages.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T add(T message) {
        T removed = null;
        List<T> list = this.messages;
        synchronized (list) {
            if (this.isMaxSize()) {
                removed = this.messages.remove(this.messages.size() - 1);
            }
            this.messages.add(0, message);
            if (logger.isTraceEnabled() && !this.name.contains("stats")) {
                logger.trace("[{}] Store update = {}/{}/{}/{}", this.name, this.messages.size(), this.preferredSize, this.maxSize, this);
            }
            return removed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T remove(int index) {
        T removed = null;
        List<T> list = this.messages;
        synchronized (list) {
            removed = this.messages.remove(index);
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMaxSize() {
        List<T> list = this.messages;
        synchronized (list) {
            return this.messages.size() >= this.maxSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exceedingPreferredSize() {
        List<T> list = this.messages;
        synchronized (list) {
            return this.messages.size() > this.preferredSize;
        }
    }

    public List<T> getMessages() {
        return this.messages;
    }

    public int getPreferredSize() {
        return this.preferredSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public String getName() {
        return this.name;
    }
}

