/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.storage;

import java.util.List;
import pl.baczkowicz.spy.common.generated.ConversionMethod;
import pl.baczkowicz.spy.common.generated.FormatterDetails;
import pl.baczkowicz.spy.formatting.FormattingUtils;
import pl.baczkowicz.spy.storage.MessageList;
import pl.baczkowicz.spy.storage.MessageStore;

public class BasicMessageStore<T>
implements MessageStore<T> {
    private MessageList<T> messageList;
    protected FormatterDetails messageFormat = FormattingUtils.createBasicFormatter("default", "Plain", null, ConversionMethod.PLAIN);

    public BasicMessageStore(MessageList<T> messageList) {
        this.setMessageList(messageList);
    }

    public void setMessageList(MessageList<T> messageList) {
        this.messageList = messageList;
    }

    public void messageReceived(T message) {
        this.storeMessage(message);
    }

    public T storeMessage(T message) {
        if (message != null) {
            return this.messageList.add(message);
        }
        return null;
    }

    @Override
    public List<T> getMessages() {
        return this.messageList.getMessages();
    }

    public MessageList<T> getMessageList() {
        return this.messageList;
    }

    public void clear() {
        this.messageList.clear();
    }

    public void setFormatter(FormatterDetails messageFormat) {
        this.messageFormat = messageFormat;
    }

    public FormatterDetails getFormatter() {
        return this.messageFormat;
    }

    @Override
    public boolean browsingFiltersEnabled() {
        return false;
    }

    @Override
    public boolean messageFiltersEnabled() {
        return false;
    }

    public String getName() {
        return this.messageList.getName();
    }

    public void cleanUp() {
        this.clear();
    }
}

