/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.security;

import java.security.SecureRandom;
import java.security.Security;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import pl.baczkowicz.spy.exceptions.SpyException;
import pl.baczkowicz.spy.security.SecureSocketUtils;

public class SecureSocketFactoryBuilder {
    public static SSLSocketFactory getSocketFactory(String protocolVersion) throws SpyException {
        return SecureSocketFactoryBuilder.getSocketFactory(protocolVersion, null, null, null);
    }

    public static SSLSocketFactory getSocketFactory(String protocolVersion, String caCertificateFile) throws SpyException {
        try {
            Security.addProvider(new BouncyCastleProvider());
            TrustManager[] tm = SecureSocketUtils.getTrustManagerFactory(caCertificateFile).getTrustManagers();
            return SecureSocketFactoryBuilder.getSocketFactory(protocolVersion, null, tm, null);
        }
        catch (Exception e) {
            throw new SpyException("Cannot create TLS/SSL connection", e);
        }
    }

    public static SSLSocketFactory getSocketFactory(String protocolVersion, String caKeyStoreFile, String caKeyStorePassword) throws SpyException {
        try {
            Security.addProvider(new BouncyCastleProvider());
            TrustManager[] tm = SecureSocketUtils.getTrustManagerFactory(caKeyStoreFile, caKeyStorePassword, SecureSocketUtils.getTypeFromFilename(caKeyStoreFile)).getTrustManagers();
            return SecureSocketFactoryBuilder.getSocketFactory(protocolVersion, null, tm, null);
        }
        catch (Exception e) {
            throw new SpyException("Cannot create TLS/SSL connection", e);
        }
    }

    public static SSLSocketFactory getSocketFactory(String protocolVersion, String serverCrtFile, String clientCrtFile, String clientKeyFile, String clientKeyPassword, boolean pemFormat) throws SpyException {
        try {
            Security.addProvider(new BouncyCastleProvider());
            KeyManager[] km = SecureSocketUtils.getKeyManagerFactory(clientCrtFile, clientKeyFile, clientKeyPassword, pemFormat).getKeyManagers();
            TrustManager[] tm = SecureSocketUtils.getTrustManagerFactory(serverCrtFile).getTrustManagers();
            return SecureSocketFactoryBuilder.getSocketFactory(protocolVersion, km, tm, null);
        }
        catch (Exception e) {
            throw new SpyException("Cannot create TLS/SSL connection", e);
        }
    }

    public static SSLSocketFactory getSocketFactory(String protocolVersion, String caKeyStoreFile, String caKeyStorePassword, String clientKeyStoreFile, String clientKeyStorePassword, String clientKeyPassword) throws SpyException {
        try {
            Security.addProvider(new BouncyCastleProvider());
            KeyManager[] km = SecureSocketUtils.getKeyManagerFactory(clientKeyStoreFile, clientKeyStorePassword, clientKeyPassword, SecureSocketUtils.getTypeFromFilename(clientKeyStoreFile)).getKeyManagers();
            TrustManager[] tm = SecureSocketUtils.getTrustManagerFactory(caKeyStoreFile, caKeyStorePassword, SecureSocketUtils.getTypeFromFilename(caKeyStoreFile)).getTrustManagers();
            return SecureSocketFactoryBuilder.getSocketFactory(protocolVersion, km, tm, null);
        }
        catch (Exception e) {
            throw new SpyException("Cannot create TLS/SSL connection", e);
        }
    }

    private static SSLSocketFactory getSocketFactory(String protocolVersion, KeyManager[] km, TrustManager[] tm, SecureRandom random) throws SpyException {
        try {
            Security.addProvider(new BouncyCastleProvider());
            SSLContext context = SSLContext.getInstance(protocolVersion);
            context.init(km, tm, random);
            return context.getSocketFactory();
        }
        catch (Exception e) {
            throw new SpyException("Cannot create TLS/SSL connection", e);
        }
    }
}

