/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.scripts;

import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.Executor;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.spy.eventbus.IKBus;
import pl.baczkowicz.spy.files.FileUtils;
import pl.baczkowicz.spy.scripts.Script;
import pl.baczkowicz.spy.scripts.ScriptHealthDetector;
import pl.baczkowicz.spy.scripts.ScriptRunningState;
import pl.baczkowicz.spy.scripts.events.ScriptStateChangeEvent;
import pl.baczkowicz.spy.utils.ThreadingUtils;

public class ScriptRunner
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(ScriptRunner.class);
    private final Script script;
    private IKBus eventBus;
    private Executor executor;
    private Thread runningThread;
    private Object lastReturnValue;
    private Exception lastThrownException;

    public ScriptRunner(IKBus eventBus, Script script, Executor executor) {
        this.script = script;
        this.eventBus = eventBus;
        this.executor = executor;
    }

    @Override
    public void run() {
        if (this.script.isAsynchronous()) {
            ThreadingUtils.logThreadStarting("Script " + this.script.getName());
        }
        this.script.touch();
        this.runningThread = Thread.currentThread();
        boolean firstRun = true;
        while (firstRun || this.script.isRepeat() && !ScriptRunningState.STOPPED.equals((Object)this.script.getStatus())) {
            logger.debug("Running [{}] script: first run = {}, repeat = {}, state = {}", new Object[]{this.script.getName(), firstRun, this.script.isRepeat(), this.script.getStatus()});
            firstRun = false;
            this.changeState(ScriptRunningState.RUNNING);
            if (this.script.isAsynchronous()) {
                new Thread(new ScriptHealthDetector(this.eventBus, this.script, this.executor)).start();
            }
            try {
                this.runScript();
            }
            catch (Exception e) {
                this.changeState(ScriptRunningState.FAILED);
                this.setLastThrownException(e);
                logger.error("Script execution exception", e);
                break;
            }
            if (!this.script.isRepeat()) continue;
            logger.debug("Re-running script {}", (Object)this.script.getName());
        }
        this.script.stop();
        if (this.script.isAsynchronous()) {
            ThreadingUtils.logThreadEnding();
        }
    }

    private void runScript() throws ScriptException, IOException {
        this.lastReturnValue = null;
        this.setLastThrownException(null);
        if (this.script.getScriptFile() != null) {
            this.lastReturnValue = this.script.getScriptEngine().eval(new InputStreamReader(FileUtils.loadFileByName(this.script.getScriptFile().getAbsolutePath())));
            logger.debug("Script {} returned with value {}", (Object)this.script.getName(), this.lastReturnValue);
        } else if (this.script.getScriptContent() != null) {
            this.lastReturnValue = this.script.getScriptEngine().eval(this.script.getScriptContent());
            logger.debug("Inline script {} returned with value {}", (Object)this.script.getName(), this.lastReturnValue);
        } else {
            logger.warn("No script content defined for script {}", (Object)this.script.getName());
        }
        if (this.lastReturnValue == null) {
            this.changeState(ScriptRunningState.FINISHED);
        } else if (this.lastReturnValue instanceof Boolean) {
            if (((Boolean)this.lastReturnValue).booleanValue()) {
                this.changeState(ScriptRunningState.FINISHED);
            } else {
                this.changeState(ScriptRunningState.STOPPED);
            }
        } else {
            this.changeState(ScriptRunningState.FINISHED);
        }
    }

    public Object getLastReturnValue() {
        return this.lastReturnValue;
    }

    private void changeState(ScriptRunningState newState) {
        ScriptRunner.changeState(this.eventBus, this.script.getName(), newState, this.script, this.executor);
    }

    public static void changeState(final IKBus eventBus, final String scriptName, final ScriptRunningState newState, final Script script, Executor executor) {
        logger.trace("Changing [{}] script's state to [{}]", (Object)scriptName, (Object)newState);
        script.setStatus(newState);
        if (eventBus != null && executor != null) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    script.nofityChange();
                    eventBus.publish(new ScriptStateChangeEvent(scriptName, newState));
                    logger.trace("Notified [{}] script's state to [{}]", (Object)scriptName, (Object)newState);
                }
            });
        } else {
            script.nofityChange();
            logger.trace("Notified [{}] script's state to [{}]", (Object)scriptName, (Object)newState);
        }
    }

    public Thread getThread() {
        return this.runningThread;
    }

    public Exception getLastThrownException() {
        return this.lastThrownException;
    }

    public void setLastThrownException(Exception lastThrownException) {
        this.lastThrownException = lastThrownException;
    }
}

