/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.scripts;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.concurrent.Executor;
import javax.script.Bindings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.spy.scripts.IScriptIO;
import pl.baczkowicz.spy.scripts.Script;

public class ScriptIO
implements IScriptIO {
    private static final Logger logger = LoggerFactory.getLogger(ScriptIO.class);
    protected Script script;
    protected int publishedMessages;
    protected Executor executor;
    protected String scriptName = "n/a";

    public ScriptIO(Script script, Executor executor) {
        this.script = script;
        this.executor = executor;
        if (script != null) {
            this.scriptName = script.getName();
        }
    }

    @Override
    public void touch() {
        if (this.script != null) {
            this.script.touch();
        }
    }

    @Override
    public void setScriptTimeout(long customTimeout) {
        this.script.setScriptTimeout(customTimeout);
        logger.debug("Timeout for script {} changed to {}", (Object)this.scriptName, (Object)customTimeout);
    }

    @Override
    @Deprecated
    public boolean instantiate(String className) {
        try {
            Bindings bindings = this.script.getScriptEngine().getBindings(100);
            bindings.put(className.replace(".", "_"), Class.forName(className).newInstance());
            this.script.getScriptEngine().setBindings(bindings, 100);
            return true;
        }
        catch (Exception e) {
            logger.error("Cannot instantiate class " + className, e);
            return false;
        }
    }

    @Override
    public String execute(String command) throws IOException, InterruptedException {
        Runtime rt = Runtime.getRuntime();
        Process p = rt.exec(command);
        p.waitFor();
        BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
        String line = null;
        try {
            StringBuffer sb = new StringBuffer();
            while ((line = input.readLine()) != null) {
                sb.append(line);
            }
            return sb.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void updatePublished() {
        ++this.publishedMessages;
        if (this.executor != null) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    ScriptIO.this.script.setLastPublished(new Date());
                    ScriptIO.this.script.setMessagesPublished(ScriptIO.this.publishedMessages);
                }
            });
        } else if (this.script != null) {
            this.script.setLastPublished(new Date());
            this.script.setMessagesPublished(this.publishedMessages);
        }
    }
}

