/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.scripts;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Executor;
import javax.script.ScriptEngine;
import pl.baczkowicz.spy.eventbus.IKBus;
import pl.baczkowicz.spy.scripts.BaseScriptManager;
import pl.baczkowicz.spy.scripts.BasicScriptProperties;
import pl.baczkowicz.spy.scripts.ScriptChangeObserver;
import pl.baczkowicz.spy.scripts.ScriptRunner;
import pl.baczkowicz.spy.scripts.ScriptRunningState;
import pl.baczkowicz.spy.utils.TimeUtils;
import pl.baczkowicz.spy.utils.tasks.StoppableTask;

public class Script
extends BasicScriptProperties {
    private ScriptRunningState status;
    private long messagesPublished;
    private Date lastPublished;
    private File scriptFile;
    private String scriptContent;
    private ScriptEngine scriptEngine;
    private ScriptRunner scriptRunner;
    private ScriptChangeObserver observer;
    private long lastTouch;
    private List<StoppableTask> backgroundTasks = new ArrayList<StoppableTask>();
    private boolean asynchronous;
    private String rootDirectory;

    public String getNameWithSubdirectory() {
        if (this.rootDirectory != null) {
            return BaseScriptManager.getScriptNameWithSubdirectory(this.getScriptFile(), this.rootDirectory);
        }
        return this.getName();
    }

    public void stop() {
        for (StoppableTask task : this.backgroundTasks) {
            task.stop();
        }
    }

    public void touch() {
        this.lastTouch = TimeUtils.getMonotonicTime();
    }

    public long getLastTouch() {
        return this.lastTouch;
    }

    public void createScriptRunner(IKBus eventBus, Executor executor) {
        if (this.scriptRunner == null) {
            this.scriptRunner = new ScriptRunner(eventBus, this, executor);
        }
    }

    public void nofityChange() {
        if (this.observer != null) {
            this.observer.onChange();
        }
    }

    public void addTask(StoppableTask task) {
        this.backgroundTasks.add(task);
    }

    public void setMessagesPublished(long messageCount) {
        this.messagesPublished = messageCount;
        this.nofityChange();
    }

    public void setLastPublished(Date lastPublishedDate) {
        this.lastPublished = lastPublishedDate;
        this.nofityChange();
    }

    public void setStatus(ScriptRunningState status) {
        this.status = status;
    }

    public void setStatusAndNotify(ScriptRunningState status) {
        this.setStatus(status);
        this.nofityChange();
    }

    public Date getLastPublishedDate() {
        return this.lastPublished;
    }

    public long getMessagesPublished() {
        return this.messagesPublished;
    }

    public File getScriptFile() {
        return this.scriptFile;
    }

    public ScriptEngine getScriptEngine() {
        return this.scriptEngine;
    }

    public ScriptRunningState getStatus() {
        return this.status;
    }

    public void setScriptEngine(ScriptEngine scriptEngine) {
        this.scriptEngine = scriptEngine;
    }

    public void setScriptFile(File scriptFile) {
        this.scriptFile = scriptFile;
    }

    public ScriptRunner getScriptRunner() {
        return this.scriptRunner;
    }

    public String getScriptContent() {
        return this.scriptContent;
    }

    public void setScriptContent(String scriptContent) {
        this.scriptContent = scriptContent;
    }

    public static String getScriptIdFromFile(File file) {
        return file.getAbsolutePath();
    }

    public String getScriptId() {
        if (this.scriptFile == null) {
            return null;
        }
        return Script.getScriptIdFromFile(this.scriptFile);
    }

    public void setObserver(ScriptChangeObserver observer) {
        this.observer = observer;
    }

    public void setAsynchronous(boolean asynchronous) {
        this.asynchronous = asynchronous;
    }

    public boolean isAsynchronous() {
        return this.asynchronous;
    }

    public void setRootDirectory(String rootDirectory) {
        this.rootDirectory = rootDirectory;
    }
}

