/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.formatting;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.spy.common.generated.FormatterDetails;
import pl.baczkowicz.spy.common.generated.FormatterFunction;
import pl.baczkowicz.spy.common.generated.ScriptExecutionDetails;
import pl.baczkowicz.spy.files.FileUtils;
import pl.baczkowicz.spy.formatting.FormattingUtils;
import pl.baczkowicz.spy.formatting.ScriptBasedFormatter;
import pl.baczkowicz.spy.messages.FormattedMessage;
import pl.baczkowicz.spy.scripts.BaseScriptManagerInterface;

public class FormattingManager {
    static final Logger logger = LoggerFactory.getLogger(FormattingManager.class);
    private ScriptBasedFormatter scriptFormatter;

    public FormattingManager(BaseScriptManagerInterface scriptManager) {
        this.scriptFormatter = new ScriptBasedFormatter(scriptManager);
    }

    public void initialiseFormatter(FormatterDetails formatter) {
        if (formatter == null) {
            return;
        }
        try {
            this.scriptFormatter.addFormatter(formatter);
        }
        catch (ScriptException e) {
            logger.error("Couldn't load the formatter");
        }
    }

    public void formatMessage(FormattedMessage message, FormatterDetails formatter) {
        if (formatter == null) {
            message.setFormattedPayload(message.getPayload());
        } else if (!formatter.equals(message.getLastUsedFormatter())) {
            message.setLastUsedFormatter(formatter);
            if (FormattingUtils.isScriptBased(formatter)) {
                message.setFormattedPayload(this.scriptFormatter.formatMessage(formatter, message));
                message.setPrettyPayload(this.scriptFormatter.formatMessage(formatter, message, true));
            } else {
                message.setFormattedPayload(FormattingUtils.checkAndFormatText(formatter, message.getRawPayload()));
                message.setPrettyPayload(message.getFormattedPayload());
            }
        }
    }

    public static List<FormatterDetails> createDefaultScriptFormatters() {
        ArrayList<FormatterDetails> defaultScriptFormatters = new ArrayList<FormatterDetails>();
        try {
            String prettyJsonScript = FileUtils.loadFileByNameBase64Encoded("/formatters/prettyJson.js");
            FormatterDetails prettyJson = new FormatterDetails("Pretty JSON", "defaultscript-pretty-json", "Takes a JSON string and does pretty formatting with indentation.", Arrays.asList(new FormatterFunction(null, null, null, null, null, new ScriptExecutionDetails(prettyJsonScript))));
            defaultScriptFormatters.add(prettyJson);
            String prettyXmlScript = FileUtils.loadFileByNameBase64Encoded("/formatters/prettyXml.js");
            FormatterDetails prettyXml = new FormatterDetails("Pretty XML", "defaultscript-pretty-xml", "Takes an XML string and does pretty formatting with indentation.", Arrays.asList(new FormatterFunction(null, null, null, null, null, new ScriptExecutionDetails(prettyXmlScript))));
            defaultScriptFormatters.add(prettyXml);
            String kuraScript = FileUtils.loadFileByNameBase64Encoded("/formatters/eclipseKura.js");
            FormatterDetails kura = new FormatterDetails("Eclipse Kura", "defaultscript-eclipse-kura", "Decodes the Eclipse Kura Protocol Buffer format and converts it to pretty JSON.", Arrays.asList(new FormatterFunction(null, null, null, null, null, new ScriptExecutionDetails(kuraScript))));
            defaultScriptFormatters.add(kura);
        }
        catch (IOException e) {
            logger.error("Cannot read file", e);
        }
        return defaultScriptFormatters;
    }
}

