/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.files;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.spy.exceptions.SpyException;
import pl.baczkowicz.spy.utils.ConversionUtils;

public class FileUtils {
    private static final Logger logger = LoggerFactory.getLogger(FileUtils.class);

    public static List<File> getDirectoriesWithFile(String directory, String fileToFind) {
        ArrayList<File> files = new ArrayList<File>();
        File folder = new File(directory);
        File[] listOfFiles = folder.listFiles();
        if (listOfFiles != null) {
            for (int i = 0; i < listOfFiles.length; ++i) {
                if (listOfFiles[i].isDirectory()) {
                    files.addAll(FileUtils.getDirectoriesWithFile(listOfFiles[i].getAbsolutePath(), fileToFind));
                    continue;
                }
                if (!listOfFiles[i].getName().matches(fileToFind)) continue;
                files.add(listOfFiles[i]);
            }
        }
        return files;
    }

    public static List<File> getFileNamesForDirectory(String directory, boolean recursive, String extension) {
        ArrayList<File> files = new ArrayList<File>();
        File folder = new File(directory);
        File[] listOfFiles = folder.listFiles();
        if (listOfFiles != null) {
            for (int i = 0; i < listOfFiles.length; ++i) {
                if (listOfFiles[i].isFile()) {
                    if (extension != null && !extension.isEmpty() && !listOfFiles[i].getName().endsWith(extension)) continue;
                    files.add(listOfFiles[i]);
                    continue;
                }
                if (!recursive) continue;
                files.addAll(FileUtils.getFileNamesForDirectory(listOfFiles[i].getAbsolutePath(), recursive, extension));
            }
        }
        if (files.isEmpty()) {
            logger.error("No files in {}", (Object)directory);
        }
        return files;
    }

    public static List<File> getFileNamesForDirectory(String directory, String extension) {
        return FileUtils.getFileNamesForDirectory(directory, false, extension);
    }

    public static void writeToFile(File file, String value) {
        try {
            PrintWriter out = new PrintWriter(file);
            out.write(value);
            out.close();
        }
        catch (FileNotFoundException e) {
            logger.error("Cannot write to file", e);
        }
    }

    public static void writeToFile(File file, byte[] value) {
        try {
            Files.write(Paths.get(file.toURI()), value, new OpenOption[0]);
        }
        catch (IOException e) {
            logger.error("Cannot write to file", e);
        }
    }

    public static InputStream loadFileByName(String filename) throws IOException {
        File file = new File(filename);
        if (file.isFile()) {
            logger.debug("Trying to read {} from filesystem", (Object)filename);
            return new FileInputStream(file);
        }
        logger.debug("Trying to read {} from classpath", (Object)filename);
        URL url = FileUtils.class.getResource(filename);
        if (url != null) {
            return url.openStream();
        }
        logger.debug("File {} not found on classpath", (Object)filename);
        return null;
    }

    public static String loadFileByNameAsString(String filename) throws IOException {
        InputStream is = FileUtils.loadFileByName(filename);
        if (is != null) {
            return IOUtils.toString(is);
        }
        return null;
    }

    public static String loadFileByNameBase64Encoded(String filename) throws IOException {
        String fileContent = FileUtils.loadFileByNameAsString(filename);
        if (fileContent != null) {
            return ConversionUtils.stringToBase64(fileContent);
        }
        return null;
    }

    public static List<String> readFileAsLines(File selectedFile) throws SpyException {
        try {
            String str;
            BufferedReader in = new BufferedReader(new FileReader(selectedFile));
            ArrayList<String> list = new ArrayList<String>();
            while ((str = in.readLine()) != null) {
                list.add(str);
            }
            in.close();
            return list;
        }
        catch (IOException e) {
            throw new SpyException("Can't open the file at " + selectedFile.getAbsolutePath(), e);
        }
    }

    public static long countLines(File selectedFile) throws SpyException {
        try {
            long count = 0L;
            BufferedReader in = new BufferedReader(new FileReader(selectedFile));
            while (in.readLine() != null) {
                ++count;
            }
            in.close();
            return count;
        }
        catch (IOException e) {
            throw new SpyException("Can't open the file at " + selectedFile.getAbsolutePath(), e);
        }
    }
}

