/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.eventbus;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.spy.eventbus.IFilterableEvent;
import pl.baczkowicz.spy.eventbus.IKBus;

public class KBus
implements IKBus {
    private static final Logger logger = LoggerFactory.getLogger(KBus.class);
    private final Map<Object, Set<Consumer<?>>> subscribers = new HashMap();
    private final Map<Consumer<?>, Object> consumerFilters = new HashMap();
    private final Map<Consumer<?>, Class<?>> consumerTypes = new HashMap();
    private final Map<Class<?>, Collection<Consumer<?>>> typeConsumers = new HashMap();
    private final Map<Consumer<?>, Executor> consumerExecutors = new HashMap();

    private Collection<Consumer<?>> getConsumersForType(Object event) {
        Collection<Consumer<?>> matchedConsumers;
        Collection<Consumer<?>> previouslyMatchedConsumers = this.typeConsumers.get(event.getClass());
        if (previouslyMatchedConsumers == null) {
            matchedConsumers = this.matchConsumersForType(event.getClass());
            this.typeConsumers.put(event.getClass(), matchedConsumers);
        } else {
            matchedConsumers = previouslyMatchedConsumers;
        }
        return matchedConsumers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<Consumer<?>> matchConsumersForType(Class<?> eventType) {
        ArrayList matchedConsumers = new ArrayList();
        logger.trace("Matching consumers for type {}", (Object)eventType);
        Map<Consumer<?>, Class<?>> map = this.consumerTypes;
        synchronized (map) {
            for (Consumer<?> consumer : this.consumerTypes.keySet()) {
                Class<?> consumerType = this.consumerTypes.get(consumer);
                if (!consumerType.isAssignableFrom(eventType)) continue;
                matchedConsumers.add(consumer);
            }
        }
        logger.trace("Matched {} consumers for type {}: {}", matchedConsumers.size(), eventType, matchedConsumers);
        return matchedConsumers;
    }

    @Override
    public void publish(Object event) {
        Collection<Consumer<?>> matchedConsumers = this.getConsumersForType(event);
        for (Consumer<Object> consumer : matchedConsumers) {
            Object filter = this.consumerFilters.get(consumer);
            try {
                if (filter == null) {
                    this.notifyConsumer(consumer, event);
                    continue;
                }
                if (!(event instanceof IFilterableEvent) || !filter.equals(((IFilterableEvent)event).getFilter())) continue;
                this.notifyConsumer(consumer, event);
            }
            catch (ClassCastException e) {
                logger.warn("Consumer {} can't accept events of type = {}", consumer, event.getClass(), e);
            }
        }
    }

    private void notifyConsumer(Consumer<Object> consumer, Object event) {
        Executor executor = this.consumerExecutors.get(consumer);
        if (executor == null) {
            consumer.accept(event);
        } else {
            executor.execute(() -> consumer.accept(event));
        }
    }

    private void recalculateExistingMappings() {
        for (Class<?> type : this.typeConsumers.keySet()) {
            this.typeConsumers.put(type, this.matchConsumersForType(type));
        }
    }

    @Override
    public <S> void subscribe(Object subscriber, Consumer<? super S> consumer, Class<S> eventType) {
        this.subscribe(subscriber, consumer, eventType, null, null);
    }

    @Override
    public <S> void subscribe(Object subscriber, Consumer<? super S> consumer, Class<S> eventType, Executor executor) {
        this.subscribe(subscriber, consumer, eventType, executor, null);
    }

    @Override
    public <S> void subscribeWithFilterOnly(Object subscriber, Consumer<? super S> consumer, Class<S> eventType, Object filter) {
        this.subscribe(subscriber, consumer, eventType, null, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <S> void subscribe(Object subscriber, Consumer<? super S> consumer, Class<S> eventType, Executor executor, Object filter) {
        Map<Consumer<?>, Class<?>> map = this.consumerTypes;
        synchronized (map) {
            Set<Consumer<?>> consumers = this.subscribers.get(subscriber);
            if (consumers == null) {
                consumers = new HashSet();
                this.subscribers.put(subscriber, consumers);
            }
            consumers.add(consumer);
            this.consumerFilters.put(consumer, filter);
            this.consumerTypes.put(consumer, eventType);
            this.consumerExecutors.put(consumer, executor);
            this.recalculateExistingMappings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unsubscribe(Object subscriber) {
        Map<Consumer<?>, Class<?>> map = this.consumerTypes;
        synchronized (map) {
            logger.trace("Trying to remove {} from subscribers", subscriber);
            Set<Consumer<?>> removed = this.subscribers.remove(subscriber);
            if (removed != null) {
                for (Consumer<?> consumer : removed) {
                    this.consumerFilters.remove(consumer);
                    this.consumerTypes.remove(consumer);
                }
                logger.trace("Removed consumers: {}", (Object)removed.size());
            } else {
                logger.warn("Removed consumers: 0");
            }
            this.recalculateExistingMappings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unsubscribeConsumer(Object subscriber, Consumer<?> consumer) {
        Map<Consumer<?>, Class<?>> map = this.consumerTypes;
        synchronized (map) {
            logger.trace("Trying to remove {} owned by {}", (Object)consumer, subscriber);
            Set<Consumer<?>> consumers = this.subscribers.get(subscriber);
            if (consumers != null) {
                consumers.remove(consumer);
            }
            logger.trace("Removing {} from filters; contains: {}", (Object)consumer, (Object)this.consumerFilters.containsKey(consumer));
            this.consumerFilters.remove(consumer);
            logger.trace("Removing {} from types; contains: {}", (Object)consumer, (Object)this.consumerTypes.containsKey(consumer));
            this.consumerTypes.remove(consumer);
            this.recalculateExistingMappings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unsubscribeConsumer(Object subscriber, Class<?> eventType) {
        Map<Consumer<?>, Class<?>> map = this.consumerTypes;
        synchronized (map) {
            logger.trace("Trying to remove consumer of type {} from {}", (Object)eventType, subscriber);
            Collection consumers = this.subscribers.get(subscriber);
            Consumer<?> foundConsumer = null;
            for (Consumer<?> consumer : this.consumerTypes.keySet()) {
                if (!this.consumerTypes.get(consumer).equals(eventType) || !consumers.contains(consumer)) continue;
                foundConsumer = consumer;
                break;
            }
            if (foundConsumer != null) {
                this.unsubscribeConsumer(subscriber, foundConsumer);
            }
        }
    }
}

