/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.spy.audit;

import java.io.File;
import java.io.IOException;
import pl.baczkowicz.spy.exceptions.SpyException;
import pl.baczkowicz.spy.files.FileUtils;
import pl.baczkowicz.spy.files.StreamedFileReader;

public class StreamedAuditReader {
    private long lines;
    private File file;
    private StreamedFileReader reader = new StreamedFileReader();

    public void openAuditFile(File selectedFile) throws SpyException {
        this.file = selectedFile;
        this.lines = FileUtils.countLines(this.file);
        try {
            this.reader.openFile(this.file);
        }
        catch (IOException e) {
            new SpyException("Cannon open file " + this.file, e);
        }
    }

    public boolean hasNext() throws IOException {
        return this.reader.hasNext();
    }

    public String getNextLine() throws IOException {
        return this.reader.getNextLine();
    }

    public void closeAuditFile() {
        try {
            this.reader.closeFile();
        }
        catch (IOException e) {
            new SpyException("Cannon close file " + this.file, e);
        }
    }

    public long getCount() {
        return this.lines;
    }
}

