/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.mqttspy.common.generated.MessageLog;
import pl.baczkowicz.mqttspy.common.generated.MessageLogEnum;
import pl.baczkowicz.mqttspy.common.generated.MqttConnectionDetails;
import pl.baczkowicz.mqttspy.common.generated.ProtocolVersionEnum;
import pl.baczkowicz.mqttspy.utils.ConnectionUtils;
import pl.baczkowicz.mqttspy.utils.MqttUtils;

public class MqttConfigurationUtils {
    public static final String SPY_COMMON_SCHEMA = "/spy-common.xsd";
    public static final String MQTT_COMMON_SCHEMA = "/mqtt-spy-common.xsd";
    private static final Logger logger = LoggerFactory.getLogger(MqttConfigurationUtils.class);

    public static void completeServerURIs(MqttConnectionDetails connection, boolean sslEnabled, boolean websocket) {
        for (int i = 0; i < connection.getServerURI().size(); ++i) {
            String serverURI = connection.getServerURI().get(i);
            String completeServerURI = MqttUtils.getCompleteServerURI(serverURI, sslEnabled, websocket);
            if (completeServerURI.equals(serverURI)) continue;
            logger.info("Auto-complete for server URI ({} -> {})", (Object)serverURI, (Object)completeServerURI);
            connection.getServerURI().set(i, completeServerURI);
        }
    }

    public static void populateConnectionDefaults(MqttConnectionDetails connection) {
        if (connection.getProtocol() == null) {
            connection.setProtocol(ProtocolVersionEnum.MQTT_DEFAULT);
        }
        if (connection.isWebSocket() == null) {
            connection.setWebSocket(false);
        }
        if (connection.getName() == null || connection.getName().isEmpty()) {
            connection.setName(ConnectionUtils.composeConnectionName(connection.getClientID(), connection.getServerURI()));
        }
        if (connection.isCleanSession() == null) {
            connection.setCleanSession(true);
        }
        if (connection.getConnectionTimeout() == null) {
            connection.setConnectionTimeout(30);
        }
        if (connection.getKeepAliveInterval() == null) {
            connection.setKeepAliveInterval(60);
        }
    }

    public static void populateMessageLogDefaults(MessageLog messageLog) {
        if (messageLog.getValue() == null) {
            messageLog.setValue(MessageLogEnum.DISABLED);
        }
        if (messageLog.isLogConnection() == null) {
            messageLog.setLogConnection(false);
        }
        if (messageLog.isLogQos() == null) {
            messageLog.setLogQos(false);
        }
        if (messageLog.isLogRetained() == null) {
            messageLog.setLogRetained(false);
        }
        if (messageLog.isLogSubscription() == null) {
            messageLog.setLogSubscription(false);
        }
        if (messageLog.isLogBeforeScripts() == null) {
            messageLog.setLogBeforeScripts(false);
        }
    }
}

