/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.utils;

import java.util.List;
import pl.baczkowicz.mqttspy.common.generated.MqttConnectionDetails;
import pl.baczkowicz.mqttspy.common.generated.ProtocolVersionEnum;
import pl.baczkowicz.mqttspy.utils.MqttUtils;

public class ConnectionUtils {
    public static final long NEVER_STARTED = 0L;
    public static final String SERVER_DELIMITER = ";";

    public static String composeConnectionName(String clientId, List<String> serverURIs) {
        return ConnectionUtils.composeConnectionName(clientId, ConnectionUtils.serverURIsToString(serverURIs));
    }

    public static String composeConnectionName(String clientId, String serverURIs) {
        return clientId + "@" + serverURIs;
    }

    public static String serverURIsToString(List<String> serverURIs) {
        StringBuffer serverURIsAsString = new StringBuffer();
        boolean first = true;
        for (String serverURI : serverURIs) {
            if (first) {
                serverURIsAsString.append(serverURI);
            } else {
                serverURIsAsString.append("; " + serverURI);
            }
            first = false;
        }
        return serverURIsAsString.toString();
    }

    public static String validateConnectionDetails(MqttConnectionDetails connectionDetails) {
        boolean emptyClientId;
        if (connectionDetails.getServerURI() == null || connectionDetails.getServerURI().size() == 0) {
            return "Server URI cannot be empty";
        }
        boolean allEmpty = true;
        for (String serverURI : connectionDetails.getServerURI()) {
            if (serverURI.trim().isEmpty()) continue;
            allEmpty = false;
            break;
        }
        if (allEmpty) {
            return "Server URI cannot be empty";
        }
        boolean bl = emptyClientId = connectionDetails.getClientID() == null || connectionDetails.getClientID().trim().isEmpty();
        if (ProtocolVersionEnum.MQTT_3_1_1.equals((Object)connectionDetails.getProtocol()) && emptyClientId) {
            if (!connectionDetails.isCleanSession().booleanValue()) {
                return "Client ID can only be empty when the 'clean session' flag is set";
            }
        } else if (emptyClientId) {
            return "Empty client ID is only allowed in MQTT 3.1.1";
        }
        if (MqttUtils.limitClientId(connectionDetails.getProtocol()) && connectionDetails.getClientID().length() > 23) {
            return "Client ID cannot longer than 23";
        }
        if (connectionDetails.getLastWillAndTestament() != null && (connectionDetails.getLastWillAndTestament().getTopic() == null || connectionDetails.getLastWillAndTestament().getTopic().isEmpty())) {
            return "With last will and testament enabled, publication topic cannot be empty";
        }
        if (connectionDetails.getConnectionTimeout() < 0) {
            return "Connection timeout cannot be less than 0";
        }
        if (connectionDetails.getKeepAliveInterval() < 0) {
            return "Keep alive interval cannot be less than 0";
        }
        return null;
    }
}

