/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.ui.utils;

import java.util.Optional;
import javafx.scene.control.Tooltip;
import javafx.util.Pair;
import pl.baczkowicz.mqttspy.connectivity.MqttAsyncConnection;
import pl.baczkowicz.spy.common.generated.UserCredentials;
import pl.baczkowicz.spy.configuration.BaseConfigurationUtils;
import pl.baczkowicz.spy.connectivity.ConnectionStatus;
import pl.baczkowicz.spy.ui.utils.DialogFactory;

public class DialogUtils {
    public static boolean createMqttUsernameAndPasswordDialog(Object owner, String connectionName, UserCredentials userCredentials) {
        Pair userInfo = new Pair((Object)userCredentials.getUsername(), (Object)BaseConfigurationUtils.decodePassword(userCredentials.getPassword()));
        Optional<Pair<String, String>> response = DialogFactory.createUsernameAndPasswordDialog("MQTT user credentials", "User credentials for connection " + connectionName, (Pair<String, String>)userInfo);
        if (response.isPresent()) {
            userCredentials.setUsername((String)response.get().getKey());
            userCredentials.setPassword(BaseConfigurationUtils.encodePassword((String)response.get().getValue()));
            return true;
        }
        return false;
    }

    public static void updateConnectionTooltip(MqttAsyncConnection connection, Tooltip tooltip) {
        StringBuffer sb = new StringBuffer();
        sb.append("Status: " + connection.getConnectionStatus().toString().toLowerCase());
        if (ConnectionStatus.CONNECTED.equals((Object)connection.getConnectionStatus())) {
            sb.append(" (" + connection.getLastSuccessfulyConnectionAttempt() + ")");
            sb.append(System.getProperty("line.separator"));
            String sslStatus = connection.getProperties().getSSL() != null ? "on" : "off";
            String userAuthStatus = connection.getProperties().getUserCredentials() != null ? "on" : "off";
            sb.append("Security: TLS/SSL is " + sslStatus + "; user authentication is " + userAuthStatus);
        }
        if (connection.getConnectionAttempts() > 1) {
            sb.append(System.getProperty("line.separator"));
            sb.append("Connection attempts: " + connection.getConnectionAttempts());
        }
        if (connection.getDisconnectionReason() != null && !connection.getDisconnectionReason().isEmpty()) {
            sb.append(System.getProperty("line.separator"));
            sb.append("Last error: " + connection.getDisconnectionReason().toLowerCase());
        }
        tooltip.setText(sb.toString());
    }
}

