/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.ui.utils;

import java.util.Arrays;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Tab;
import javafx.scene.paint.Color;
import pl.baczkowicz.mqttspy.configuration.generated.TabbedSubscriptionDetails;
import pl.baczkowicz.mqttspy.connectivity.MqttAsyncConnection;
import pl.baczkowicz.mqttspy.connectivity.MqttSubscription;
import pl.baczkowicz.mqttspy.messages.FormattedMqttMessage;
import pl.baczkowicz.mqttspy.ui.MqttConnectionViewManager;
import pl.baczkowicz.mqttspy.ui.MqttSubscriptionViewManager;
import pl.baczkowicz.mqttspy.ui.controllers.MqttConnectionController;
import pl.baczkowicz.mqttspy.ui.controllers.SubscriptionController;
import pl.baczkowicz.spy.eventbus.IKBus;
import pl.baczkowicz.spy.ui.charts.ChartFactory;
import pl.baczkowicz.spy.ui.charts.ChartMode;
import pl.baczkowicz.spy.ui.configuration.IConfigurationManager;
import pl.baczkowicz.spy.ui.events.ClearTabEvent;
import pl.baczkowicz.spy.ui.events.ShowEditConnectionsWindowEvent;
import pl.baczkowicz.spy.ui.panes.PaneVisibilityStatus;
import pl.baczkowicz.spy.ui.panes.TitledPaneStatus;
import pl.baczkowicz.spy.ui.stats.StatisticsManager;
import pl.baczkowicz.spy.ui.storage.ManagedMessageStoreWithFiltering;
import pl.baczkowicz.spy.ui.utils.DialogFactory;
import pl.baczkowicz.spy.ui.utils.StylingUtils;
import pl.baczkowicz.spy.ui.utils.TabUtils;
import pl.baczkowicz.spy.ui.utils.UiUtils;

public class ContextMenuUtils {
    public static ContextMenu createSubscriptionTabContextMenu(final MqttAsyncConnection connection, final MqttSubscription subscription, final IKBus eventBus, final MqttSubscriptionViewManager subscriptionManager, final IConfigurationManager configurationManager, final SubscriptionController subscriptionController) {
        ContextMenu contextMenu = new ContextMenu();
        MenuItem cancelItem = new MenuItem("Unsubscribe (and keep the tab)");
        cancelItem.setDisable(false);
        cancelItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                connection.unsubscribe(subscription, true);
            }
        });
        contextMenu.getItems().add((Object)cancelItem);
        MenuItem resubscribeItem = new MenuItem("Re-subscribe");
        resubscribeItem.setDisable(true);
        resubscribeItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                connection.resubscribe(subscription);
            }
        });
        contextMenu.getItems().add((Object)resubscribeItem);
        MenuItem closeItem = new MenuItem("Unsubscribe (and close tab)");
        closeItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                subscriptionManager.removeSubscription(subscription.getTopic());
            }
        });
        contextMenu.getItems().add((Object)closeItem);
        contextMenu.getItems().add((Object)new SeparatorMenuItem());
        MenuItem copyTopicItem = new MenuItem("Copy subscription topic to clipboard");
        copyTopicItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                UiUtils.copyToClipboard(subscription.getTopic());
            }
        });
        contextMenu.getItems().add((Object)copyTopicItem);
        contextMenu.getItems().add((Object)new SeparatorMenuItem());
        MenuItem clearItem = new MenuItem("Clear subscription history");
        clearItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                eventBus.publish(new ClearTabEvent(subscription.getStore()));
                StatisticsManager.resetMessagesReceived(connection.getId(), subscription.getTopic());
                ((ManagedMessageStoreWithFiltering)subscription.getStore()).clear();
            }
        });
        contextMenu.getItems().add((Object)clearItem);
        contextMenu.getItems().add((Object)new SeparatorMenuItem());
        Menu chartsMenu = new Menu("Charts");
        contextMenu.getItems().add((Object)chartsMenu);
        MenuItem messageLoadChartItem = new MenuItem("Show message load chart");
        messageLoadChartItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                new ChartFactory<FormattedMqttMessage>().createMessageBasedLineChart(Arrays.asList("5 second average", "30 second average", "5 minute average"), subscriptionController.getStatsHistory(), ChartMode.USER_DRIVEN_MSG_PAYLOAD, "Series", "Load", "msgs/s", "Message load statistics for " + subscription.getTopic() + " - " + connection.getName(), subscriptionController.getScene(), eventBus);
            }
        });
        chartsMenu.getItems().add((Object)messageLoadChartItem);
        MenuItem messageCountChartItem = new MenuItem("Show message count chart");
        messageCountChartItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                new ChartFactory().createMessageBasedPieChart("Message count statistics for " + subscription.getTopic(), subscriptionController.getScene(), ((ManagedMessageStoreWithFiltering)subscriptionController.getSubscription().getStore()).getNonFilteredMessageList().getTopicSummary().getObservableMessagesPerTopic());
            }
        });
        chartsMenu.getItems().add((Object)messageCountChartItem);
        Menu configuration = new Menu("Configuration");
        contextMenu.getItems().add((Object)configuration);
        MenuItem addItem = new MenuItem("Add/update this subscription");
        addItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                configurationManager.updateSubscriptionConfiguration(connection.getId(), subscription);
            }
        });
        configuration.getItems().add((Object)addItem);
        MenuItem removeItem = new MenuItem("Remove this subscription");
        removeItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                configurationManager.deleteSubscriptionConfiguration(connection.getId(), subscription);
            }
        });
        configuration.getItems().add((Object)removeItem);
        Menu view = new Menu("View");
        contextMenu.getItems().add((Object)view);
        MenuItem changeColorMenu = new MenuItem("Change tab color");
        changeColorMenu.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Color newColor = DialogFactory.createColorChoiceDialog(subscription.getColor(), "Select new subscription color", "Subscription color: ");
                if (!newColor.equals((Object)subscription.getColor())) {
                    subscription.setColor(newColor);
                    subscription.getSubscriptionController().getTab().setStyle(StylingUtils.createBaseRGBString(newColor));
                    subscription.getSubscriptionController().getSummaryTablePaneController().refreshRowStyling();
                    subscriptionManager.getSubscriptionControllersMap().get(MqttSubscriptionViewManager.ALL_SUBSCRIPTIONS_TAB_TITLE).getSummaryTablePaneController().refreshRowStyling();
                }
            }
        });
        view.getItems().add((Object)changeColorMenu);
        MenuItem detachMenu = new MenuItem("Detach to a separate window");
        detachMenu.setOnAction(TabUtils.createTabDetachEvent(detachMenu, subscriptionController, connection.getName() + " - " + subscription.getTopic(), 5.0));
        view.getItems().add((Object)detachMenu);
        return contextMenu;
    }

    public static ContextMenu createAllSubscriptionsTabContextMenu(final MqttAsyncConnection connection, final IKBus eventBus, final MqttSubscriptionViewManager subscriptionManager, final IConfigurationManager configurationManager, final SubscriptionController subscriptionController) {
        ContextMenu contextMenu = new ContextMenu();
        MenuItem cancelItem = new MenuItem("Unsubscribe from all active subscriptions (if any)");
        cancelItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                connection.unsubscribeAll(true);
            }
        });
        contextMenu.getItems().add((Object)cancelItem);
        MenuItem resubscribeItem = new MenuItem("Re-subscribe to all non-active subscriptions (if any)");
        resubscribeItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                connection.resubscribeAll(false);
            }
        });
        contextMenu.getItems().add((Object)resubscribeItem);
        contextMenu.getItems().add((Object)new SeparatorMenuItem());
        MenuItem clearItem = new MenuItem("Clear tab history");
        clearItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                eventBus.publish(new ClearTabEvent(connection.getStore()));
                StatisticsManager.resetMessagesReceived(connection.getId());
                connection.getStore().clear();
            }
        });
        contextMenu.getItems().add((Object)clearItem);
        contextMenu.getItems().add((Object)new SeparatorMenuItem());
        Menu charts = new Menu("Charts");
        MenuItem showAllChartItem = new MenuItem("Show overall message load chart");
        showAllChartItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                new ChartFactory<FormattedMqttMessage>().createMessageBasedLineChart(Arrays.asList("5 second average", "30 second average", "5 minute average"), subscriptionController.getStatsHistory(), ChartMode.USER_DRIVEN_MSG_PAYLOAD, "Series", "Load", "msgs/s", "Message load statistics for all subscriptions - " + connection.getName(), subscriptionController.getScene(), eventBus);
            }
        });
        contextMenu.getItems().add((Object)charts);
        charts.getItems().add((Object)showAllChartItem);
        Menu configuration = new Menu("Configuration");
        MenuItem addItem = new MenuItem("Add/update all shown subscriptions");
        addItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                for (SubscriptionController controller : subscriptionManager.getSubscriptionControllers()) {
                    if (controller.getSubscription() == null) continue;
                    configurationManager.updateSubscriptionConfiguration(connection.getId(), controller.getSubscription());
                }
            }
        });
        contextMenu.getItems().add((Object)configuration);
        configuration.getItems().add((Object)addItem);
        MenuItem removeItem = new MenuItem("Remove all shown subscriptions");
        removeItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                for (SubscriptionController controller : subscriptionManager.getSubscriptionControllers()) {
                    if (controller.getSubscription() == null) continue;
                    configurationManager.deleteSubscriptionConfiguration(connection.getId(), controller.getSubscription());
                }
            }
        });
        configuration.getItems().add((Object)removeItem);
        return contextMenu;
    }

    private static Menu createConnectionPaneMenu(String name, final MqttConnectionController connectionController, final TitledPaneStatus status) {
        Menu menu = new Menu(name);
        status.setContentMenu(menu);
        CheckMenuItem hidden = new CheckMenuItem("Hidden");
        hidden.setSelected(true);
        CheckMenuItem visible = new CheckMenuItem("Visible (attached to connection tab)");
        CheckMenuItem detached = new CheckMenuItem("Visible (detached from connection tab)");
        menu.getItems().add((Object)hidden);
        menu.getItems().add((Object)visible);
        menu.getItems().add((Object)detached);
        hidden.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                connectionController.setPaneVisiblity(status, PaneVisibilityStatus.NOT_VISIBLE);
            }
        });
        visible.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                connectionController.setPaneVisiblity(status, PaneVisibilityStatus.ATTACHED);
            }
        });
        detached.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                connectionController.setPaneVisiblity(status, PaneVisibilityStatus.DETACHED);
            }
        });
        return menu;
    }

    public static ContextMenu createConnectionMenu(final MqttAsyncConnection connection, final IKBus eventBus, final MqttConnectionController connectionController, MqttConnectionViewManager connectionManager) {
        ContextMenu contextMenu = new ContextMenu();
        MenuItem reconnectItem = new MenuItem("Connect / reconnect");
        reconnectItem.setOnAction(MqttConnectionViewManager.createConnectAction(connectionManager, connection));
        MenuItem disconnectItem = new MenuItem("Disconnect (and keep tab)");
        disconnectItem.setOnAction(MqttConnectionViewManager.createDisconnectAction(connectionManager, connection));
        MenuItem disconnectAndCloseItem = new MenuItem("Disconnect (and close tab)");
        disconnectAndCloseItem.setOnAction(MqttConnectionViewManager.createDisconnectAndCloseAction(connectionManager, connection));
        contextMenu.getItems().add((Object)reconnectItem);
        contextMenu.getItems().add((Object)new SeparatorMenuItem());
        contextMenu.getItems().add((Object)disconnectItem);
        contextMenu.getItems().add((Object)disconnectAndCloseItem);
        contextMenu.getItems().add((Object)new SeparatorMenuItem());
        MenuItem stats = new MenuItem("Show broker's statistics");
        stats.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                TabbedSubscriptionDetails subscriptionDetails = new TabbedSubscriptionDetails();
                subscriptionDetails.setTopic("$SYS/#");
                subscriptionDetails.setQos(0);
                connectionController.getNewSubscriptionPaneController().subscribe(subscriptionDetails, true);
            }
        });
        contextMenu.getItems().add((Object)stats);
        contextMenu.getItems().add((Object)new SeparatorMenuItem());
        Menu view = new Menu("View");
        contextMenu.getItems().add((Object)view);
        MenuItem detachMenu = new MenuItem("Detach to a separate window");
        detachMenu.setOnAction(TabUtils.createTabDetachEvent(detachMenu, connectionController, "Connection " + connection.getName(), 0.0));
        view.getItems().add((Object)detachMenu);
        view.getItems().add((Object)new SeparatorMenuItem());
        MenuItem detailedView = new MenuItem("Toggle between simplified and detailed views (QoS, Retained)");
        view.getItems().add((Object)detailedView);
        final CheckMenuItem resizeMessageContent = connectionController.getResizeMessageContentMenu();
        resizeMessageContent.setText("Resizable message pane");
        resizeMessageContent.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                connectionController.toggleMessagePayloadSize(resizeMessageContent.isSelected());
            }
        });
        view.getItems().add((Object)resizeMessageContent);
        view.getItems().add((Object)new SeparatorMenuItem());
        Menu panes = new Menu("Panes");
        Menu manualPublications = ContextMenuUtils.createConnectionPaneMenu("'Publish message' pane", connectionController, connectionController.getNewPublicationPaneStatus());
        Menu scriptedPublications = ContextMenuUtils.createConnectionPaneMenu("'Scripted publications' pane", connectionController, connectionController.getPublicationScriptsPaneStatus());
        Menu newSubscription = ContextMenuUtils.createConnectionPaneMenu("'Define new subscription' pane", connectionController, connectionController.getNewSubscriptionPaneStatus());
        Menu messageSummary = ContextMenuUtils.createConnectionPaneMenu("'Subscriptions and received messages' pane", connectionController, connectionController.getSubscriptionsStatus());
        Menu testCases = ContextMenuUtils.createConnectionPaneMenu("'Test cases' pane", connectionController, connectionController.getTestCasesPaneStatus());
        panes.getItems().add((Object)manualPublications);
        panes.getItems().add((Object)scriptedPublications);
        panes.getItems().add((Object)newSubscription);
        panes.getItems().add((Object)messageSummary);
        panes.getItems().add((Object)testCases);
        detailedView.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                connectionController.toggleDetailedViewVisibility();
            }
        });
        view.getItems().add((Object)panes);
        contextMenu.getItems().add((Object)new SeparatorMenuItem());
        MenuItem editItem = new MenuItem("Edit...");
        editItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                eventBus.publish(new ShowEditConnectionsWindowEvent(connectionController.getTab().getTabPane().getScene().getWindow(), false, connection.getProperties().getConfiguredProperties()));
            }
        });
        contextMenu.getItems().add((Object)editItem);
        return contextMenu;
    }

    public static ContextMenu createMessageLogMenu(Tab tab, final MqttConnectionController connectionController, final MqttConnectionViewManager connectionManager) {
        ContextMenu contextMenu = new ContextMenu();
        MenuItem closedItem = new MenuItem("Close");
        closedItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                connectionManager.closeOfflineTab(connectionController);
            }
        });
        contextMenu.getItems().add((Object)closedItem);
        contextMenu.getItems().add((Object)new SeparatorMenuItem());
        Menu view = new Menu("View");
        contextMenu.getItems().add((Object)view);
        MenuItem detachMenu = new MenuItem("Detach to a separate window");
        detachMenu.setOnAction(TabUtils.createTabDetachEvent(detachMenu, connectionController, "Message audit " + tab.getText(), 0.0));
        view.getItems().add((Object)detachMenu);
        final CheckMenuItem resizeMessageContent = connectionController.getResizeMessageContentMenu();
        resizeMessageContent.setText("Resizable message pane");
        resizeMessageContent.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                connectionController.toggleMessagePayloadSize(resizeMessageContent.isSelected());
            }
        });
        view.getItems().add((Object)resizeMessageContent);
        return contextMenu;
    }
}

