/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.ui.scripts;

import java.util.ArrayList;
import java.util.List;
import pl.baczkowicz.mqttspy.configuration.generated.TabbedSubscriptionDetails;
import pl.baczkowicz.mqttspy.connectivity.IMqttConnection;
import pl.baczkowicz.mqttspy.scripts.MqttScriptManager;
import pl.baczkowicz.spy.common.generated.ScriptDetails;
import pl.baczkowicz.spy.eventbus.IKBus;
import pl.baczkowicz.spy.exceptions.SpyException;
import pl.baczkowicz.spy.scripts.Script;
import pl.baczkowicz.spy.ui.scripts.InteractiveBaseScriptManager;
import pl.baczkowicz.spy.ui.scripts.ScriptTypeEnum;
import pl.baczkowicz.spy.ui.utils.RunLaterExecutor;

public class InteractiveMqttScriptManager
extends InteractiveBaseScriptManager {
    private IMqttConnection connection;

    public InteractiveMqttScriptManager(IKBus eventBus, IMqttConnection connection) {
        super(eventBus, new RunLaterExecutor());
        this.connection = connection;
    }

    public void addSubscriptionScripts(List<TabbedSubscriptionDetails> list) {
        ArrayList<ScriptDetails> scripts = new ArrayList<ScriptDetails>();
        for (TabbedSubscriptionDetails sub : list) {
            if (sub.getScriptFile() == null || sub.getScriptFile().trim().isEmpty()) continue;
            scripts.add(new ScriptDetails(false, false, sub.getScriptFile()));
        }
        this.addScripts(scripts, ScriptTypeEnum.SUBSCRIPTION);
    }

    public IMqttConnection getConnection() {
        return this.connection;
    }

    public void setConnection(IMqttConnection connection) {
        this.connection = connection;
    }

    @Override
    public void populateEngineVariables(Script script) throws SpyException {
        MqttScriptManager.populateEngineVariables(script, this.connection, this.eventBus, this.executor);
    }
}

