/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.ui.messagelog;

import java.util.Collection;
import java.util.List;
import pl.baczkowicz.mqttspy.common.generated.MessageLog;
import pl.baczkowicz.mqttspy.common.generated.MessageLogEnum;
import pl.baczkowicz.mqttspy.logger.SimpleMqttMessageLogComposer;
import pl.baczkowicz.mqttspy.messages.FormattedMqttMessage;
import pl.baczkowicz.spy.messages.FormattedMessage;
import pl.baczkowicz.spy.ui.storage.BasicMessageStoreWithSummary;
import pl.baczkowicz.spy.ui.storage.MessageAuditUtils;

public class MqttMessageAuditUtils
implements MessageAuditUtils {
    @Override
    public String getCurrentMessageAsMessageLog(BasicMessageStoreWithSummary<? extends FormattedMessage> store, int messageIndex) {
        FormattedMessage message = (FormattedMessage)store.getMessages().get(messageIndex);
        if (message instanceof FormattedMqttMessage) {
            return SimpleMqttMessageLogComposer.createReceivedMessageLog((FormattedMqttMessage)message, new MessageLog(MessageLogEnum.XML_WITH_PLAIN_PAYLOAD, "", true, true, false, false, false));
        }
        return null;
    }

    @Override
    public String getAllMessagesAsMessageLog(BasicMessageStoreWithSummary<? extends FormattedMessage> store) {
        StringBuffer messagesAsString = new StringBuffer();
        List messages = store.getMessages();
        for (int i = messages.size() - 1; i >= 0; --i) {
            if (messages.get(i) instanceof FormattedMqttMessage) {
                FormattedMqttMessage message = (FormattedMqttMessage)messages.get(i);
                messagesAsString.append(SimpleMqttMessageLogComposer.createReceivedMessageLog(message, new MessageLog(MessageLogEnum.XML_WITH_ENCODED_PAYLOAD, "", true, true, false, false, false)));
            }
            messagesAsString.append(System.lineSeparator());
        }
        return messagesAsString.toString();
    }

    public static String getAllTopicsAsString(Collection<String> topics) {
        StringBuffer messages = new StringBuffer();
        for (String topic : topics) {
            messages.append(topic);
            messages.append(System.lineSeparator());
        }
        return messages.toString();
    }
}

