/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.ui.messagelog;

import java.io.File;
import java.util.List;
import javafx.application.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.mqttspy.common.generated.LoggedMqttMessage;
import pl.baczkowicz.mqttspy.logger.MqttMessageLogParserUtils;
import pl.baczkowicz.mqttspy.messages.BaseMqttMessage;
import pl.baczkowicz.mqttspy.ui.MqttViewManager;
import pl.baczkowicz.mqttspy.ui.controllers.MqttSpyMainController;
import pl.baczkowicz.spy.files.FileUtils;
import pl.baczkowicz.spy.ui.storage.TaskWithProgressUpdater;
import pl.baczkowicz.spy.utils.ThreadingUtils;

public class LogReaderTask
extends TaskWithProgressUpdater<List<BaseMqttMessage>> {
    private static final Logger logger = LoggerFactory.getLogger(LogReaderTask.class);
    private File selectedFile;
    protected MqttViewManager viewManager;
    protected MqttSpyMainController controller;

    public LogReaderTask(File selectedFile, MqttViewManager viewManager, MqttSpyMainController mainController) {
        this.selectedFile = selectedFile;
        this.viewManager = viewManager;
        this.controller = mainController;
        super.updateTitle("Processing message audit log file " + selectedFile.getName());
    }

    protected List<BaseMqttMessage> call() throws Exception {
        try {
            this.updateMessage("Please wait - reading message audit log [1/4]");
            this.updateProgress(0L, 4L);
            List<String> fileContent = FileUtils.readFileAsLines(this.selectedFile);
            long totalItems = fileContent.size();
            this.updateProgress(totalItems, totalItems * 4L);
            if (this.isCancelled()) {
                logger.info("Task cancelled!");
                return null;
            }
            this.updateMessage("Please wait - parsing " + fileContent.size() + " messages [2/4]");
            List<LoggedMqttMessage> loggedMessages = MqttMessageLogParserUtils.parseMessageLog(fileContent, this, totalItems, totalItems * 4L);
            this.updateProgress(totalItems * 2L, totalItems * 4L);
            if (this.isCancelled()) {
                logger.info("Task cancelled!");
                return null;
            }
            this.updateMessage("Please wait - processing " + loggedMessages.size() + " messages [3/4]");
            final List<BaseMqttMessage> processedMessages = MqttMessageLogParserUtils.processMessageLog(loggedMessages, this, totalItems * 2L, totalItems * 4L);
            this.updateProgress(totalItems * 3L, totalItems * 4L);
            if (this.isCancelled()) {
                logger.info("Task cancelled!");
                return null;
            }
            this.updateMessage("Please wait - displaying " + loggedMessages.size() + " messages [4/4]");
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    LogReaderTask.this.viewManager.loadMessageLogTab(LogReaderTask.this.controller, LogReaderTask.this.selectedFile.getName(), processedMessages);
                }
            });
            this.updateMessage("Finished!");
            this.updateProgress(4L, 4L);
            ThreadingUtils.sleep(500L);
            return processedMessages;
        }
        catch (Exception e) {
            logger.error("Cannot process the message audit log - {}", (Object)this.selectedFile.getName(), (Object)e);
            return null;
        }
    }
}

