/*
 * Decompiled with CFR 0.152.
 */
package pl.baczkowicz.mqttspy.ui.controllers.edit;

import java.io.File;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.layout.AnchorPane;
import javafx.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.baczkowicz.mqttspy.configuration.ConfiguredMqttConnectionDetails;
import pl.baczkowicz.mqttspy.configuration.generated.TabbedSubscriptionDetails;
import pl.baczkowicz.mqttspy.configuration.generated.UserInterfaceMqttConnectionDetails;
import pl.baczkowicz.mqttspy.ui.controllers.EditMqttConnectionController;
import pl.baczkowicz.mqttspy.ui.controllers.edit.IEditConnectionSubController;
import pl.baczkowicz.spy.ui.properties.BaseTopicProperty;
import pl.baczkowicz.spy.ui.properties.SubscriptionTopicProperties;
import pl.baczkowicz.spy.ui.utils.DialogFactory;

public class EditConnectionSubscriptionsController
extends AnchorPane
implements Initializable,
IEditConnectionSubController {
    private static final Logger logger = LoggerFactory.getLogger(EditConnectionSubscriptionsController.class);
    private EditMqttConnectionController parent;
    @FXML
    private Button removeSubscriptionButton;
    @FXML
    private TextField searchScriptsText;
    @FXML
    private TableView<SubscriptionTopicProperties> subscriptionsTable;
    @FXML
    private TableColumn<SubscriptionTopicProperties, String> subscriptionTopicColumn;
    @FXML
    private TableColumn<SubscriptionTopicProperties, String> scriptColumn;
    @FXML
    private TableColumn<SubscriptionTopicProperties, Integer> qosSubscriptionColumn;
    @FXML
    private TableColumn<SubscriptionTopicProperties, Boolean> createTabSubscriptionColumn;
    private final ChangeListener basicOnChangeListener = new ChangeListener(){

        public void changed(ObservableValue observable, Object oldValue, Object newValue) {
            EditConnectionSubscriptionsController.this.onChange();
        }
    };

    public void initialize(URL location, ResourceBundle resources) {
        this.searchScriptsText.textProperty().addListener(this.basicOnChangeListener);
        this.createTabSubscriptionColumn.setCellValueFactory((Callback)new PropertyValueFactory("show"));
        this.createTabSubscriptionColumn.setCellFactory((Callback)new Callback<TableColumn<SubscriptionTopicProperties, Boolean>, TableCell<SubscriptionTopicProperties, Boolean>>(){

            public TableCell<SubscriptionTopicProperties, Boolean> call(TableColumn<SubscriptionTopicProperties, Boolean> p) {
                TableCell<SubscriptionTopicProperties, Boolean> cell = new TableCell<SubscriptionTopicProperties, Boolean>(){

                    public void updateItem(Boolean item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (!this.isEmpty()) {
                            final SubscriptionTopicProperties shownItem = (SubscriptionTopicProperties)this.getTableView().getItems().get(this.getIndex());
                            CheckBox box = new CheckBox();
                            box.selectedProperty().bindBidirectional((Property)shownItem.showProperty());
                            box.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                                public void handle(ActionEvent event) {
                                    logger.info("New value = {} {}", (Object)shownItem.topicProperty().getValue(), (Object)shownItem.showProperty().getValue());
                                    EditConnectionSubscriptionsController.this.onChange();
                                }
                            });
                            this.setGraphic((Node)box);
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
                cell.setAlignment(Pos.CENTER);
                return cell;
            }
        });
        this.subscriptionTopicColumn.setCellValueFactory((Callback)new PropertyValueFactory("topic"));
        this.subscriptionTopicColumn.setCellFactory(TextFieldTableCell.forTableColumn());
        this.subscriptionTopicColumn.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<SubscriptionTopicProperties, String>>(){

            public void handle(TableColumn.CellEditEvent<SubscriptionTopicProperties, String> event) {
                BaseTopicProperty p = (BaseTopicProperty)event.getRowValue();
                String newValue = (String)event.getNewValue();
                p.topicProperty().set(newValue);
                logger.debug("New value = {}", (Object)((SubscriptionTopicProperties)EditConnectionSubscriptionsController.this.subscriptionsTable.getSelectionModel().getSelectedItem()).topicProperty().getValue());
                EditConnectionSubscriptionsController.this.onChange();
            }
        });
        this.scriptColumn.setCellValueFactory((Callback)new PropertyValueFactory("script"));
        this.scriptColumn.setCellFactory(TextFieldTableCell.forTableColumn());
        this.scriptColumn.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<SubscriptionTopicProperties, String>>(){

            public void handle(TableColumn.CellEditEvent<SubscriptionTopicProperties, String> event) {
                String newValue = (String)event.getNewValue();
                File scriptFile = new File(newValue);
                if (!newValue.isEmpty() && !scriptFile.exists()) {
                    DialogFactory.createExceptionDialog("File does not exist", "Could not locate the specified file - please check the name and the path.", "File named " + scriptFile.getName() + " does not exist at " + scriptFile.getAbsolutePath() + "!");
                    event.consume();
                    ((SubscriptionTopicProperties)EditConnectionSubscriptionsController.this.subscriptionsTable.getSelectionModel().getSelectedItem()).scriptProperty().setValue("");
                } else {
                    SubscriptionTopicProperties p = (SubscriptionTopicProperties)event.getRowValue();
                    p.scriptProperty().set(newValue);
                    logger.debug("New value = {}", (Object)((SubscriptionTopicProperties)EditConnectionSubscriptionsController.this.subscriptionsTable.getSelectionModel().getSelectedItem()).scriptProperty().getValue());
                    EditConnectionSubscriptionsController.this.onChange();
                }
            }
        });
        final ObservableList qosChoice = FXCollections.observableArrayList((Object[])new Integer[]{new Integer(0), new Integer(1), new Integer(2)});
        this.qosSubscriptionColumn.setCellValueFactory((Callback)new PropertyValueFactory("qos"));
        this.qosSubscriptionColumn.setCellFactory((Callback)new Callback<TableColumn<SubscriptionTopicProperties, Integer>, TableCell<SubscriptionTopicProperties, Integer>>(){

            public TableCell<SubscriptionTopicProperties, Integer> call(TableColumn<SubscriptionTopicProperties, Integer> p) {
                TableCell<SubscriptionTopicProperties, Integer> cell = new TableCell<SubscriptionTopicProperties, Integer>(){

                    public void updateItem(Integer item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (!this.isEmpty()) {
                            final SubscriptionTopicProperties shownItem = (SubscriptionTopicProperties)this.getTableView().getItems().get(this.getIndex());
                            ChoiceBox box = new ChoiceBox();
                            box.setItems(qosChoice);
                            box.setId("subscriptionQosChoice");
                            int qos = shownItem.qosProperty().getValue();
                            box.getSelectionModel().select(qos);
                            box.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Integer>(){

                                public void changed(ObservableValue<? extends Integer> observable, Integer oldValue, Integer newValue) {
                                    shownItem.qosProperty().setValue((Number)newValue);
                                    logger.info("New value = {} {}", (Object)shownItem.topicProperty().getValue(), (Object)shownItem.qosProperty().getValue());
                                    EditConnectionSubscriptionsController.this.onChange();
                                }
                            });
                            this.setGraphic((Node)box);
                        } else {
                            this.setGraphic(null);
                        }
                    }
                };
                cell.setAlignment(Pos.CENTER);
                return cell;
            }
        });
        this.qosSubscriptionColumn.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<SubscriptionTopicProperties, Integer>>(){

            public void handle(TableColumn.CellEditEvent<SubscriptionTopicProperties, Integer> event) {
                SubscriptionTopicProperties p = (SubscriptionTopicProperties)event.getRowValue();
                Integer newValue = (Integer)event.getNewValue();
                p.qosProperty().set(newValue.intValue());
                logger.debug("New value = {}", (Object)((SubscriptionTopicProperties)EditConnectionSubscriptionsController.this.subscriptionsTable.getSelectionModel().getSelectedItem()).qosProperty().getValue());
                EditConnectionSubscriptionsController.this.onChange();
            }
        });
    }

    public void init() {
    }

    @FXML
    private void addSubscription() {
        SubscriptionTopicProperties item = new SubscriptionTopicProperties("/sampleSubscription/", "", 0, false);
        this.subscriptionsTable.getItems().add((Object)item);
        this.onChange();
    }

    @FXML
    private void removeSubscription() {
        SubscriptionTopicProperties item = (SubscriptionTopicProperties)this.subscriptionsTable.getSelectionModel().getSelectedItem();
        if (item != null) {
            this.subscriptionsTable.getItems().remove((Object)item);
            this.onChange();
        }
    }

    public void onChange() {
        this.parent.onChange();
    }

    @Override
    public UserInterfaceMqttConnectionDetails readValues(UserInterfaceMqttConnectionDetails connection) {
        connection.setSearchScripts(this.searchScriptsText.getText());
        for (SubscriptionTopicProperties subscriptionDetails : this.subscriptionsTable.getItems()) {
            TabbedSubscriptionDetails newSubscriptionDetails = new TabbedSubscriptionDetails();
            newSubscriptionDetails.setTopic(subscriptionDetails.topicProperty().getValue());
            newSubscriptionDetails.setScriptFile(subscriptionDetails.scriptProperty().getValue());
            newSubscriptionDetails.setCreateTab(subscriptionDetails.showProperty().getValue());
            newSubscriptionDetails.setQos(subscriptionDetails.qosProperty().getValue());
            connection.getSubscription().add(newSubscriptionDetails);
        }
        return connection;
    }

    @Override
    public void displayConnectionDetails(ConfiguredMqttConnectionDetails connection) {
        this.searchScriptsText.setText(connection.getSearchScripts());
        this.removeSubscriptionButton.setDisable(true);
        this.subscriptionsTable.getItems().clear();
        for (TabbedSubscriptionDetails sub : connection.getSubscription()) {
            this.subscriptionsTable.getItems().add((Object)new SubscriptionTopicProperties(sub.getTopic(), sub.getScriptFile() == null ? "" : sub.getScriptFile(), sub.getQos(), sub.isCreateTab()));
        }
        this.subscriptionsTable.getSelectionModel().selectedItemProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observable, Object oldValue, Object newValue) {
                EditConnectionSubscriptionsController.this.removeSubscriptionButton.setDisable(false);
            }
        });
    }

    @Override
    public void setParent(EditMqttConnectionController controller) {
        this.parent = controller;
    }
}

